/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class Buffer {
    protected int bufferNumber;
    private ByteBuffer data;
    protected float playTime;

    protected Buffer(int n) {
        this.bufferNumber = n;
    }

    public void configure(ByteBuffer byteBuffer, int n, int n2, float f) {
        this.data = byteBuffer;
        AL10.alBufferData((int)this.bufferNumber, (int)n, (ByteBuffer)byteBuffer, (int)n2);
        this.playTime = f;
    }

    public void delete() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        intBuffer.put(this.bufferNumber);
        intBuffer.rewind();
        AL10.alDeleteBuffers((IntBuffer)intBuffer);
    }

    public int getBitDepth() {
        return AL10.alGetBufferi((int)this.bufferNumber, (int)8194);
    }

    public int getNumChannels() {
        return AL10.alGetBufferi((int)this.bufferNumber, (int)8195);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        return AL10.alGetBufferi((int)this.bufferNumber, (int)8193);
    }

    public int getSize() {
        return AL10.alGetBufferi((int)this.bufferNumber, (int)8196);
    }

    public int getBufferNumber() {
        return this.bufferNumber;
    }

    public float getDuration() {
        return this.playTime;
    }

    public static Buffer[] generateBuffers(int n) {
        Buffer[] bufferArray = new Buffer[n];
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)n);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(intBuffer.get(i));
        }
        return bufferArray;
    }
}

