/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jmex.sound.openAL.objects.util.JMEAudioInputStream;
import com.jmex.sound.openAL.objects.util.dsp.Filter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OggInputStream
extends JMEAudioInputStream {
    public static final int FORMAT_MONO16 = 1;
    public static final int FORMAT_STEREO16 = 2;
    private float[][][] _pcm = new float[1][][];
    private int[] _index;
    private boolean eos = false;
    private SyncState syncState = new SyncState();
    private StreamState streamState = new StreamState();
    private Page page = new Page();
    private Packet packet = new Packet();
    private Info info = new Info();
    private Comment comment = new Comment();
    private DspState dspState = new DspState();
    private Block block = new Block(this.dspState);
    private static int bufsize = 8192;
    private static int convsize = bufsize * 2;
    private static byte[] convbuffer = new byte[convsize];
    private int convbufferOff = 0;
    private int convbufferSize = 0;
    private byte[] readDummy = new byte[1];
    private float length;

    public OggInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        try {
            this.initVorbis();
            this._index = new int[this.info.channels];
        }
        catch (IOException iOException) {
            this.eos = true;
            throw iOException;
        }
    }

    public int getFormat() {
        if (this.info.channels == 1) {
            return 1;
        }
        return 2;
    }

    public int getRate() {
        return this.info.rate;
    }

    public int read() throws IOException {
        int n = this.read(this.readDummy, 0, 1);
        return n == -1 ? -1 : this.readDummy[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        int n3 = 0;
        while (!this.eos && n2 > 0) {
            this.fillConvbuffer();
            if (this.eos) continue;
            int n4 = Math.min(n2, this.convbufferSize - this.convbufferOff);
            System.arraycopy(convbuffer, this.convbufferOff, byArray, n, n4);
            this.convbufferOff += n4;
            n3 += n4;
            n2 -= n4;
            n += n4;
        }
        return n3;
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        byteBuffer.position(n);
        int n3 = 0;
        while (!this.eos && n2 > 0) {
            this.fillConvbuffer();
            if (this.eos) continue;
            int n4 = Math.min(n2, this.convbufferSize - this.convbufferOff);
            int n5 = this.filters.size();
            for (int i = 0; i < n5; ++i) {
                convbuffer = ((Filter)this.filters.get(i)).filter(convbuffer);
            }
            byteBuffer.put(convbuffer, this.convbufferOff, n4);
            this.convbufferOff += n4;
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    private void fillConvbuffer() throws IOException {
        if (this.convbufferOff >= this.convbufferSize) {
            this.convbufferSize = this.lazyDecodePacket();
            this.convbufferOff = 0;
            if (this.convbufferSize == -1) {
                this.eos = true;
            }
        }
    }

    public int available() throws IOException {
        return this.eos ? 0 : 1;
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long l) throws IOException {
        int n = 0;
        while ((long)n < l) {
            this.read();
            if (this.read() == -1) break;
            ++n;
        }
        return n;
    }

    private void initVorbis() throws IOException {
        this.syncState.init();
        int n = this.syncState.buffer(bufsize);
        byte[] byArray = this.syncState.data;
        int n2 = this.in.read(byArray, n, bufsize);
        this.syncState.wrote(n2);
        if (this.syncState.pageout(this.page) != 1) {
            if (n2 < bufsize) {
                return;
            }
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.streamState.init(this.page.serialno());
        this.info.init();
        this.comment.init();
        if (this.streamState.pagein(this.page) < 0) {
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.streamState.packetout(this.packet) != 1) {
            throw new IOException("Error reading initial header packet.");
        }
        if (this.info.synthesis_headerin(this.comment, this.packet) < 0) {
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
        int n3 = 0;
        while (n3 < 2) {
            int n4;
            while (n3 < 2 && (n4 = this.syncState.pageout(this.page)) != 0) {
                if (n4 != 1) continue;
                this.streamState.pagein(this.page);
                while (n3 < 2 && (n4 = this.streamState.packetout(this.packet)) != 0) {
                    if (n4 == -1) {
                        throw new IOException("Corrupt secondary header. Exiting.");
                    }
                    this.info.synthesis_headerin(this.comment, this.packet);
                    ++n3;
                }
            }
            byArray = this.syncState.data;
            n = this.syncState.buffer(bufsize);
            n2 = this.in.read(byArray, n, bufsize);
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 == 0 && n3 < 2) {
                throw new IOException("End of file before finding all Vorbis headers!");
            }
            this.syncState.wrote(n2);
        }
        convsize = bufsize / this.info.channels;
        this.dspState.synthesis_init(this.info);
        this.block.init(this.dspState);
    }

    private int decodePacket(Packet packet) {
        int n;
        boolean bl;
        boolean bl2 = bl = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        if (this.block.synthesis(packet) == 0) {
            this.dspState.synthesis_blockin(this.block);
        }
        int n2 = 0;
        while ((n = this.dspState.synthesis_pcmout(this._pcm, this._index)) > 0) {
            float[][] fArray = this._pcm[0];
            int n3 = n < convsize ? n : convsize;
            for (int i = 0; i < this.info.channels; ++i) {
                int n4 = (i << 1) + n2;
                int n5 = this._index[i];
                for (int j = 0; j < n3; ++j) {
                    int n6 = (int)((double)fArray[i][n5 + j] * 32767.0);
                    OggInputStream.convbuffer[n4 + 0] = (byte)(bl ? n6 >>> 8 : (n6 |= (n6 = Math.max(Short.MIN_VALUE, Math.min(Short.MAX_VALUE, n6))) < 0 ? 32768 : 0));
                    OggInputStream.convbuffer[n4 + 1] = (byte)(bl ? n6 : n6 >>> 8);
                    n4 += this.info.channels << 1;
                }
            }
            n2 += 2 * this.info.channels * n3;
            this.dspState.synthesis_read(n3);
        }
        return n2;
    }

    private int lazyDecodePacket() throws IOException {
        int n = this.getNextPacket(this.packet);
        if (n == -1) {
            return -1;
        }
        return this.decodePacket(this.packet);
    }

    private int getNextPacket(Packet packet) throws IOException {
        boolean bl = false;
        while (!this.eos && !bl) {
            int n = this.streamState.packetout(packet);
            if (n == 0) {
                int n2 = this.syncState.pageout(this.page);
                if (n2 == 0 && this.page.eos() != 0) {
                    return -1;
                }
                if (n2 == 0) {
                    this.fetchData();
                    continue;
                }
                if (n2 == -1) {
                    System.out.println("syncState.pageout(page) result == -1");
                    return -1;
                }
                this.streamState.pagein(this.page);
                continue;
            }
            if (n == -1) {
                System.out.println("streamState.packetout(packet) result == -1");
                return -1;
            }
            bl = true;
        }
        return 0;
    }

    private void fetchData() throws IOException {
        if (!this.eos) {
            int n = this.syncState.buffer(bufsize);
            int n2 = this.in.read(this.syncState.data, n, bufsize);
            this.syncState.wrote(n2);
            if (n2 == 0) {
                this.eos = true;
            }
        }
    }

    public String toString() {
        String string = "";
        string = string + "version         " + this.info.version + "\n";
        string = string + "channels        " + this.info.channels + "\n";
        string = string + "rate (hz)       " + this.info.rate;
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream("D:/eclipse/workspace/JMonkeyEngine/data/sound/CHAR_CRE_1.ogg");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
            byteArrayOutputStream.reset();
            byte[] byArray = new byte[4096];
            OggInputStream oggInputStream = new OggInputStream(fileInputStream);
            boolean bl = false;
            while (!bl) {
                int n = oggInputStream.read(byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                bl = n != byArray.length || n < 0;
            }
            System.out.println(byteArrayOutputStream.size() + " bytes read");
            System.out.println(oggInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Info getInfo() {
        return this.info;
    }

    public int getChannels() {
        if (this.info.channels == 1) {
            return 4353;
        }
        return 4355;
    }

    public int rate() {
        return this.info.rate;
    }

    public int getAudioChannels() {
        return this.info.channels;
    }

    protected void setLength(float f) {
        this.length = f;
    }

    public float getLength() {
        return this.length;
    }
}

