/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util;

import com.jcraft.jorbis.VorbisFile;
import com.jmex.sound.openAL.objects.util.JMEAudioInputStream;
import com.jmex.sound.openAL.objects.util.OggInputStream;
import com.jmex.sound.openAL.objects.util.WavInputStream;
import com.jmex.sound.openAL.objects.util.dsp.BandpassFilter;
import com.jmex.sound.openAL.objects.util.dsp.Equalizer;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class StreamPlayer {
    private static StreamPlayer instance = new StreamPlayer();
    private Player[] player;
    private Equalizer equalizer;
    private BandpassFilter filter;

    private StreamPlayer() {
    }

    public static StreamPlayer getInstance() {
        return instance;
    }

    public void setEqualizer(Equalizer equalizer) {
        if (this.equalizer == null) {
            this.equalizer = equalizer;
        }
    }

    public int openStream(String string) {
        JMEAudioInputStream jMEAudioInputStream = this.open(string, true);
        if (jMEAudioInputStream == null) {
            return -1;
        }
        int n = this.add(jMEAudioInputStream);
        if (this.equalizer != null) {
            this.filter = new BandpassFilter(this.equalizer.getFrequencies());
            this.filter.init(jMEAudioInputStream.rate());
            this.equalizer.addFilter(n, this.filter);
            jMEAudioInputStream.addFilter(this.filter);
        }
        jMEAudioInputStream.setFileName(string);
        return n;
    }

    public int openStream(URL uRL) {
        JMEAudioInputStream jMEAudioInputStream = null;
        jMEAudioInputStream = this.open(uRL, true);
        if (jMEAudioInputStream == null) {
            return -1;
        }
        int n = this.add(jMEAudioInputStream);
        if (this.equalizer != null) {
            this.filter = new BandpassFilter(this.equalizer.getFrequencies());
            this.filter.init(jMEAudioInputStream.rate());
            this.equalizer.addFilter(n, this.filter);
            jMEAudioInputStream.addFilter(this.filter);
        }
        return n;
    }

    private JMEAudioInputStream open(URL uRL, boolean bl) {
        JMEAudioInputStream jMEAudioInputStream = null;
        try {
            jMEAudioInputStream = this.reopenOgg(uRL, bl);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("Input does not appear to be an Ogg bitstream.")) {
                try {
                    jMEAudioInputStream = this.reopenWav(uRL, bl);
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        jMEAudioInputStream.setURL(uRL);
        return jMEAudioInputStream;
    }

    private JMEAudioInputStream open(String string, boolean bl) {
        JMEAudioInputStream jMEAudioInputStream = null;
        try {
            jMEAudioInputStream = this.reopenOgg(string, bl);
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("Input does not appear to be an Ogg bitstream.")) {
                try {
                    jMEAudioInputStream = this.reopenWav(string, bl);
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        if (jMEAudioInputStream != null) {
            jMEAudioInputStream.setFileName(string);
        }
        return jMEAudioInputStream;
    }

    private JMEAudioInputStream reopenOgg(URL uRL, boolean bl) throws IOException {
        OggInputStream oggInputStream = null;
        if (bl) {
            float f = 0.0f;
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                VorbisFile vorbisFile = new VorbisFile(inputStream, new byte[4096], 4096);
                f = vorbisFile.time_total(-1) * 1000.0f;
            }
            catch (Exception exception) {
                inputStream.close();
                throw new IOException("Input does not appear to be an Ogg bitstream.");
            }
            oggInputStream = new OggInputStream(uRL.openStream());
            ((JMEAudioInputStream)oggInputStream).setLength(f);
        } else {
            oggInputStream = new OggInputStream(uRL.openStream());
        }
        return oggInputStream;
    }

    private JMEAudioInputStream reopenOgg(String string, boolean bl) throws IOException {
        OggInputStream oggInputStream = null;
        if (bl) {
            float f = 0.0f;
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(string);
                VorbisFile vorbisFile = new VorbisFile(inputStream, new byte[4096], 4096);
                f = vorbisFile.time_total(-1) * 1000.0f;
            }
            catch (Exception exception) {
                inputStream.close();
                throw new IOException("Input does not appear to be an Ogg bitstream.");
            }
            oggInputStream = new OggInputStream(new FileInputStream(string));
            ((JMEAudioInputStream)oggInputStream).setLength(f);
        } else {
            oggInputStream = new OggInputStream(new FileInputStream(string));
        }
        return oggInputStream;
    }

    private JMEAudioInputStream reopenWav(URL uRL, boolean bl) throws IOException {
        WavInputStream wavInputStream = null;
        if (bl) {
            wavInputStream = new WavInputStream(new BufferedInputStream(uRL.openStream()));
            float f = this.getLength(wavInputStream) * 1000.0f;
            wavInputStream.close();
            wavInputStream = new WavInputStream(new BufferedInputStream(uRL.openStream()));
            ((JMEAudioInputStream)wavInputStream).setLength(f);
        } else {
            wavInputStream = new WavInputStream(new BufferedInputStream(uRL.openStream()));
        }
        return wavInputStream;
    }

    private JMEAudioInputStream reopenWav(String string, boolean bl) throws IOException {
        WavInputStream wavInputStream = null;
        if (bl) {
            wavInputStream = new WavInputStream(new BufferedInputStream(new FileInputStream(string)));
            float f = this.getLength(wavInputStream) * 1000.0f;
            wavInputStream.close();
            wavInputStream = new WavInputStream(new BufferedInputStream(new FileInputStream(string)));
            ((JMEAudioInputStream)wavInputStream).setLength(f);
        } else {
            wavInputStream = new WavInputStream(new BufferedInputStream(new FileInputStream(string)));
        }
        return wavInputStream;
    }

    private float getLength(JMEAudioInputStream jMEAudioInputStream) throws IOException {
        byte[] byArray = new byte[4096];
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (!bl) {
            n = jMEAudioInputStream.read(byArray, 0, byArray.length);
            if (n != -1) {
                n2 += n;
            }
            bl = n != byArray.length || n < 0;
        }
        int n3 = jMEAudioInputStream.getChannels();
        return (float)n2 / (float)(jMEAudioInputStream.rate() * jMEAudioInputStream.getAudioChannels() * 2);
    }

    public void closeStream(int n) {
        if (this.player == null) {
            return;
        }
        if (n < 0 || n >= this.player.length) {
            return;
        }
        this.player[n].close();
    }

    public void loopStream(int n, boolean bl) {
        if (this.player == null) {
            return;
        }
        if (n < 0 || n >= this.player.length) {
            return;
        }
        this.player[n].setLooping(bl);
    }

    public void stopStream(int n) {
        if (this.player == null) {
            return;
        }
        if (n < 0 || n >= this.player.length) {
            return;
        }
        this.player[n].stop();
    }

    public boolean pauseStream(int n) {
        if (this.player == null) {
            return false;
        }
        if (n < 0 || n >= this.player.length) {
            return false;
        }
        return this.player[n].pause();
    }

    public boolean isPlaying(int n) {
        if (this.player == null) {
            return false;
        }
        if (n < 0 || n >= this.player.length) {
            return false;
        }
        return this.player[n].playing();
    }

    private int add(JMEAudioInputStream jMEAudioInputStream) {
        if (this.player == null) {
            this.player = new Player[1];
            this.player[0] = new Player(jMEAudioInputStream, this.generateSource());
            return 0;
        }
        Player[] playerArray = new Player[this.player.length];
        System.arraycopy(this.player, 0, playerArray, 0, playerArray.length);
        this.player = new Player[playerArray.length + 1];
        System.arraycopy(playerArray, 0, this.player, 0, playerArray.length);
        this.player[playerArray.length] = new Player(jMEAudioInputStream, this.generateSource());
        return playerArray.length;
    }

    public void play(int n) {
        if (this.player == null) {
            return;
        }
        if (n < 0 || n >= this.player.length) {
            return;
        }
        if (this.player[n].playing()) {
            return;
        }
        new Thread(this.player[n]).start();
    }

    public float length(int n) {
        if (this.player == null) {
            return 0.0f;
        }
        if (n < 0 || n >= this.player.length) {
            return 0.0f;
        }
        return this.player[n].getStreamLength();
    }

    public void setVolume(int n, float f) {
        if (this.player == null) {
            return;
        }
        if (n < 0 || n >= this.player.length) {
            return;
        }
        this.player[n].setVolume(f);
    }

    private int generateSource() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)intBuffer);
        return intBuffer.get(0);
    }

    private class Player
    implements Runnable {
        private int source;
        private JMEAudioInputStream stream;
        private ByteBuffer dataBuffer = ByteBuffer.allocateDirect(81920);
        private IntBuffer buffers = BufferUtils.createIntBuffer((int)4);
        private boolean paused;
        private boolean stopped;
        private boolean finished;
        private boolean looping;

        Player(JMEAudioInputStream jMEAudioInputStream, int n) {
            this.source = n;
            this.stream = jMEAudioInputStream;
            AL10.alGenBuffers((IntBuffer)this.buffers);
        }

        public void setVolume(float f) {
            AL10.alSourcef((int)this.source, (int)4106, (float)f);
        }

        public float getStreamLength() {
            return this.stream.getLength();
        }

        public synchronized boolean update() throws IOException {
            if (this.paused) {
                return true;
            }
            boolean bl = true;
            int n = AL10.alGetSourcei((int)this.source, (int)4118);
            while (n-- > 0) {
                IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
                AL10.alSourceUnqueueBuffers((int)this.source, (IntBuffer)intBuffer);
                bl = this.stream(intBuffer.get(0));
                intBuffer.rewind();
                AL10.alSourceQueueBuffers((int)this.source, (IntBuffer)intBuffer);
            }
            return bl;
        }

        protected boolean stream(int n) {
            try {
                int n2 = this.stream.read(this.dataBuffer, 0, this.dataBuffer.capacity());
                if (n2 >= 0) {
                    this.dataBuffer.rewind();
                    int n3 = this.stream.getChannels();
                    AL10.alBufferData((int)n, (int)n3, (ByteBuffer)this.dataBuffer, (int)this.stream.rate());
                    return true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }

        public boolean play() {
            AL10.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)this.source, (int)4101, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSourcef((int)this.source, (int)4129, (float)0.0f);
            AL10.alSourcei((int)this.source, (int)514, (int)1);
            if (this.playing()) {
                return true;
            }
            for (int i = 0; i < this.buffers.capacity(); ++i) {
                if (this.stream(this.buffers.get(i))) continue;
                return false;
            }
            AL10.alSourceQueueBuffers((int)this.source, (IntBuffer)this.buffers);
            AL10.alSourcePlay((int)this.source);
            this.finished = false;
            return true;
        }

        public void close() {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public boolean pause() {
            this.paused = !this.paused;
            return this.paused;
        }

        public void stop() {
            this.stopped = true;
        }

        public boolean playing() {
            return AL10.alGetSourcei((int)this.source, (int)4112) == 4114;
        }

        public void run() {
            block8: {
                if (this.finished) {
                    float f = this.stream.getLength();
                    String string = this.stream.getFileName();
                    this.stream = string != null ? StreamPlayer.this.open(string, false) : StreamPlayer.this.open(this.stream.getURL(), false);
                    if (this.stream == null) {
                        return;
                    }
                }
                this.play();
                try {
                    while (this.update() && !this.stopped) {
                        Thread.sleep(2L);
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof InterruptedException) break block8;
                    exception.printStackTrace();
                }
            }
            this.finished = true;
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.looping && !this.stopped) {
                this.run();
            }
        }

        public boolean isLooping() {
            return this.looping;
        }

        public void setLooping(boolean bl) {
            this.looping = bl;
        }
    }
}

