/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.scene;

import com.jme.util.LoggingSystem;
import com.jmex.sound.openAL.scene.SoundSpatial;
import java.util.ArrayList;
import java.util.logging.Level;

public class SoundNode
extends SoundSpatial {
    private ArrayList children = new ArrayList();
    protected boolean eventStatusChanged;
    protected int eventNumber;

    public SoundNode() {
        LoggingSystem.getLogger().log(Level.INFO, "Node created.");
    }

    public int getQuantity() {
        return this.children.size();
    }

    public int attachChild(SoundSpatial soundSpatial) {
        if (soundSpatial == null) {
            return this.children.size();
        }
        if (!this.children.contains(soundSpatial)) {
            soundSpatial.setParent(this);
            this.children.add(soundSpatial);
        }
        LoggingSystem.getLogger().log(Level.INFO, "Child attached to this node");
        return this.children.size();
    }

    public int detachChild(SoundSpatial soundSpatial) {
        int n = this.children.indexOf(soundSpatial);
        if (n != -1) {
            this.children.remove(n);
            LoggingSystem.getLogger().log(Level.INFO, "Child removed.");
        }
        return n;
    }

    public SoundSpatial detachChildAt(int n) {
        LoggingSystem.getLogger().log(Level.INFO, "Child removed.");
        return (SoundSpatial)this.children.remove(n);
    }

    public SoundSpatial setChild(int n, SoundSpatial soundSpatial) {
        SoundSpatial soundSpatial2 = (SoundSpatial)this.children.get(n);
        this.children.add(n, soundSpatial);
        LoggingSystem.getLogger().log(Level.INFO, "Child attached to this node");
        return soundSpatial2;
    }

    public SoundSpatial getChild(int n) {
        return (SoundSpatial)this.children.get(n);
    }

    public void updateWorldData(float f) {
        super.updateWorldData(f);
        for (int i = 0; i < this.children.size(); ++i) {
            SoundSpatial soundSpatial = (SoundSpatial)this.children.get(i);
            if (soundSpatial == null) continue;
            soundSpatial.updateGeometricState(f, false);
            if (!this.eventStatusChanged) continue;
            this.eventStatusChanged = !soundSpatial.fireEvent(this.eventNumber);
        }
    }

    public void draw() {
        for (int i = 0; i < this.children.size(); ++i) {
            SoundSpatial soundSpatial = (SoundSpatial)this.children.get(i);
            if (soundSpatial == null) continue;
            soundSpatial.onDraw();
        }
    }

    public boolean fireEvent(int n) {
        return false;
    }

    public void onEvent(int n) {
        this.eventStatusChanged = true;
        this.eventNumber = n;
    }
}

