/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod3;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod3.FMOD;
import org.lwjgl.fmod3.FSoundDSPUnit;
import org.lwjgl.fmod3.FSoundReverbChannelProperties;
import org.lwjgl.fmod3.FSoundReverbProperties;
import org.lwjgl.fmod3.FSoundSample;
import org.lwjgl.fmod3.FSoundSampleLock;
import org.lwjgl.fmod3.FSoundStream;
import org.lwjgl.fmod3.FSoundSyncPoint;
import org.lwjgl.fmod3.FSoundTagField;
import org.lwjgl.fmod3.callbacks.FSoundCloseCallback;
import org.lwjgl.fmod3.callbacks.FSoundDSPCallback;
import org.lwjgl.fmod3.callbacks.FSoundMetaDataCallback;
import org.lwjgl.fmod3.callbacks.FSoundOpenCallback;
import org.lwjgl.fmod3.callbacks.FSoundReadCallback;
import org.lwjgl.fmod3.callbacks.FSoundSeekCallback;
import org.lwjgl.fmod3.callbacks.FSoundStreamCallback;
import org.lwjgl.fmod3.callbacks.FSoundTellCallback;

public class FSound {
    public static final int FSOUND_MIXER_AUTODETECT = 0;
    public static final int FSOUND_MIXER_BLENDMODE = 1;
    public static final int FSOUND_MIXER_MMXP5 = 2;
    public static final int FSOUND_MIXER_MMXP6 = 3;
    public static final int FSOUND_MIXER_QUALITY_AUTODETECT = 4;
    public static final int FSOUND_MIXER_QUALITY_FPU = 5;
    public static final int FSOUND_MIXER_QUALITY_MMXP5 = 6;
    public static final int FSOUND_MIXER_QUALITY_MMXP6 = 7;
    public static final int FSOUND_MIXER_MONO = 8;
    public static final int FSOUND_MIXER_QUALITY_MONO = 9;
    public static final int FSOUND_MIXER_MAX = 10;
    public static final int FSOUND_OUTPUT_NOSOUND = 0;
    public static final int FSOUND_OUTPUT_WINMM = 1;
    public static final int FSOUND_OUTPUT_DSOUND = 2;
    public static final int FSOUND_OUTPUT_A3D = 3;
    public static final int FSOUND_OUTPUT_OSS = 4;
    public static final int FSOUND_OUTPUT_ESD = 5;
    public static final int FSOUND_OUTPUT_ALSA = 6;
    public static final int FSOUND_OUTPUT_ASIO = 7;
    public static final int FSOUND_OUTPUT_XBOX = 8;
    public static final int FSOUND_OUTPUT_PS2 = 9;
    public static final int FSOUND_OUTPUT_MAC = 10;
    public static final int FSOUND_OUTPUT_GC = 11;
    public static final int FSOUND_OUTPUT_NOSOUND_NONREALTIME = 12;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_CLEARUNIT = 0;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_SFXUNIT = 100;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_MUSICUNIT = 200;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_USER = 300;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_FFTUNIT = 900;
    public static final int FSOUND_DSP_DEFAULTPRIORITY_CLIPANDCOPYUNIT = 1000;
    public static final int FSOUND_CAPS_HARDWARE = 1;
    public static final int FSOUND_CAPS_EAX2 = 2;
    public static final int FSOUND_CAPS_EAX3 = 16;
    public static final int FSOUND_LOOP_OFF = 1;
    public static final int FSOUND_LOOP_NORMAL = 2;
    public static final int FSOUND_LOOP_BIDI = 4;
    public static final int FSOUND_8BITS = 8;
    public static final int FSOUND_16BITS = 16;
    public static final int FSOUND_MONO = 32;
    public static final int FSOUND_STEREO = 64;
    public static final int FSOUND_UNSIGNED = 128;
    public static final int FSOUND_SIGNED = 256;
    public static final int FSOUND_DELTA = 512;
    public static final int FSOUND_IT214 = 1024;
    public static final int FSOUND_IT215 = 2048;
    public static final int FSOUND_HW3D = 4096;
    public static final int FSOUND_2D = 8192;
    public static final int FSOUND_STREAMABLE = 16384;
    public static final int FSOUND_LOADMEMORY = 32768;
    public static final int FSOUND_LOADRAW = 65536;
    public static final int FSOUND_MPEGACCURATE = 131072;
    public static final int FSOUND_FORCEMONO = 262144;
    public static final int FSOUND_HW2D = 524288;
    public static final int FSOUND_ENABLEFX = 0x100000;
    public static final int FSOUND_MPEGHALFRATE = 0x200000;
    public static final int FSOUND_IMAADPCM = 0x400000;
    public static final int FSOUND_VAG = 0x800000;
    public static final int FSOUND_NONBLOCKING = 0x1000000;
    public static final int FSOUND_GCADPCM = 0x2000000;
    public static final int FSOUND_MULTICHANNEL = 0x4000000;
    public static final int FSOUND_USECORE0 = 0x8000000;
    public static final int FSOUND_USECORE1 = 0x10000000;
    public static final int FSOUND_LOADMEMORYIOP = 0x20000000;
    public static final int FSOUND_IGNORETAGS = 0x40000000;
    public static final int FSOUND_STREAM_NET = Integer.MIN_VALUE;
    public static final int FSOUND_NORMAL = 304;
    public static final int FSOUND_CD_PLAYCONTINUOUS = 0;
    public static final int FSOUND_CD_PLAYONCE = 1;
    public static final int FSOUND_CD_PLAYLOOPED = 2;
    public static final int FSOUND_CD_PLAYRANDOM = 3;
    public static final int FSOUND_FREE = -1;
    public static final int FSOUND_UNMANAGED = -2;
    public static final int FSOUND_ALL = -3;
    public static final int FSOUND_STEREOPAN = -1;
    public static final int FSOUND_SYSTEMCHANNEL = -1000;
    public static final int FSOUND_SYSTEMSAMPLE = -1000;
    public static final int FSOUND_REVERB_FLAGS_DECAYTIMESCALE = 1;
    public static final int FSOUND_REVERB_FLAGS_REFLECTIONSSCALE = 2;
    public static final int FSOUND_REVERB_FLAGS_REFLECTIONSDELAYSCALE = 4;
    public static final int FSOUND_REVERB_FLAGS_REVERBSCALE = 8;
    public static final int FSOUND_REVERB_FLAGS_REVERBDELAYSCALE = 16;
    public static final int FSOUND_REVERB_FLAGS_DECAYHFLIMIT = 32;
    public static final int FSOUND_REVERB_FLAGS_ECHOTIMESCALE = 64;
    public static final int FSOUND_REVERB_FLAGS_MODULATIONTIMESCALE = 128;
    public static final int FSOUND_REVERB_FLAGS_CORE0 = 256;
    public static final int FSOUND_REVERB_FLAGS_CORE1 = 512;
    public static final int FSOUND_REVERB_FLAGS_DEFAULT = 831;
    public static final int FSOUND_TAGFIELD_VORBISCOMMENT = 0;
    public static final int FSOUND_TAGFIELD_ID3V1 = 1;
    public static final int FSOUND_TAGFIELD_ID3V2 = 2;
    public static final int FSOUND_TAGFIELD_SHOUTCAST = 3;
    public static final int FSOUND_TAGFIELD_ICECAST = 4;
    public static final int FSOUND_TAGFIELD_ASF = 5;
    public static final int FSOUND_STREAM_NET_NOTCONNECTED = 0;
    public static final int FSOUND_STREAM_NET_CONNECTING = 1;
    public static final int FSOUND_STREAM_NET_BUFFERING = 2;
    public static final int FSOUND_STREAM_NET_READY = 3;
    public static final int FSOUND_STREAM_NET_ERROR = 4;
    public static final int FSOUND_FX_CHORUS = 0;
    public static final int FSOUND_FX_COMPRESSOR = 1;
    public static final int FSOUND_FX_DISTORTION = 2;
    public static final int FSOUND_FX_ECHO = 3;
    public static final int FSOUND_FX_FLANGER = 4;
    public static final int FSOUND_FX_GARGLE = 5;
    public static final int FSOUND_FX_I3DL2REVERB = 6;
    public static final int FSOUND_FX_PARAMEQ = 7;
    public static final int FSOUND_FX_WAVES_REVERB = 8;
    public static final int FSOUND_FX_MAX = 9;
    public static final int FSOUND_SPEAKERMODE_DOLBYDIGITAL = 0;
    public static final int FSOUND_SPEAKERMODE_HEADPHONES = 1;
    public static final int FSOUND_SPEAKERMODE_MONO = 2;
    public static final int FSOUND_SPEAKERMODE_QUAD = 3;
    public static final int FSOUND_SPEAKERMODE_STEREO = 4;
    public static final int FSOUND_SPEAKERMODE_SURROUND = 5;
    public static final int FSOUND_SPEAKERMODE_DTS = 6;
    public static final int FSOUND_SPEAKERMODE_PROLOGIC2 = 7;
    public static final int FSOUND_SPEAKERMODE_PROLOGIC2_INTERIOR = 8;
    public static final int FSOUND_INIT_USEDEFAULTMIDISYNTH = 1;
    public static final int FSOUND_INIT_GLOBALFOCUS = 2;
    public static final int FSOUND_INIT_ENABLESYSTEMCHANNELFX = 4;
    public static final int FSOUND_INIT_ACCURATEVULEVELS = 8;
    public static final int FSOUND_INIT_PS2_DISABLECORE0REVERB = 16;
    public static final int FSOUND_INIT_PS2_DISABLECORE1REVERB = 32;
    public static final int FSOUND_INIT_PS2_SWAPDMACORES = 64;
    public static final int FSOUND_INIT_DONTLATENCYADJUST = 128;
    public static final int FSOUND_INIT_GC_INITLIBS = 256;
    public static final int FSOUND_INIT_STREAM_FROM_MAIN_THREAD = 512;
    public static final int FSOUND_INIT_PS2_USEVOLUMERAMPING = 1024;
    public static final int FSOUND_INIT_DSOUND_DEFERRED = 2048;
    public static final int FSOUND_INIT_DSOUND_HRTF_LIGHT = 4096;
    public static final int FSOUND_INIT_DSOUND_HRTF_FULL = 8192;
    public static final int FSOUND_PROTOCOL_SHOUTCAST = 1;
    public static final int FSOUND_PROTOCOL_ICECAST = 2;
    public static final int FSOUND_PROTOCOL_HTTP = 4;
    public static final int FSOUND_FORMAT_MPEG = 65536;
    public static final int FSOUND_FORMAT_OGGVORBIS = 131072;

    public static native void FSOUND_Close();

    public static void FSOUND_File_SetCallbacks(FSoundOpenCallback open, FSoundCloseCallback close, FSoundReadCallback read, FSoundSeekCallback seek, FSoundTellCallback tell) {
        if (open == null || close == null || read == null || seek == null || tell == null) {
            throw new IllegalArgumentException("Cannot supply null callback");
        }
        FMOD.registerCallback(9, -1L, null, open);
        FMOD.registerCallback(10, -1L, null, open);
        FMOD.registerCallback(12, -1L, null, open);
        FMOD.registerCallback(13, -1L, null, open);
        FMOD.registerCallback(14, -1L, null, open);
        FSound.nFSOUND_File_SetCallbacks();
    }

    private static native void nFSOUND_File_SetCallbacks();

    public static native boolean FSOUND_Init(int var0, int var1, int var2);

    public static native boolean FSOUND_SetBufferSize(int var0);

    public static native boolean FSOUND_SetDriver(int var0);

    public static native boolean FSOUND_SetMaxHardwareChannels(int var0);

    public static native boolean FSOUND_SetMinHardwareChannels(int var0);

    public static native boolean FSOUND_SetMixer(int var0);

    public static native boolean FSOUND_SetOutput(int var0);

    public static native void FSOUND_SetPanSeperation(float var0);

    public static native void FSOUND_SetSFXMasterVolume(int var0);

    public static native void FSOUND_SetSpeakerMode(int var0);

    public static native void FSOUND_Update();

    public static native float FSOUND_GetCPUUsage();

    public static native int FSOUND_GetChannelsPlaying();

    public static native int FSOUND_GetDriver();

    public static boolean FSOUND_GetDriverCaps(int driverid, IntBuffer caps) {
        return FSound.nFSOUND_GetDriverCaps(driverid, caps, caps.position());
    }

    private static native boolean nFSOUND_GetDriverCaps(int var0, IntBuffer var1, int var2);

    public static native String FSOUND_GetDriverName(int var0);

    public static native int FSOUND_GetError();

    public static native int FSOUND_GetMaxSamples();

    public static native int FSOUND_GetMaxChannels();

    public static void FSOUND_GetMemoryStats(IntBuffer currentallocated_maxallocated) {
        FSound.nFSOUND_GetMemoryStats(currentallocated_maxallocated, currentallocated_maxallocated.position());
    }

    private static native void nFSOUND_GetMemoryStats(IntBuffer var0, int var1);

    public static native int FSOUND_GetNumDrivers();

    public static boolean FSOUND_GetNumHWChannels(IntBuffer twoD_threeD_channels_total) {
        return FSound.nFSOUND_GetNumHWChannels(twoD_threeD_channels_total, twoD_threeD_channels_total.position());
    }

    private static native boolean nFSOUND_GetNumHWChannels(IntBuffer var0, int var1);

    public static native int FSOUND_GetOutput();

    public static native int FSOUND_GetOutputRate();

    public static native int FSOUND_GetSFXMasterVolume();

    public static native float FSOUND_GetVersion();

    public static FSoundSample FSOUND_Sample_Alloc(int index, int length, int mode, int deffreq, int defvol, int defpan, int defpri) {
        long result = FSound.nFSOUND_Sample_Alloc(index, length, mode, deffreq, defvol, defpan, defpri);
        return result != 0L ? new FSoundSample(result, null) : null;
    }

    private static native long nFSOUND_Sample_Alloc(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static void FSOUND_Sample_Free(FSoundSample sample) {
        sample.release();
        FSound.nFSOUND_Sample_Free(sample.sampleHandle);
    }

    private static native void nFSOUND_Sample_Free(long var0);

    public static FSoundSample FSOUND_Sample_Get(int sampno) {
        long result = FSound.nFSOUND_Sample_Get(sampno);
        return result != 0L ? new FSoundSample(result, null) : null;
    }

    private static native long nFSOUND_Sample_Get(int var0);

    public static boolean FSOUND_Sample_GetDefaults(FSoundSample sample, IntBuffer deffreq, IntBuffer defvol, IntBuffer defpan, IntBuffer defpri) {
        return FSound.nFSOUND_Sample_GetDefaults(sample.sampleHandle, deffreq, deffreq == null ? 0 : deffreq.position(), defvol, defvol == null ? 0 : defvol.position(), defpan, defpan == null ? 0 : defpan.position(), defpri, defpri == null ? 0 : defpri.position());
    }

    private static native boolean nFSOUND_Sample_GetDefaults(long var0, IntBuffer var2, int var3, IntBuffer var4, int var5, IntBuffer var6, int var7, IntBuffer var8, int var9);

    public static boolean FSOUND_Sample_GetDefaultsEx(FSoundSample sample, IntBuffer deffreq, IntBuffer defvol, IntBuffer defpan, IntBuffer defpri, IntBuffer varfreq, IntBuffer varvol, IntBuffer varpan) {
        return FSound.nFSOUND_Sample_GetDefaultsEx(sample.sampleHandle, deffreq, deffreq == null ? 0 : deffreq.position(), defvol, defvol == null ? 0 : defvol.position(), defpan, defpan == null ? 0 : defpan.position(), defpri, defpri == null ? 0 : defpri.position(), varfreq, varfreq == null ? 0 : varfreq.position(), varvol, varvol == null ? 0 : varvol.position(), varpan, varpan == null ? 0 : varpan.position());
    }

    private static native boolean nFSOUND_Sample_GetDefaultsEx(long var0, IntBuffer var2, int var3, IntBuffer var4, int var5, IntBuffer var6, int var7, IntBuffer var8, int var9, IntBuffer var10, int var11, IntBuffer var12, int var13, IntBuffer var14, int var15);

    public static int FSOUND_Sample_GetLength(FSoundSample sample) {
        return FSound.nFSOUND_Sample_GetLength(sample.sampleHandle);
    }

    private static native int nFSOUND_Sample_GetLength(long var0);

    public static int FSOUND_Sample_GetLoopPoints(FSoundSample sample, IntBuffer loopstart, IntBuffer loopend) {
        return FSound.nFSOUND_Sample_GetLoopPoints(sample.sampleHandle, loopstart, loopstart == null ? 0 : loopstart.position(), loopend, loopend == null ? 0 : loopend.position());
    }

    private static native int nFSOUND_Sample_GetLoopPoints(long var0, IntBuffer var2, int var3, IntBuffer var4, int var5);

    public static int FSOUND_Sample_GetMinMaxDistance(FSoundSample sample, FloatBuffer min, FloatBuffer max) {
        return FSound.nFSOUND_Sample_GetMinMaxDistance(sample.sampleHandle, min, min == null ? 0 : min.position(), max, max == null ? 0 : max.position());
    }

    private static native int nFSOUND_Sample_GetMinMaxDistance(long var0, FloatBuffer var2, int var3, FloatBuffer var4, int var5);

    public static int FSOUND_Sample_GetMode(FSoundSample sample) {
        return FSound.nFSOUND_Sample_GetMode(sample.sampleHandle);
    }

    private static native int nFSOUND_Sample_GetMode(long var0);

    public static String FSOUND_Sample_GetName(FSoundSample sample) {
        return FSound.nFSOUND_Sample_GetName(sample.sampleHandle);
    }

    private static native String nFSOUND_Sample_GetName(long var0);

    public static FSoundSample FSOUND_Sample_Load(int index, ByteBuffer data, int inputmode) {
        long result = FSound.nFSOUND_Sample_Load(index, data, inputmode, data.position(), data.remaining());
        if (result != 0L) {
            return new FSoundSample(result, data);
        }
        return null;
    }

    public static FSoundSample FSOUND_Sample_Load(int index, String name, int inputmode, int offset, int length) {
        long result = FSound.nFSOUND_Sample_Load(index, name, inputmode, offset, length);
        if (result != 0L) {
            return new FSoundSample(result, null);
        }
        return null;
    }

    private static native long nFSOUND_Sample_Load(int var0, ByteBuffer var1, int var2, int var3, int var4);

    private static native long nFSOUND_Sample_Load(int var0, String var1, int var2, int var3, int var4);

    public static boolean FSOUND_Sample_Lock(FSoundSample sample, int offset, int length, FSoundSampleLock lock) {
        lock.set(null, null, 0, 0);
        return FSound.nFSOUND_Sample_Lock(sample.sampleHandle, offset, length, lock);
    }

    private static native boolean nFSOUND_Sample_Lock(long var0, int var2, int var3, FSoundSampleLock var4);

    public static boolean FSOUND_Sample_SetDefaults(FSoundSample sample, int deffreq, int defvol, int defpan, int defpri) {
        return FSound.nFSOUND_Sample_SetDefaults(sample.sampleHandle, deffreq, defvol, defpan, defpri);
    }

    private static native boolean nFSOUND_Sample_SetDefaults(long var0, int var2, int var3, int var4, int var5);

    public static boolean FSOUND_Sample_SetDefaultsEx(FSoundSample sample, int deffreq, int defvol, int defpan, int defpri, int varfreq, int varvol, int varpan) {
        return FSound.nFSOUND_Sample_SetDefaultsEx(sample.sampleHandle, deffreq, defvol, defpan, defpri, varfreq, varvol, varpan);
    }

    private static native boolean nFSOUND_Sample_SetDefaultsEx(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static boolean FSOUND_Sample_SetMaxPlaybacks(FSoundSample sample, int max) {
        return FSound.nFSOUND_Sample_SetMaxPlaybacks(sample.sampleHandle, max);
    }

    private static native boolean nFSOUND_Sample_SetMaxPlaybacks(long var0, int var2);

    public static boolean FSOUND_Sample_SetMinMaxDistance(FSoundSample sample, float min, float max) {
        return FSound.nFSOUND_Sample_SetMinMaxDistance(sample.sampleHandle, min, max);
    }

    private static native boolean nFSOUND_Sample_SetMinMaxDistance(long var0, float var2, float var3);

    public static boolean FSOUND_Sample_SetMode(FSoundSample sample, int mode) {
        return FSound.nFSOUND_Sample_SetMode(sample.sampleHandle, mode);
    }

    private static native boolean nFSOUND_Sample_SetMode(long var0, int var2);

    public static boolean nFSOUND_Sample_SetLoopPoints(FSoundSample sample, int loopstart, int loopend) {
        return FSound.nFSOUND_Sample_SetLoopPoints(sample.sampleHandle, loopstart, loopend);
    }

    private static native boolean nFSOUND_Sample_SetLoopPoints(long var0, int var2, int var3);

    public static boolean FSOUND_Sample_Unlock(FSoundSample sample, FSoundSampleLock lock) {
        return FSound.nFSOUND_Sample_Unlock(sample.sampleHandle, lock.getPtr1(), lock.getPtr2(), lock.getLen1(), lock.getLen2());
    }

    private static native boolean nFSOUND_Sample_Unlock(long var0, ByteBuffer var2, ByteBuffer var3, int var4, int var5);

    public static boolean FSOUND_Sample_Upload(FSoundSample sample, ByteBuffer srcdata, int mode) {
        return FSound.nFSOUND_Sample_Upload(sample.sampleHandle, srcdata, srcdata.position(), mode);
    }

    private static native boolean nFSOUND_Sample_Upload(long var0, ByteBuffer var2, int var3, int var4);

    public static int FSOUND_PlaySound(int channel, FSoundSample sample) {
        return FSound.nFSOUND_PlaySound(channel, sample.sampleHandle);
    }

    private static native int nFSOUND_PlaySound(int var0, long var1);

    public static int nFSOUND_PlaySoundEx(int channel, FSoundSample sample, FSoundDSPUnit dspunit, boolean startpaused) {
        return FSound.nFSOUND_PlaySoundEx(channel, sample.sampleHandle, dspunit.dspHandle, startpaused);
    }

    private static native int nFSOUND_PlaySoundEx(int var0, long var1, ByteBuffer var3, boolean var4);

    public static native boolean FSOUND_StopSound(int var0);

    public static native boolean FSOUND_SetFrequency(int var0, int var1);

    public static native boolean FSOUND_SetLevels(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native boolean FSOUND_SetLoopMode(int var0, int var1);

    public static native boolean FSOUND_SetMute(int var0, boolean var1);

    public static native boolean FSOUND_SetPan(int var0, int var1);

    public static native boolean FSOUND_SetPaused(int var0, boolean var1);

    public static native boolean FSOUND_SetPriority(int var0, int var1);

    public static native boolean FSOUND_SetReserved(int var0, boolean var1);

    public static native boolean FSOUND_SetSurround(int var0, boolean var1);

    public static native boolean FSOUND_SetVolume(int var0, int var1);

    public static native boolean FSOUND_SetVolumeAbsolute(int var0, int var1);

    public static native int FSOUND_GetVolume(int var0);

    public static native int FSOUND_GetAmplitude(int var0);

    public static boolean FSOUND_3D_SetAttributes(int channel, FloatBuffer pos, FloatBuffer vel) {
        return FSound.nFSOUND_3D_SetAttributes(channel, pos, pos != null ? pos.position() : 0, vel, vel != null ? vel.position() : 0);
    }

    private static native boolean nFSOUND_3D_SetAttributes(int var0, FloatBuffer var1, int var2, FloatBuffer var3, int var4);

    public static native boolean FSOUND_3D_SetMinMaxDistance(int var0, float var1, float var2);

    public static native boolean FSOUND_SetCurrentPosition(int var0, int var1);

    public static native int FSOUND_GetCurrentPosition(int var0);

    public static FSoundSample FSOUND_GetCurrentSample(int channel) {
        long result = FSound.nFSOUND_GetCurrentSample(channel);
        if (result != 0L) {
            return new FSoundSample(result, null);
        }
        return null;
    }

    private static native long nFSOUND_GetCurrentSample(int var0);

    public static boolean FSOUND_GetCurrentLevels(int channel, FloatBuffer l_r) {
        return FSound.nFSOUND_GetCurrentLevels(channel, l_r, l_r.position());
    }

    private static native boolean nFSOUND_GetCurrentLevels(int var0, FloatBuffer var1, int var2);

    public static native int FSOUND_GetFrequency(int var0);

    public static native int FSOUND_GetLoopMode(int var0);

    public static native int FSOUND_GetMixer();

    public static native boolean FSOUND_GetMute(int var0);

    public static native int FSOUND_GetNumSubChannels(int var0);

    public static native int FSOUND_GetPan(int var0);

    public static native boolean FSOUND_GetPaused(int var0);

    public static native int FSOUND_GetPriority(int var0);

    public static native int FSOUND_GetReserved(int var0);

    public static native int FSOUND_GetSubChannel(int var0, int var1);

    public static native int FSOUND_GetSurround(int var0);

    public static native boolean FSOUND_IsPlaying(int var0);

    public static boolean FSOUND_3D_GetAttributes(int channel, FloatBuffer pos, FloatBuffer vel) {
        return FSound.nFSOUND_3D_GetAttributes(channel, pos, pos != null ? pos.position() : 0, vel, vel != null ? vel.position() : 0);
    }

    private static native boolean nFSOUND_3D_GetAttributes(int var0, FloatBuffer var1, int var2, FloatBuffer var3, int var4);

    public static boolean FSOUND_3D_GetMinMaxDistance(int channel, FloatBuffer minmax) {
        return FSound.nFSOUND_3D_GetMinMaxDistance(channel, minmax, minmax != null ? minmax.position() : 0);
    }

    private static native boolean nFSOUND_3D_GetMinMaxDistance(int var0, FloatBuffer var1, int var2);

    public static void FSOUND_3D_Listener_GetAttributes(FloatBuffer pos, FloatBuffer vel, FloatBuffer fx, FloatBuffer fy, FloatBuffer fz, FloatBuffer tx, FloatBuffer ty, FloatBuffer tz) {
        FSound.nFSOUND_3D_Listener_GetAttributes(pos, pos != null ? pos.position() : 0, vel, vel != null ? vel.position() : 0, fx, fx != null ? fx.position() : 0, fy, fy != null ? fy.position() : 0, fz, fz != null ? fz.position() : 0, tx, tx != null ? tx.position() : 0, ty, ty != null ? ty.position() : 0, tz, tz != null ? tz.position() : 0);
    }

    private static native void nFSOUND_3D_Listener_GetAttributes(FloatBuffer var0, int var1, FloatBuffer var2, int var3, FloatBuffer var4, int var5, FloatBuffer var6, int var7, FloatBuffer var8, int var9, FloatBuffer var10, int var11, FloatBuffer var12, int var13, FloatBuffer var14, int var15);

    public static void FSOUND_3D_Listener_SetAttributes(FloatBuffer pos, FloatBuffer vel, float fx, float fy, float fz, float tx, float ty, float tz) {
        FSound.nFSOUND_3D_Listener_SetAttributes(pos, pos != null ? pos.position() : 0, vel, vel != null ? vel.position() : 0, fx, fy, fz, tx, ty, tz);
    }

    private static native void nFSOUND_3D_Listener_SetAttributes(FloatBuffer var0, int var1, FloatBuffer var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public static native void FSOUND_3D_Listener_SetCurrent(int var0, int var1);

    public static native void FSOUND_3D_SetDistanceFactor(float var0);

    public static native void FSOUND_3D_SetDopplerFactor(float var0);

    public static native void FSOUND_3D_SetRolloffFactor(float var0);

    public static FSoundStream FSOUND_Stream_Open(String name, int mode, int offset, int length) {
        long result = FSound.nFSOUND_Stream_Open(name, mode, offset, length);
        if (result != 0L) {
            return new FSoundStream(result, null);
        }
        return null;
    }

    public static FSoundStream FSOUND_Stream_Open(ByteBuffer data, int mode) {
        long result = FSound.nFSOUND_Stream_Open(data, mode, data.position(), data.remaining());
        if (result != 0L) {
            return new FSoundStream(result, data);
        }
        return null;
    }

    private static native long nFSOUND_Stream_Open(ByteBuffer var0, int var1, int var2, int var3);

    private static native long nFSOUND_Stream_Open(String var0, int var1, int var2, int var3);

    public static int FSOUND_Stream_Play(int channel, FSoundStream stream) {
        return FSound.nFSOUND_Stream_Play(channel, stream.streamHandle);
    }

    private static native int nFSOUND_Stream_Play(int var0, long var1);

    public static boolean FSOUND_Stream_Stop(FSoundStream stream) {
        return FSound.nFSOUND_Stream_Stop(stream.streamHandle);
    }

    private static native boolean nFSOUND_Stream_Stop(long var0);

    public static boolean FSOUND_Stream_Close(FSoundStream stream) {
        stream.release();
        return FSound.nFSOUND_Stream_Close(stream.streamHandle);
    }

    private static native boolean nFSOUND_Stream_Close(long var0);

    public static int FSOUND_Stream_GetNumSubStreams(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetNumSubStreams(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetNumSubStreams(long var0);

    public static int FSOUND_Stream_SetSubStream(FSoundStream stream, int index) {
        return FSound.nFSOUND_Stream_SetSubStream(stream.streamHandle, index);
    }

    private static native int nFSOUND_Stream_SetSubStream(long var0, int var2);

    public static FSoundSyncPoint FSOUND_Stream_AddSyncPoint(FSoundStream stream, int pcmoffset, String name) {
        ByteBuffer result = FSound.nFSOUND_Stream_AddSyncPoint(stream.streamHandle, pcmoffset, name);
        if (result != null) {
            return new FSoundSyncPoint(result);
        }
        return null;
    }

    private static native ByteBuffer nFSOUND_Stream_AddSyncPoint(long var0, int var2, String var3);

    public static FSoundStream FSOUND_Stream_Create(FSoundStreamCallback callbackHandler, int lenbytes, int mode, int samplerate) {
        FSoundStream stream = null;
        long result = FSound.nFSOUND_Stream_Create(lenbytes, mode, samplerate);
        if (result != 0L) {
            stream = new FSoundStream(result, null);
            FMOD.registerCallback(5, stream.streamHandle, stream, callbackHandler);
        }
        return stream;
    }

    private static native long nFSOUND_Stream_Create(int var0, int var1, int var2);

    public static FSoundDSPUnit FSOUND_Stream_CreateDSP(FSoundStream stream, FSoundDSPCallback callback, int priority) {
        ByteBuffer dspID = (ByteBuffer)BufferUtils.createByteBuffer((int)8).putLong(FSoundDSPUnit.getNextId()).flip();
        FSoundDSPUnit unit = null;
        ByteBuffer dspHandle = FSound.nFSOUND_Stream_CreateDSP(stream.streamHandle, priority, dspID);
        if (dspHandle != null) {
            unit = new FSoundDSPUnit(dspHandle, dspID);
            FMOD.registerCallback(4, dspID.getLong(0), unit, callback);
        }
        return unit;
    }

    private static native ByteBuffer nFSOUND_Stream_CreateDSP(long var0, int var2, ByteBuffer var3);

    public static boolean FSOUND_Stream_DeleteSyncPoint(FSoundSyncPoint point) {
        return FSound.nFSOUND_Stream_DeleteSyncPoint(point.syncpointHandle);
    }

    private static native boolean nFSOUND_Stream_DeleteSyncPoint(ByteBuffer var0);

    public static boolean FSOUND_Stream_FindTagField(FSoundStream stream, FSoundTagField field) {
        return FSound.nFSOUND_Stream_FindTagField(stream.streamHandle, field.type, field.name, field);
    }

    private static native boolean nFSOUND_Stream_FindTagField(long var0, int var2, String var3, FSoundTagField var4);

    public static int FSOUND_Stream_GetLength(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetLength(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetLength(long var0);

    public static int FSOUND_Stream_GetLengthMs(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetLengthMs(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetLengthMs(long var0);

    public static int FSOUND_Stream_GetMode(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetMode(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetMode(long var0);

    public static int nFSOUND_Stream_GetNumSyncPoints(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetNumSyncPoints(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetNumSyncPoints(long var0);

    public static boolean FSOUND_Stream_GetNumTagFields(FSoundStream stream, IntBuffer num) {
        return FSound.nFSOUND_Stream_GetNumTagFields(stream.streamHandle, num, num.position());
    }

    private static native boolean nFSOUND_Stream_GetNumTagFields(long var0, IntBuffer var2, int var3);

    public static int FSOUND_Stream_GetOpenState(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetOpenState(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetOpenState(long var0);

    public static int FSOUND_Stream_GetPosition(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetPosition(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetPosition(long var0);

    public static FSoundSample FSOUND_Stream_GetSample(FSoundStream stream) {
        long result = FSound.nFSOUND_Stream_GetSample(stream.streamHandle);
        if (result != 0L) {
            return new FSoundSample(result, null);
        }
        return null;
    }

    private static native long nFSOUND_Stream_GetSample(long var0);

    public static FSoundSyncPoint FSOUND_Stream_GetSyncPoint(FSoundStream stream, int index) {
        ByteBuffer result = FSound.nFSOUND_Stream_GetSyncPoint(stream.streamHandle, index);
        if (result != null) {
            return new FSoundSyncPoint(result);
        }
        return null;
    }

    private static native ByteBuffer nFSOUND_Stream_GetSyncPoint(long var0, int var2);

    public static String FSOUND_Stream_GetSyncPointInfo(FSoundSyncPoint point, IntBuffer pcmoffset) {
        return FSound.nFSOUND_Stream_GetSyncPointInfo(point.syncpointHandle, pcmoffset, pcmoffset != null ? pcmoffset.position() : 0);
    }

    private static native String nFSOUND_Stream_GetSyncPointInfo(ByteBuffer var0, IntBuffer var1, int var2);

    public static boolean FSOUND_Stream_GetTagField(FSoundStream stream, int num, FSoundTagField field) {
        return FSound.nFSOUND_Stream_GetTagField(stream.streamHandle, num, field);
    }

    private static native boolean nFSOUND_Stream_GetTagField(long var0, int var2, FSoundTagField var3);

    public static int FSOUND_Stream_GetTime(FSoundStream stream) {
        return FSound.nFSOUND_Stream_GetTime(stream.streamHandle);
    }

    private static native int nFSOUND_Stream_GetTime(long var0);

    public static boolean FSOUND_Stream_Net_GetBufferProperties(IntBuffer values) {
        return FSound.nFSOUND_Stream_Net_GetBufferProperties(values, values.position());
    }

    private static native boolean nFSOUND_Stream_Net_GetBufferProperties(IntBuffer var0, int var1);

    public static native String FSOUND_Stream_Net_GetLastServerStatus();

    public static boolean FSOUND_Stream_Net_GetStatus(FSoundStream stream, IntBuffer values) {
        return FSound.nFSOUND_Stream_Net_GetStatus(stream.streamHandle, values, values.position());
    }

    private static native boolean nFSOUND_Stream_Net_GetStatus(long var0, IntBuffer var2, int var3);

    public static native boolean FSOUND_Stream_Net_SetBufferProperties(int var0, int var1, int var2);

    public static boolean FSOUND_Stream_Net_SetMetadataCallback(FSoundStream stream, FSoundMetaDataCallback callback) {
        FMOD.registerCallback(11, stream.streamHandle, stream, callback);
        return FSound.nFSOUND_Stream_Net_SetMetadataCallback(stream.streamHandle);
    }

    private static native boolean nFSOUND_Stream_Net_SetMetadataCallback(long var0);

    public static native boolean FSOUND_Stream_Net_SetProxy(String var0);

    public static int FSOUND_Stream_PlayEx(int channel, FSoundStream stream, FSoundDSPUnit dspunit, boolean paused) {
        int res = FSound.nFSOUND_Stream_PlayEx(channel, stream.streamHandle, dspunit != null ? dspunit.dspHandle : null, paused);
        return res;
    }

    private static native int nFSOUND_Stream_PlayEx(int var0, long var1, ByteBuffer var3, boolean var4);

    public static native boolean FSOUND_Stream_SetBufferSize(int var0);

    public static boolean FSOUND_Stream_SetEndCallback(FSoundStream stream, FSoundStreamCallback callback) {
        FMOD.registerCallback(15, stream.streamHandle, stream, callback);
        return FSound.nFSOUND_Stream_SetEndCallback(stream.streamHandle);
    }

    private static native boolean nFSOUND_Stream_SetEndCallback(long var0);

    public static int FSOUND_Stream_SetLoopCount(FSoundStream stream, int count) {
        return FSound.nFSOUND_Stream_SetLoopCount(stream.streamHandle, count);
    }

    private static native int nFSOUND_Stream_SetLoopCount(long var0, int var2);

    public static int FSOUND_Stream_SetLoopPoints(FSoundStream stream, int loopstart, int loopend) {
        return FSound.nFSOUND_Stream_SetLoopPoints(stream.streamHandle, loopstart, loopend);
    }

    private static native int nFSOUND_Stream_SetLoopPoints(long var0, int var2, int var3);

    public static int FSOUND_Stream_SetMode(FSoundStream stream, int mode) {
        return FSound.nFSOUND_Stream_SetMode(stream.streamHandle, mode);
    }

    private static native int nFSOUND_Stream_SetMode(long var0, int var2);

    public static int FSOUND_Stream_SetPosition(FSoundStream stream, int position) {
        return FSound.nFSOUND_Stream_SetPosition(stream.streamHandle, position);
    }

    private static native int nFSOUND_Stream_SetPosition(long var0, int var2);

    public static int FSOUND_Stream_SetSubStreamSentence(FSoundStream stream, IntBuffer sentencelist) {
        return FSound.nFSOUND_Stream_SetSubStreamSentence(stream.streamHandle, sentencelist, sentencelist.position());
    }

    private static native int nFSOUND_Stream_SetSubStreamSentence(long var0, IntBuffer var2, int var3);

    public static boolean FSOUND_Stream_SetSyncCallback(FSoundStream stream, FSoundStreamCallback callback) {
        FMOD.registerCallback(16, stream.streamHandle, stream, callback);
        return FSound.FSOUND_Stream_SetSyncCallback(stream.streamHandle);
    }

    private static native boolean FSOUND_Stream_SetSyncCallback(long var0);

    public static int FSOUND_Stream_SetTime(FSoundStream stream, int ms) {
        return FSound.nFSOUND_Stream_SetTime(stream.streamHandle, ms);
    }

    private static native int nFSOUND_Stream_SetTime(long var0, int var2);

    public static native boolean FSOUND_CD_OpenTray(char var0, boolean var1);

    public static native int FSOUND_CD_GetNumTracks(char var0);

    public static native boolean FSOUND_CD_GetPaused(char var0);

    public static native int FSOUND_CD_GetTrack(char var0);

    public static native int FSOUND_CD_GetTrackLength(char var0, int var1);

    public static native int FSOUND_CD_GetTrackTime(char var0);

    public static native boolean FSOUND_CD_Play(char var0, int var1);

    public static native boolean FSOUND_CD_SetPaused(char var0, boolean var1);

    public static native void FSOUND_CD_SetPlayMode(char var0, int var1);

    public static native boolean FSOUND_CD_SetTrackTime(char var0, int var1);

    public static native boolean FSOUND_CD_SetVolume(char var0, int var1);

    public static native boolean FSOUND_CD_Stop(char var0);

    public static native void FSOUND_DSP_ClearMixBuffer();

    public static FSoundDSPUnit FSOUND_DSP_Create(FSoundDSPCallback callbackHandler, int priority) {
        FSoundDSPUnit dspUnit = null;
        ByteBuffer handle = FSound.nFSOUND_DSP_Create(priority);
        if (handle != null) {
            ByteBuffer dspID = (ByteBuffer)BufferUtils.createByteBuffer((int)8).putLong(FSoundDSPUnit.getNextId()).flip();
            dspUnit = new FSoundDSPUnit(handle, dspID);
            FMOD.registerCallback(4, dspID.getLong(0), dspUnit, callbackHandler);
        }
        return dspUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_Create(int var0);

    public static void FSOUND_DSP_Free(FSoundDSPUnit unit) {
        FSound.nFSOUND_DSP_Free(unit.dspHandle);
        FMOD.registerCallback(4, unit.dspTrackingID.get(0), unit, null);
    }

    private static native void nFSOUND_DSP_Free(ByteBuffer var0);

    public static void FSOUND_DSP_SetActive(FSoundDSPUnit unit, boolean active) {
        FSound.nFSOUND_DSP_SetActive(unit.dspHandle, active);
    }

    private static native void nFSOUND_DSP_SetActive(ByteBuffer var0, boolean var1);

    public static boolean FSOUND_DSP_GetActive(FSoundDSPUnit unit) {
        return FSound.nFSOUND_DSP_GetActive(unit.dspHandle);
    }

    private static native boolean nFSOUND_DSP_GetActive(ByteBuffer var0);

    public static native int FSOUND_DSP_GetBufferLength();

    public static native int FSOUND_DSP_GetBufferLengthTotal();

    public static void FSOUND_DSP_SetPriority(FSoundDSPUnit unit, int priority) {
        FSound.nFSOUND_DSP_SetPriority(unit.dspHandle, priority);
    }

    private static native void nFSOUND_DSP_SetPriority(ByteBuffer var0, int var1);

    public static int FSOUND_DSP_GetPriority(FSoundDSPUnit unit) {
        return FSound.nFSOUND_DSP_GetPriority(unit.dspHandle);
    }

    private static native int nFSOUND_DSP_GetPriority(ByteBuffer var0);

    public static FSoundDSPUnit FSOUND_DSP_GetClearUnit() {
        if (FMOD.fmodClearUnit == null) {
            FMOD.fmodClearUnit = new FSoundDSPUnit(FSound.nFSOUND_DSP_GetClearUnit());
        }
        return FMOD.fmodClearUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_GetClearUnit();

    public static FSoundDSPUnit FSOUND_DSP_GetClipAndCopyUnit() {
        if (FMOD.fmodClipAndCopyUnit == null) {
            FMOD.fmodClipAndCopyUnit = new FSoundDSPUnit(FSound.nFSOUND_DSP_GetClipAndCopyUnit());
        }
        return FMOD.fmodClipAndCopyUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_GetClipAndCopyUnit();

    public static FSoundDSPUnit FSOUND_DSP_GetMusicUnit() {
        if (FMOD.fmodMusicUnit == null) {
            FMOD.fmodMusicUnit = new FSoundDSPUnit(FSound.nFSOUND_DSP_GetMusicUnit());
        }
        return FMOD.fmodMusicUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_GetMusicUnit();

    public static FSoundDSPUnit FSOUND_DSP_GetSFXUnit() {
        if (FMOD.fmodSFXUnit == null) {
            FMOD.fmodSFXUnit = new FSoundDSPUnit(FSound.nFSOUND_DSP_GetSFXUnit());
        }
        return FMOD.fmodSFXUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_GetSFXUnit();

    public static FSoundDSPUnit FSOUND_DSP_GetFFTUnit() {
        if (FMOD.fmodFFTUnit == null) {
            FMOD.fmodFFTUnit = new FSoundDSPUnit(FSound.nFSOUND_DSP_GetFFTUnit());
        }
        return FMOD.fmodFFTUnit;
    }

    private static native ByteBuffer nFSOUND_DSP_GetFFTUnit();

    public static FloatBuffer FSOUND_DSP_GetSpectrum() {
        return FSound.nFSOUND_DSP_GetSpectrum().order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    private static native ByteBuffer nFSOUND_DSP_GetSpectrum();

    public static boolean FSOUND_DSP_MixBuffers(ByteBuffer destbuffer, ByteBuffer srcbuffer, int len, int freq, int vol, int pan, int mode) {
        return FSound.nFSOUND_DSP_MixBuffers(destbuffer, destbuffer.position(), srcbuffer, srcbuffer.position(), len, freq, vol, pan, mode);
    }

    private static native boolean nFSOUND_DSP_MixBuffers(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static native boolean FSOUND_FX_Disable(int var0);

    public static native int FSOUND_FX_Enable(int var0, int var1);

    public static native boolean FSOUND_FX_SetChorus(int var0, float var1, float var2, float var3, float var4, int var5, float var6, int var7);

    public static native boolean FSOUND_FX_SetCompressor(int var0, float var1, float var2, float var3, float var4, float var5, float var6);

    public static native boolean FSOUND_FX_SetDistortion(int var0, float var1, float var2, float var3, float var4, float var5);

    public static native boolean FSOUND_FX_SetEcho(int var0, float var1, float var2, float var3, float var4, int var5);

    public static native boolean FSOUND_FX_SetFlanger(int var0, float var1, float var2, float var3, float var4, int var5, float var6, int var7);

    public static native boolean FSOUND_FX_SetGargle(int var0, int var1, int var2);

    public static native boolean FSOUND_FX_SetI3DL2Reverb(int var0, int var1, int var2, float var3, float var4, float var5, int var6, float var7, int var8, float var9, float var10, float var11, float var12);

    public static native boolean FSOUND_FX_SetParamEQ(int var0, float var1, float var2, float var3);

    public static native boolean FSOUND_FX_SetWavesReverb(int var0, float var1, float var2, float var3, float var4);

    public static native int FSOUND_Record_GetDriver();

    public static native String FSOUND_Record_GetDriverName(int var0);

    public static native int FSOUND_Record_GetNumDrivers();

    public static native int FSOUND_Record_GetPosition();

    public static native boolean FSOUND_Record_SetDriver(int var0);

    public static boolean FSOUND_Record_StartSample(FSoundSample sample, boolean loop) {
        return FSound.nFSOUND_Record_StartSample(sample.sampleHandle, loop);
    }

    private static native boolean nFSOUND_Record_StartSample(long var0, boolean var2);

    public static native boolean FSOUND_Record_Stop();

    public static boolean FSOUND_Reverb_SetProperties(FSoundReverbProperties reverb) {
        return FSound.nFSOUND_Reverb_SetProperties(reverb.reverbHandle);
    }

    private static native boolean nFSOUND_Reverb_SetProperties(long var0);

    public static boolean FSOUND_Reverb_GetProperties(FSoundReverbProperties reverb) {
        return FSound.nFSOUND_Reverb_GetProperties(reverb.reverbHandle);
    }

    private static native boolean nFSOUND_Reverb_GetProperties(long var0);

    public static boolean FSOUND_Reverb_SetChannelProperties(int channel, FSoundReverbChannelProperties reverb) {
        return FSound.nFSOUND_Reverb_SetChannelProperties(channel, reverb.reverbHandle);
    }

    private static native boolean nFSOUND_Reverb_SetChannelProperties(int var0, long var1);

    public static boolean FSOUND_Reverb_GetChannelProperties(int channel, FSoundReverbChannelProperties reverb) {
        return FSound.nFSOUND_Reverb_GetChannelProperties(channel, reverb.reverbHandle);
    }

    private static native boolean nFSOUND_Reverb_GetChannelProperties(int var0, long var1);

    private static ByteBuffer dsp_callback(long dsp_id, ByteBuffer originalbuffer, ByteBuffer newbuffer, int length) {
        ArrayList handlers = FMOD.getCallbacks(4, dsp_id);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundDSPCallback callback = (FSoundDSPCallback)wCallback.callback;
        return callback.FSOUND_DSPCALLBACK(originalbuffer, newbuffer, length);
    }

    private static void stream_callback(long streamHandle, ByteBuffer buff, int length) {
        ArrayList handlers = FMOD.getCallbacks(5, streamHandle);
        for (int i = 0; i < handlers.size(); ++i) {
            FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(i);
            FSoundStreamCallback callback = (FSoundStreamCallback)wCallback.callback;
            callback.FSOUND_STREAMCALLBACK((FSoundStream)wCallback.handled, buff, length);
        }
    }

    private static void end_callback(long streamHandle) {
        ArrayList handlers = FMOD.getCallbacks(15, streamHandle);
        for (int i = 0; i < handlers.size(); ++i) {
            FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(i);
            FSoundStreamCallback callback = (FSoundStreamCallback)wCallback.callback;
            callback.FSOUND_STREAMCALLBACK((FSoundStream)wCallback.handled, null, 0);
        }
    }

    private static void sync_callback(long streamHandle, ByteBuffer buff, int lenght) {
        ArrayList handlers = FMOD.getCallbacks(16, streamHandle);
        for (int i = 0; i < handlers.size(); ++i) {
            FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(i);
            FSoundStreamCallback callback = (FSoundStreamCallback)wCallback.callback;
            callback.FSOUND_STREAMCALLBACK((FSoundStream)wCallback.handled, buff, lenght);
        }
    }

    private static int open_callback(String name) {
        ArrayList handlers = FMOD.getCallbacks(9, -1L);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundOpenCallback callback = (FSoundOpenCallback)wCallback.callback;
        return callback.FSOUND_OPENCALLBACK(name);
    }

    private static void close_callback(int handle) {
        ArrayList handlers = FMOD.getCallbacks(10, -1L);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundCloseCallback callback = (FSoundCloseCallback)wCallback.callback;
        callback.FSOUND_CLOSECALLBACK(handle);
    }

    private static int read_callback(ByteBuffer buffer, int size, int handle) {
        ArrayList handlers = FMOD.getCallbacks(12, -1L);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundReadCallback callback = (FSoundReadCallback)wCallback.callback;
        return callback.FSOUND_READCALLBACK(buffer, size, handle);
    }

    private static int seek_callback(int handle, int pos, int mode) {
        ArrayList handlers = FMOD.getCallbacks(13, -1L);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundSeekCallback callback = (FSoundSeekCallback)wCallback.callback;
        return callback.FSOUND_SEEKCALLBACK(handle, pos, mode);
    }

    private static int tell_callback(int handle) {
        ArrayList handlers = FMOD.getCallbacks(14, -1L);
        FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(0);
        FSoundTellCallback callback = (FSoundTellCallback)wCallback.callback;
        return callback.FSOUND_TELLCALLBACK(handle);
    }

    private static void meta_callback(long streamHandle, ByteBuffer name, ByteBuffer value) {
        ArrayList handlers = FMOD.getCallbacks(11, streamHandle);
        for (int i = 0; i < handlers.size(); ++i) {
            FMOD.WrappedCallback wCallback = (FMOD.WrappedCallback)handlers.get(i);
            FSoundMetaDataCallback callback = (FSoundMetaDataCallback)wCallback.callback;
            callback.FSOUND_METADATACALLBACK(name, value);
        }
    }
}

