/**
 * SchemaLong.java This file was generated by XMLSpy 2006sp2 Enterprise Edition.
 * YOU SHOULD NOT MODIFY THIS FILE, BECAUSE IT WILL BE OVERWRITTEN WHEN YOU
 * RE-RUN CODE GENERATION. Refer to the XMLSpy Documentation for further
 * details. http://www.altova.com/xmlspy
 */

package com.jmex.model.collada.types;

import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaLong implements SchemaTypeNumber {

    private static final long serialVersionUID = 1L;
    protected long value;
    protected boolean isempty;
    protected boolean isnull;

    // construction
    public SchemaLong() {
        setEmpty();
    }

    public SchemaLong(SchemaLong newvalue) {
        value = newvalue.value;
        isempty = newvalue.isempty;
        isnull = newvalue.isnull;
    }

    public SchemaLong(long newvalue) {
        setValue(newvalue);
    }

    public SchemaLong(String newvalue) {
        parse(newvalue);
    }

    public SchemaLong(SchemaType newvalue) {
        assign(newvalue);
    }

    public SchemaLong(SchemaTypeNumber newvalue) {
        assign(newvalue);
    }

    // getValue, setValue
    public long getValue() {
        return value;
    }

    public void setValue(long newvalue) {
        value = newvalue;
        isempty = false;
        isnull = false;
    }

    public void parse(String newvalue) {
        if (newvalue == null)
            setNull();
        else if (newvalue.length() == 0)
            setEmpty();
        else {
            try {
                value = Long.parseLong(newvalue);
                isempty = false;
                isnull = false;
            } catch (NumberFormatException e) {
                throw new StringParseException(e);
            }
        }
    }

    public void assign(SchemaType newvalue) {
        if (newvalue == null || newvalue.isNull())
            setNull();
        else if (newvalue.isEmpty())
            setEmpty();
        else if (newvalue instanceof SchemaTypeNumber) {
            value = ((SchemaTypeNumber) newvalue).longValue();
            isempty = false;
            isnull = false;
        } else
            throw new TypesIncompatibleException(newvalue, this);
    }

    public void setNull() {
        isnull = true;
        isempty = true;
        value = 0;
    }

    public void setEmpty() {
        isnull = false;
        isempty = true;
        value = 0;
    }

    // further
    public int hashCode() {
        return (int) value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaLong))
            return false;
        return value == ((SchemaLong) obj).value;
    }

    public Object clone() {
        return new SchemaLong(this);
    }

    public String toString() {
        if (isempty || isnull)
            return "";
        return Long.toString(value);
    }

    public int length() {
        return toString().length();
    }

    public boolean booleanValue() {
        return value != 0;
    }

    public boolean isEmpty() {
        return isempty;
    }

    public boolean isNull() {
        return isnull;
    }

    public int compareTo(Object obj) {
        return compareTo((SchemaLong) obj);
    }

    public int compareTo(SchemaLong obj) {
        return new Long(value).compareTo(new Long(obj.value));
    }

    // interface SchemaTypeNumber
    public int numericType() {
        return NUMERIC_VALUE_LONG;
    }

    public int intValue() {
        return (int) value;
    }

    public long longValue() {
        return value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(value);
    }

    public float floatValue() {
        return value;
    }

    public double doubleValue() {
        return value;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(value);
    }
}
