/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.internal.view.SupportMenuItem;
import android.support.v4.view.ActionProvider;
import android.support.v4.view.MenuItemCompatHoneycomb;
import android.support.v4.view.MenuItemCompatIcs;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;

public class MenuItemCompat {
    private static final String TAG = "MenuItemCompat";
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;
    static final MenuVersionImpl IMPL;

    public static boolean setShowAsAction(MenuItem item, int actionEnum) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setShowAsAction(actionEnum);
            return true;
        }
        return IMPL.setShowAsAction(item, actionEnum);
    }

    public static MenuItem setActionView(MenuItem item, View view) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setActionView(view);
        }
        return IMPL.setActionView(item, view);
    }

    public static MenuItem setActionView(MenuItem item, int resId) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setActionView(resId);
        }
        return IMPL.setActionView(item, resId);
    }

    public static View getActionView(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getActionView();
        }
        return IMPL.getActionView(item);
    }

    public static MenuItem setActionProvider(MenuItem item, ActionProvider provider) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setSupportActionProvider(provider);
        }
        Log.w((String)TAG, (String)"setActionProvider: item does not implement SupportMenuItem; ignoring");
        return item;
    }

    public static ActionProvider getActionProvider(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getSupportActionProvider();
        }
        Log.w((String)TAG, (String)"getActionProvider: item does not implement SupportMenuItem; returning null");
        return null;
    }

    public static boolean expandActionView(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).expandActionView();
        }
        return IMPL.expandActionView(item);
    }

    public static boolean collapseActionView(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).collapseActionView();
        }
        return IMPL.collapseActionView(item);
    }

    public static boolean isActionViewExpanded(MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).isActionViewExpanded();
        }
        return IMPL.isActionViewExpanded(item);
    }

    public static MenuItem setOnActionExpandListener(MenuItem item, OnActionExpandListener listener) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setSupportOnActionExpandListener(listener);
        }
        return IMPL.setOnActionExpandListener(item, listener);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 14 ? new IcsMenuVersionImpl() : (version >= 11 ? new HoneycombMenuVersionImpl() : new BaseMenuVersionImpl());
    }

    static class IcsMenuVersionImpl
    extends HoneycombMenuVersionImpl {
        IcsMenuVersionImpl() {
        }

        public boolean expandActionView(MenuItem item) {
            return MenuItemCompatIcs.expandActionView(item);
        }

        public boolean collapseActionView(MenuItem item) {
            return MenuItemCompatIcs.collapseActionView(item);
        }

        public boolean isActionViewExpanded(MenuItem item) {
            return MenuItemCompatIcs.isActionViewExpanded(item);
        }

        public MenuItem setOnActionExpandListener(MenuItem item, final OnActionExpandListener listener) {
            if (listener == null) {
                return MenuItemCompatIcs.setOnActionExpandListener(item, null);
            }
            return MenuItemCompatIcs.setOnActionExpandListener(item, new MenuItemCompatIcs.SupportActionExpandProxy(){

                public boolean onMenuItemActionExpand(MenuItem item) {
                    return listener.onMenuItemActionExpand(item);
                }

                public boolean onMenuItemActionCollapse(MenuItem item) {
                    return listener.onMenuItemActionCollapse(item);
                }
            });
        }
    }

    static class HoneycombMenuVersionImpl
    implements MenuVersionImpl {
        HoneycombMenuVersionImpl() {
        }

        public boolean setShowAsAction(MenuItem item, int actionEnum) {
            MenuItemCompatHoneycomb.setShowAsAction(item, actionEnum);
            return true;
        }

        public MenuItem setActionView(MenuItem item, View view) {
            return MenuItemCompatHoneycomb.setActionView(item, view);
        }

        public MenuItem setActionView(MenuItem item, int resId) {
            return MenuItemCompatHoneycomb.setActionView(item, resId);
        }

        public View getActionView(MenuItem item) {
            return MenuItemCompatHoneycomb.getActionView(item);
        }

        public boolean expandActionView(MenuItem item) {
            return false;
        }

        public boolean collapseActionView(MenuItem item) {
            return false;
        }

        public boolean isActionViewExpanded(MenuItem item) {
            return false;
        }

        public MenuItem setOnActionExpandListener(MenuItem item, OnActionExpandListener listener) {
            return item;
        }
    }

    static class BaseMenuVersionImpl
    implements MenuVersionImpl {
        BaseMenuVersionImpl() {
        }

        public boolean setShowAsAction(MenuItem item, int actionEnum) {
            return false;
        }

        public MenuItem setActionView(MenuItem item, View view) {
            return item;
        }

        public MenuItem setActionView(MenuItem item, int resId) {
            return item;
        }

        public View getActionView(MenuItem item) {
            return null;
        }

        public boolean expandActionView(MenuItem item) {
            return false;
        }

        public boolean collapseActionView(MenuItem item) {
            return false;
        }

        public boolean isActionViewExpanded(MenuItem item) {
            return false;
        }

        public MenuItem setOnActionExpandListener(MenuItem item, OnActionExpandListener listener) {
            return item;
        }
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(MenuItem var1);

        public boolean onMenuItemActionCollapse(MenuItem var1);
    }

    static interface MenuVersionImpl {
        public boolean setShowAsAction(MenuItem var1, int var2);

        public MenuItem setActionView(MenuItem var1, View var2);

        public MenuItem setActionView(MenuItem var1, int var2);

        public View getActionView(MenuItem var1);

        public boolean expandActionView(MenuItem var1);

        public boolean collapseActionView(MenuItem var1);

        public boolean isActionViewExpanded(MenuItem var1);

        public MenuItem setOnActionExpandListener(MenuItem var1, OnActionExpandListener var2);
    }
}

