/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.FileSetDocumentCollection;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.NullReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DispatchingDocumentFactory
extends PropertyBasedDocumentFactory {
    public static final String FIELDNAME = "fieldname";
    public static final String KEY = "key";
    public static final String RULE = "rule";
    public static final String OTHERWISE_IN_RULE = "?";
    public static final String MAP = "map";
    private int n;
    private DocumentFactory[] documentFactory;
    private int numberOfFields;
    private String[] fieldName;
    private int[] fieldType;
    private int[][] rename;
    private DispatchingStrategy strategy;
    private String dispatchingKey;
    private Object2ObjectLinkedOpenHashMap value2factoryClass;
    private final WordReader nullReader;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$DocumentFactory;

    private final void init(DocumentFactory[] documentFactory, String[] fieldName, int[] fieldType, int[][] rename, DispatchingStrategy strategy) {
        this.n = documentFactory.length;
        this.documentFactory = documentFactory;
        this.numberOfFields = fieldName.length;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.rename = rename;
        this.strategy = strategy;
    }

    private final void checkAttributes() throws ConfigurationException {
        if (this.fieldName.length != this.fieldType.length || this.rename.length != this.documentFactory.length || this.documentFactory.length != this.n || this.fieldName.length != this.numberOfFields) {
            throw new ConfigurationException("Length mismatch in defining the dispatching factory");
        }
        int f = 0;
        while (f < this.n) {
            if (this.rename[f].length != this.numberOfFields) {
                throw new ConfigurationException("The number of fields (" + this.numberOfFields + ") does not match the mapping rule for factory " + this.documentFactory[f].getClass().getName());
            }
            int k = 0;
            while (k < this.numberOfFields) {
                if (this.rename[f][k] < -1 || this.rename[f][k] >= this.documentFactory[f].numberOfFields()) {
                    throw new ConfigurationException(this.rename[f][k] + " is not a field of factory " + this.documentFactory[f]);
                }
                if (this.rename[f][k] >= 0 && this.fieldType[k] != this.documentFactory[f].fieldType(this.rename[f][k])) {
                    throw new ConfigurationException("Field " + this.rename[f][k] + " of factory " + this.documentFactory[f] + " has a type different from the type of the field it is mapped to");
                }
                ++k;
            }
            ++f;
        }
        if (this.n == 0 || this.numberOfFields == 0) {
            throw new ConfigurationException("Zero factories or fields specified");
        }
        if (this.strategy == null) {
            throw new ConfigurationException("No strategy was specified");
        }
    }

    private final void setExtraArguments(Object xtraPars) throws ConfigurationException {
        if (this.value2factoryClass == null) {
            throw new ConfigurationException("No rule property was specified for the dispatching factory");
        }
        this.n = this.value2factoryClass.values().size();
        this.documentFactory = new DocumentFactory[this.n];
        Iterator it = this.value2factoryClass.values().iterator();
        int f = 0;
        while (f < this.n) {
            Class documentFactoryClass = (Class)it.next();
            try {
                this.documentFactory[f] = xtraPars == null ? (DocumentFactory)documentFactoryClass.newInstance() : (DocumentFactory)documentFactoryClass.getConstructor(xtraPars.getClass()).newInstance(xtraPars);
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
            ++f;
        }
        this.fieldType = new int[this.numberOfFields];
        if (this.rename == null) {
            throw new ConfigurationException("No map property was specified for the dispatching factory");
        }
        f = 0;
        while (f < this.n) {
            int k = 0;
            while (k < this.numberOfFields) {
                int kk = this.rename[f][k];
                if (kk >= 0 && this.fieldType[k] >= 0 && this.fieldType[k] != this.documentFactory[f].fieldType(kk)) {
                    throw new ConfigurationException("Mismatch between field types for field " + f + ", relative to the remapping of factory " + this.documentFactory[f].getClass().getName() + " (the type used to be " + this.fieldType[k] + ", but now we want it to be " + this.documentFactory[f].fieldType(kk) + ')');
                }
                if (kk >= 0) {
                    this.fieldType[k] = this.documentFactory[f].fieldType(kk);
                }
                ++k;
            }
            ++f;
        }
        f = 0;
        while (f < this.numberOfFields) {
            if (this.fieldType[f] < 0) {
                throw new ConfigurationException("The type of field " + this.fieldName[f] + " could not be deduced, because it is never mapped to");
            }
            ++f;
        }
        if (this.dispatchingKey == null) {
            throw new ConfigurationException("No key property was specified for the dispatching factory");
        }
        Object2IntOpenHashMap value2int = new Object2IntOpenHashMap();
        value2int.defaultReturnValue(-1);
        it = this.value2factoryClass.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            int k = 0;
            while (k < this.n) {
                if (e.getValue() == this.documentFactory[k].getClass()) {
                    if (e.getKey().equals(OTHERWISE_IN_RULE)) {
                        value2int.defaultReturnValue(k);
                        break;
                    }
                    value2int.put(e.getKey(), k);
                    break;
                }
                ++k;
            }
            if (k != this.n) continue;
            throw new ConfigurationException("Mismatch in the rule mapping " + e.getKey() + " to " + e.getValue());
        }
        System.out.println("Building a strategy mapping " + this.dispatchingKey + " to " + value2int);
        this.strategy = new StringBasedDispatchingStrategy(this.dispatchingKey, (Object2IntMap)value2int);
    }

    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap metadata) throws ConfigurationException {
        if (key.equalsIgnoreCase(FIELDNAME)) {
            this.fieldName = values;
            this.numberOfFields = this.fieldName.length;
            return true;
        }
        if (key.equalsIgnoreCase(KEY)) {
            this.dispatchingKey = DispatchingDocumentFactory.ensureJustOne(key, values);
            return true;
        }
        if (key.equalsIgnoreCase(RULE)) {
            String[] rules = values;
            this.value2factoryClass = new Object2ObjectLinkedOpenHashMap();
            int m = rules.length;
            int i = 0;
            while (i < m) {
                int pos = rules[i].indexOf(58);
                if (pos <= 0 || pos == rules[i].length() - 1) {
                    throw new ConfigurationException("Rule " + rules[i] + " does not contain a colon or it is malformed");
                }
                if (rules[i].indexOf(58, pos + 1) >= 0) {
                    throw new ConfigurationException("Rule " + rules[i] + " contains too many colons");
                }
                String factoryName = rules[i].substring(pos + 1);
                Class<?> factoryClass = null;
                try {
                    factoryClass = Class.forName(factoryName);
                    Class clazz = class$it$unimi$dsi$mg4j$document$DocumentFactory;
                    if (clazz == null) {
                        clazz = DispatchingDocumentFactory.class("[Lit.unimi.dsi.mg4j.document.DocumentFactory;", false);
                    }
                    if (!clazz.isAssignableFrom(factoryClass)) {
                        throw new ClassNotFoundException();
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Factory " + factoryName + " is invalid; maybe the package name is missing");
                }
                this.value2factoryClass.put((Object)rules[i].substring(0, pos), factoryClass);
                ++i;
            }
            m = this.value2factoryClass.values().size();
            return true;
        }
        if (key.equalsIgnoreCase(MAP)) {
            String[] pieces = values;
            int m = pieces.length;
            this.rename = new int[m][];
            int i = 0;
            while (i < m) {
                String[] subpieces = pieces[i].split(":");
                if (i > 0 && subpieces.length != this.rename[0].length) {
                    throw new ConfigurationException("Length mismatch in the map " + values);
                }
                this.rename[i] = new int[subpieces.length];
                int k = 0;
                while (k < subpieces.length) {
                    try {
                        this.rename[i][k] = Integer.parseInt(subpieces[k]);
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationException("Number format exception in the map " + values);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return super.parseProperty(key, values, metadata);
    }

    public int numberOfFields() {
        return this.numberOfFields;
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName[field];
    }

    public int fieldIndex(String fieldName) {
        int k = 0;
        while (k < this.numberOfFields) {
            if (this.fieldName[k].equals(fieldName)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return this.fieldType[field];
    }

    public Document getDocument(InputStream rawContent, Reference2ObjectMap metadata) throws IOException {
        final int factoryIndex = this.strategy.factoryNumber(metadata, this);
        System.out.println("The strategy returned " + factoryIndex);
        if (factoryIndex < 0 || factoryIndex >= this.n) {
            throw new IllegalArgumentException();
        }
        System.out.println("Going to parse a document with " + metadata + ", using " + this.documentFactory[factoryIndex].getClass().getName());
        DocumentFactory factory = this.documentFactory[factoryIndex];
        final Document document = factory.getDocument(rawContent, metadata);
        return new Document(){

            public final CharSequence title() {
                return document.title();
            }

            public final String toString() {
                return document.toString();
            }

            public final CharSequence uri() {
                return document.uri();
            }

            public final Object content(int field) throws IOException {
                DispatchingDocumentFactory.this.ensureFieldIndex(field);
                if (DispatchingDocumentFactory.this.rename[factoryIndex][field] < 0) {
                    return NullReader.getInstance();
                }
                return document.content(DispatchingDocumentFactory.this.rename[factoryIndex][field]);
            }

            public final WordReader wordReader(int field) {
                DispatchingDocumentFactory.this.ensureFieldIndex(field);
                if (DispatchingDocumentFactory.this.rename[factoryIndex][field] < 0) {
                    return DispatchingDocumentFactory.this.nullReader;
                }
                return document.wordReader(DispatchingDocumentFactory.this.rename[factoryIndex][field]);
            }

            public final void close() throws IOException {
                document.close();
            }
        };
    }

    public static void main(String[] arg) throws IOException, ConfigurationException {
        Properties p = new Properties();
        p.addProperty(FIELDNAME, "text,title");
        p.addProperty(KEY, "mimetype");
        p.addProperty(RULE, "application/pdf:it.unimi.dsi.mg4j.document.PdfDocumentFactory,text/html:it.unimi.dsi.mg4j.document.HtmlDocumentFactory,?:it.unimi.dsi.mg4j.document.IdentityDocumentFactory");
        p.addProperty(MAP, "0:-1,0:1,0:-1");
        p.addProperty(MAP, "0:-1,0:1,0:-1");
        p.addProperty(MAP, "0:-1,0:1,0:-1");
        p.addProperty("encoding", "iso-8859-1");
        DispatchingDocumentFactory factory = new DispatchingDocumentFactory(p);
        FileSetDocumentCollection dc = new FileSetDocumentCollection(arg, factory);
        BinIO.storeObject((Object)dc, (CharSequence)"test.collection");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.nullReader = new FastBufferedReader();
    }

    public DispatchingDocumentFactory(DocumentFactory[] documentFactory, String[] fieldName, int[] fieldType, int[][] rename, DispatchingStrategy strategy) throws ConfigurationException {
        this.this();
        this.init(documentFactory, fieldName, fieldType, rename, strategy);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.this();
        this.setExtraArguments(properties);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.this();
        this.setExtraArguments(property);
        this.checkAttributes();
    }

    public DispatchingDocumentFactory(Reference2ObjectMap defaultMetadata) throws ConfigurationException {
        super(defaultMetadata);
        this.this();
        this.checkAttributes();
    }

    public DispatchingDocumentFactory() throws ConfigurationException {
        this.this();
        this.checkAttributes();
    }

    public static class StringBasedDispatchingStrategy
    implements DispatchingStrategy {
        private final String key;
        private final Object2IntMap value;

        public int factoryNumber(Reference2ObjectMap metadata, PropertyBasedDocumentFactory factory) {
            Object val = factory.resolve(this.key.intern(), metadata);
            System.out.println("key " + this.key + " resolved using " + metadata + " into " + val);
            if (val == null) {
                return this.value.defaultReturnValue();
            }
            return this.value.getInt(val);
        }

        public StringBasedDispatchingStrategy(String key, Object2IntMap value) {
            this.key = key;
            this.value = value;
        }
    }

    public static interface DispatchingStrategy
    extends Serializable {
        public int factoryNumber(Reference2ObjectMap var1, PropertyBasedDocumentFactory var2);
    }
}

