/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.mail.MessagingException;
import net.fortuna.mstor.MStorMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MailDocumentFactory
extends PropertyBasedDocumentFactory {
    private static final Logger LOGGER;
    private static final String UNAVAILABLE = "UNAVAILABLE";
    private static final String[] fieldName;
    private static final int[] fieldType;
    private static final Object2IntOpenHashMap field2Index;
    private static final int SUBJECT_FIELD_INDEX = 1;
    private static final int BODY_FIELD_INDEX = 7;
    private static final int DATE_FIELD_INDEX = 0;
    private transient WordReader wordReader = new FastBufferedReader();
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$MailDocumentFactory;

    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap metadata) throws ConfigurationException {
        if (key.equals("encoding")) {
            metadata.put((Object)"encoding", (Object)Charset.forName(MailDocumentFactory.ensureJustOne(key, values)).toString());
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    public int numberOfFields() {
        return fieldName.length;
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return fieldName[field];
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return fieldType[field];
    }

    public int fieldIndex(String fieldName) {
        return field2Index.getInt((Object)fieldName);
    }

    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap metadata) {
        String[] fieldValue;
        MStorMessage message;
        try {
            message = new MStorMessage(null, rawContent);
            fieldValue = new String[fieldName.length];
            int i = 0;
            while (i < fieldName.length) {
                String[] fieldValues;
                if (i != 7 && (fieldValues = message.getHeader(fieldName[i])) != null) {
                    MutableString fieldValuesPasted = new MutableString();
                    int j = 0;
                    while (j < fieldValues.length) {
                        fieldValuesPasted.append((j > 0 ? " / " : "") + fieldValues[j]);
                        ++j;
                    }
                    fieldValue[i] = fieldValuesPasted.toString();
                }
                ++i;
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException();
        }
        return new Document(){

            public final CharSequence title() {
                if (fieldValue[1] == null) {
                    return (CharSequence)MailDocumentFactory.this.resolve("title", metadata);
                }
                return fieldValue[1];
            }

            public final String toString() {
                return this.title().toString();
            }

            public final CharSequence uri() {
                return (CharSequence)MailDocumentFactory.this.resolve("uri", metadata);
            }

            public final Object content(int field) {
                MailDocumentFactory.this.ensureFieldIndex(field);
                switch (field) {
                    case 7: {
                        try {
                            String encoding = message.getEncoding();
                            try {
                                if (encoding == null) {
                                    return new InputStreamReader(message.getInputStream(), (String)MailDocumentFactory.this.resolveNotNull("encoding", metadata));
                                }
                                return new InputStreamReader(message.getInputStream(), encoding);
                            }
                            catch (UnsupportedEncodingException e) {
                                try {
                                    LOGGER.warn((Object)("Unsupported charset " + encoding + " in message " + this.toString()));
                                    return new InputStreamReader(message.getInputStream(), (String)MailDocumentFactory.this.resolveNotNull("encoding", metadata));
                                }
                                catch (Exception e1) {
                                    throw new RuntimeException(e1);
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        catch (MessagingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 0: {
                        try {
                            if (fieldValue[0] == null) {
                                return MailDocumentFactory.UNAVAILABLE;
                            }
                            DateFormat dateFormat = DateFormat.getDateInstance(0, (Locale)MailDocumentFactory.this.resolveNotNull("locale", metadata));
                            return dateFormat.parse(fieldValue[0]);
                        }
                        catch (ParseException e) {
                            LOGGER.warn((Object)("Failed to parse date " + fieldValue[0]), (Throwable)e);
                            return MailDocumentFactory.UNAVAILABLE;
                        }
                    }
                }
                if (fieldValue[field] == null) {
                    return new StringReader(MailDocumentFactory.UNAVAILABLE);
                }
                return new StringReader(fieldValue[field]);
            }

            public final WordReader wordReader(int field) {
                MailDocumentFactory.this.ensureFieldIndex(field);
                return MailDocumentFactory.this.wordReader;
            }

            public final void close() throws IOException {
                rawContent.close();
            }
        };
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    static /* synthetic */ int access$1() {
        return 7;
    }

    static /* synthetic */ int access$3() {
        return 0;
    }

    static /* synthetic */ String access$4() {
        return UNAVAILABLE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$document$MailDocumentFactory;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$MailDocumentFactory = MailDocumentFactory.class("[Lit.unimi.dsi.mg4j.document.MailDocumentFactory;", false);
        }
        LOGGER = Fast.getLogger(clazz);
        fieldName = new String[]{"date", "subject", "from", "to", "cc", "bcc", "content-type", "body"};
        int[] nArray = new int[8];
        nArray[0] = 1;
        fieldType = nArray;
        field2Index = new Object2IntOpenHashMap(fieldName.length, 0.5f);
        field2Index.defaultReturnValue(-1);
        int i = 0;
        while (i < fieldName.length) {
            field2Index.put((Object)fieldName[i], i);
            ++i;
        }
    }
}

