/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import org.apache.commons.configuration.ConfigurationException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PdfDocumentFactory
extends PropertyBasedDocumentFactory {
    public static final String PARSE_TITLE = "PARSE_TITLE";
    private transient PDFTextStripper textStripper = new PDFTextStripper();
    private final WordReader wordReader = new FastBufferedReader();

    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap metadata) throws ConfigurationException {
        if (key.equals(PARSE_TITLE)) {
            throw new ConfigurationException("PARSE_TITLE is not yet implemented");
        }
        return super.parseProperty(key, values, metadata);
    }

    public int numberOfFields() {
        return 1;
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return "text";
    }

    public int fieldIndex(String fieldName) {
        return "text".equals(fieldName) + -1;
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return 0;
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.textStripper = new PDFTextStripper();
    }

    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap metadata) {
        return new Document(){
            private PDDocument pdfDocument;
            private Thread pipingThread;
            private PipedReader pipedReader;
            private PipedWriter pipedWriter;

            public final CharSequence title() {
                return (CharSequence)PdfDocumentFactory.this.resolve("title", metadata);
            }

            public final String toString() {
                return this.title().toString();
            }

            public final CharSequence uri() {
                return (CharSequence)PdfDocumentFactory.this.resolve("uri", metadata);
            }

            public final Object content(int field) throws IOException {
                PdfDocumentFactory.this.ensureFieldIndex(field);
                this.pipedReader = new PipedReader();
                this.pipedWriter = new PipedWriter();
                this.pdfDocument = PDDocument.load((InputStream)rawContent);
                this.pipedWriter.connect(this.pipedReader);
                this.pipingThread = new Thread(){

                    public final void run() {
                        try {
                            PdfDocumentFactory.this.textStripper.writeText(pdfDocument, (Writer)pipedWriter);
                            pipedWriter.close();
                            pipedWriter = null;
                        }
                        catch (InterruptedIOException dontCare) {
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                this.pipingThread.start();
                return this.pipedReader;
            }

            public final WordReader wordReader(int field) {
                PdfDocumentFactory.this.ensureFieldIndex(field);
                return PdfDocumentFactory.this.wordReader;
            }

            public final void close() throws IOException {
                if (this.pipingThread != null) {
                    try {
                        this.pipingThread.interrupt();
                        this.pipingThread.join();
                        this.pipingThread = null;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.pipedReader != null) {
                    this.pipedReader.close();
                    this.pipedReader = null;
                }
                if (this.pipedWriter != null) {
                    this.pipedWriter.close();
                    this.pipedWriter = null;
                }
                if (this.pdfDocument != null) {
                    this.pdfDocument.close();
                    this.pdfDocument = null;
                }
            }
        };
    }

    public PdfDocumentFactory() throws IOException {
    }

    public PdfDocumentFactory(Properties properties) throws IOException, ConfigurationException {
        super(properties);
    }

    public PdfDocumentFactory(Reference2ObjectMap defaultMetadata) throws IOException {
        super(defaultMetadata);
    }

    public PdfDocumentFactory(String[] property) throws IOException, ConfigurationException {
        super(property);
    }
}

