/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.mg4j.io.NullInputStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InputBitStream
implements BooleanIterator {
    public static final int UNGET_BUFFER_SIZE = 16;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int[] GAMMA;
    private static final int[] DELTA;
    private static final int[] ZETA_3;
    protected InputStream is;
    private long readBits;
    private int current;
    protected byte[] buffer;
    private boolean noBuffer;
    protected int fill;
    protected int pos;
    protected int avail;
    protected long position;
    protected byte[] ungetBytes;
    protected int ungetCount;
    protected boolean overflow;
    protected boolean pastEOF;
    protected FileChannel fileChannel;
    protected RepositionableStream repositionableStream;
    protected boolean wrapping;
    private static final /* synthetic */ boolean assert;

    public void flush() {
        if (!this.wrapping) {
            this.position += (long)this.pos;
            this.avail = 0;
            this.pos = 0;
        }
        this.fill = 0;
        this.ungetCount = 0;
    }

    public void close() throws IOException {
        if (this.is == null) {
            return;
        }
        if (this.is != System.in) {
            this.is.close();
        }
        this.is = null;
        this.buffer = null;
        this.ungetBytes = null;
    }

    public void overflow(boolean overflow) {
        this.overflow = overflow;
    }

    public long available() throws IOException {
        return (this.is.available() + this.ungetCount + this.avail) * 8 + this.fill;
    }

    public boolean overflow() {
        return this.overflow;
    }

    public boolean pastEOF() {
        return this.pastEOF;
    }

    public long readBits() {
        return this.readBits;
    }

    public void readBits(long readBits) {
        this.readBits = readBits;
    }

    private final int read() throws IOException {
        if (this.ungetCount > 0) {
            return this.ungetBytes[--this.ungetCount] & 0xFF;
        }
        if (this.pastEOF) {
            return 0;
        }
        if (this.noBuffer) {
            int t = this.is.read();
            if (t == -1) {
                if (this.overflow) {
                    this.pastEOF = true;
                    return 0;
                }
                throw new EOFException();
            }
            ++this.position;
            return t;
        }
        if (this.avail == 0) {
            this.avail = this.is.read(this.buffer);
            if (this.avail == -1) {
                this.avail = 0;
                if (this.overflow) {
                    this.pastEOF = true;
                    return 0;
                }
                throw new EOFException();
            }
            this.position += (long)this.pos;
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & 0xFF;
    }

    private final void refill() throws IOException {
        if (this.fill == 0) {
            this.current = this.read();
            this.fill = 8;
        }
        if (this.avail > 0) {
            this.current = this.current << 8 | this.read();
            this.fill += 8;
        } else {
            try {
                this.current = this.current << 8 | this.read();
                this.fill += 8;
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    private final int readFromCurrent(int len) throws IOException {
        if (len == this.fill) {
            this.readBits += (long)len;
            this.fill = 0;
            return this.current & (1 << len) - 1;
        }
        if (this.fill == 0) {
            this.current = this.read();
            this.fill = 8;
        }
        this.readBits += (long)len;
        return this.current >>> (this.fill -= len) & (1 << len) - 1;
    }

    public void align() throws IOException {
        if ((this.fill & 7) == 0) {
            return;
        }
        this.readBits += (long)(this.fill & 7);
        this.fill &= 0xFFFFFFF8;
    }

    public void ungetBit(boolean bit) throws IOException {
        this.unget(bit ? 1 : 0);
    }

    public void unget(boolean bit) throws IOException {
        this.ungetBit(bit);
    }

    public void ungetBit(int bit) throws IOException {
        if (bit < 0 || bit > 1) {
            throw new IllegalArgumentException("The argument " + bit + " is not a bit.");
        }
        this.current = bit != 0 ? (this.current |= 1 << this.fill) : (this.current &= (1 << this.fill) - 1);
        ++this.fill;
        --this.readBits;
        if (this.fill == 16) {
            if (this.ungetCount == 16) {
                throw new IOException("Unget buffer overflow.");
            }
            if (this.ungetBytes == null) {
                this.ungetBytes = new byte[16];
            }
            this.ungetBytes[this.ungetCount++] = (byte)this.current;
            this.fill = 8;
            this.current >>= 8;
        }
    }

    public void unget(int bit) throws IOException {
        this.ungetBit(bit);
    }

    public void ungetLong(long x, int len) throws IOException {
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot unget " + len + " bits from a long.");
        }
        int i = len;
        while (i-- != 0) {
            this.unget((int)(x & 1L));
            x >>>= 1;
        }
    }

    public void ungetInt(int x, int len) throws IOException {
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot unget " + len + " bits from an integer.");
        }
        int i = len;
        while (i-- != 0) {
            this.unget(x & 1);
            x >>>= 1;
        }
    }

    public void read(byte[] bits, int len) throws IOException {
        if (this.fill < 8) {
            this.refill();
        }
        if (len <= this.fill) {
            if (len <= 8) {
                bits[0] = (byte)(this.readFromCurrent(len) << 8 - len);
                return;
            }
            bits[0] = (byte)this.readFromCurrent(8);
            bits[1] = (byte)(this.readFromCurrent(len - 8) << 16 - len);
            return;
        }
        int j = 0;
        if (this.fill >= 8) {
            bits[j++] = (byte)this.readFromCurrent(8);
            len -= 8;
        }
        int shift = this.fill;
        bits[j] = (byte)(this.readFromCurrent(shift) << 8 - shift);
        int i = (len -= shift) >> 3;
        while (i-- != 0) {
            int b = this.read();
            int n = j++;
            bits[n] = (byte)(bits[n] | (b & 0xFF) >>> shift);
            bits[j] = (byte)(b << 8 - shift);
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        if ((len &= 7) != 0) {
            if (len <= 8 - shift) {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)(this.readFromCurrent(len) << 8 - shift - len));
            } else {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)this.readFromCurrent(8 - shift));
                bits[j + 1] = (byte)(this.readFromCurrent(len + shift - 8) << 16 - shift - len);
            }
        }
    }

    public int readBit() throws IOException {
        return this.readFromCurrent(1);
    }

    public int readInt(int len) throws IOException {
        int x = 0;
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into an integer.");
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x = x << 8 | this.read();
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        return x << (len &= 7) | this.readFromCurrent(len);
    }

    public long readLong(int len) throws IOException {
        long x = 0L;
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into a long.");
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x = x << 8 | (long)this.read();
        }
        this.readBits += (long)(len & 0xFFFFFFF8);
        return x << (len &= 7) | (long)this.readFromCurrent(len);
    }

    public long skip(long n) throws IOException {
        if (n <= (long)this.fill) {
            if (n < 0L) {
                throw new IllegalArgumentException("Negative bit skip value: " + n);
            }
            this.fill = (int)((long)this.fill - n);
            this.readBits += n;
            return n;
        }
        long prevReadBits = this.readBits;
        this.readBits += (long)this.fill;
        this.fill = 0;
        long nb = (n -= (long)this.fill) >> 3;
        if (this.buffer != null && nb > (long)this.avail && nb < (long)(this.avail + this.buffer.length)) {
            this.readBits += (long)(this.avail + 1 << 3);
            n -= (long)(this.avail + 1 << 3);
            nb -= (long)(this.avail + 1);
            this.position += (long)(this.pos + this.avail);
            this.avail = 0;
            this.pos = 0;
            this.read();
        }
        if (nb <= (long)this.avail) {
            this.pos += (int)nb;
            this.avail -= (int)nb;
            this.readBits += n & 0xFFFFFFFFFFFFFFF8L;
        } else {
            n -= (long)(this.avail << 3);
            this.readBits += (long)(this.avail << 3);
            long toSkip = nb - (long)this.avail;
            long skipped = this.is.skip(toSkip);
            this.position += (long)(this.avail + this.pos) + skipped;
            this.pos = 0;
            this.avail = 0;
            this.readBits += skipped << 3;
            if (skipped != toSkip) {
                return this.readBits - prevReadBits;
            }
        }
        int residual = (int)(n & 7L);
        if (residual != 0) {
            this.current = this.read();
            this.fill = 8 - residual;
            this.readBits += (long)residual;
        }
        return this.readBits - prevReadBits;
    }

    public void position(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Illegal position: " + position);
        }
        long delta = (position >> 3) - (this.position + (long)this.pos);
        if (delta <= (long)this.avail && delta >= (long)(-this.pos)) {
            this.avail = (int)((long)this.avail - delta);
            this.pos = (int)((long)this.pos + delta);
            this.ungetCount = 0;
            this.fill = 0;
        } else if (this.repositionableStream != null) {
            this.flush();
            this.position = position >> 3;
            this.repositionableStream.position(this.position);
        } else if (this.fileChannel != null) {
            this.flush();
            this.position = position >> 3;
            this.fileChannel.position(this.position);
        } else {
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
        int residual = (int)(position & 7L);
        if (residual != 0) {
            this.current = this.read();
            this.fill = 8 - residual;
        }
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void mark(int readLimit) throws IOException {
        if (this.fill != 0) {
            throw new IOException("You cannot mark a bit stream outside of byte boundaries.");
        }
        this.is.mark(readLimit);
    }

    public void reset() throws IOException {
        this.flush();
        this.is.reset();
    }

    public int readUnary() throws IOException {
        int currentLeftAligned;
        if (this.fill < 8) {
            this.refill();
        }
        if ((currentLeftAligned = this.current << 16 - this.fill & (char)-1) != 0) {
            int x = (currentLeftAligned & 0xFF00) != 0 ? 7 - Fast.BYTEMSB[currentLeftAligned >>> 8] : 15 - Fast.BYTEMSB[currentLeftAligned & 0xFF];
            this.readBits += (long)(x + 1);
            this.fill -= x + 1;
            return x;
        }
        int x = this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8;
        }
        this.fill = Fast.BYTEMSB[this.current];
        this.readBits += (long)((x += 7 - this.fill) + 1);
        return x;
    }

    public long readLongUnary() throws IOException {
        if ((this.current & (1 << this.fill) - 1) != 0) {
            return this.readUnary();
        }
        long x = this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8L;
        }
        this.fill = Fast.BYTEMSB[this.current];
        this.readBits += (x += (long)(7 - this.fill)) + 1L;
        return x;
    }

    public int readGamma() throws IOException {
        int preComp;
        if (this.fill < 8) {
            this.refill();
        }
        if (this.fill >= 8 && (preComp = GAMMA[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
            this.readBits += (long)(preComp >> 8);
            this.fill -= preComp >> 8;
            return preComp & 0xFF;
        }
        int msb = this.readUnary();
        return (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongGamma() throws IOException {
        int preComp;
        if (this.fill < 8) {
            this.refill();
        }
        if (this.fill >= 8 && (preComp = GAMMA[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
            this.readBits += (long)(preComp >> 8);
            this.fill -= preComp >> 8;
            return preComp & 0xFF;
        }
        int msb = this.readUnary();
        return (1L << msb | this.readLong(msb)) - 1L;
    }

    public int readDelta() throws IOException {
        int preComp;
        if (this.fill < 8) {
            this.refill();
        }
        if (this.fill >= 8 && (preComp = DELTA[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
            this.readBits += (long)(preComp >> 8);
            this.fill -= preComp >> 8;
            return preComp & 0xFF;
        }
        int msb = this.readGamma();
        return (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongDelta() throws IOException {
        int preComp;
        if (this.fill < 8) {
            this.refill();
        }
        if (this.fill >= 8 && (preComp = DELTA[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
            this.readBits += (long)(preComp >> 8);
            this.fill -= preComp >> 8;
            return preComp & 0xFF;
        }
        int msb = this.readGamma();
        return (1L << msb | this.readLong(msb)) - 1L;
    }

    public int readMinimalBinary(int b) throws IOException {
        return this.readMinimalBinary(b, Fast.mostSignificantBit(b));
    }

    public int readMinimalBinary(int b, int log2b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        int m = (1 << log2b + 1) - b;
        int x = this.readInt(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + this.readBit() - m;
    }

    public long readLongMinimalBinary(long b) throws IOException {
        return this.readLongMinimalBinary(b, Fast.mostSignificantBit(b));
    }

    public long readLongMinimalBinary(long b, int log2b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        long m = (1L << log2b + 1) - b;
        long x = this.readLong(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + (long)this.readBit() - m;
    }

    public int readGolomb(int b) throws IOException {
        return this.readGolomb(b, Fast.mostSignificantBit(b));
    }

    public int readGolomb(int b, int log2b) throws IOException {
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            return 0;
        }
        int q = this.readUnary() * b;
        return q + this.readMinimalBinary(b, log2b);
    }

    public long readLongGolomb(long b) throws IOException {
        return this.readLongGolomb(b, Fast.mostSignificantBit(b));
    }

    public long readLongGolomb(long b, int log2b) throws IOException {
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            return 0L;
        }
        long q = (long)this.readUnary() * b;
        return q + this.readLongMinimalBinary(b, log2b);
    }

    public int readSkewedGolomb(int b) throws IOException {
        if (b < 0) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0) {
            return 0;
        }
        int M = ((1 << this.readUnary() + 1) - 1) * b;
        int m = M / (2 * b) * b;
        return m + this.readMinimalBinary(M - m);
    }

    public long readLongSkewedGolomb(long b) throws IOException {
        if (b < 0L) {
            throw new IllegalArgumentException("The modulus " + b + " is negative");
        }
        if (b == 0L) {
            return 0L;
        }
        long M = (long)((1 << this.readUnary() + 1) - 1) * b;
        long m = M / ((long)2 * b) * b;
        return m + this.readLongMinimalBinary(M - m);
    }

    public int readZeta(int k) throws IOException {
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3) {
            int preComp;
            if (this.fill < 8) {
                this.refill();
            }
            if (this.fill >= 8 && (preComp = ZETA_3[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
                this.readBits += (long)(preComp >> 8);
                this.fill -= preComp >> 8;
                return preComp & 0xFF;
            }
        }
        int h = this.readUnary();
        int left = 1 << h * k;
        int m = this.readInt(h * k + k - 1);
        if (m < left) {
            return m + left - 1;
        }
        return (m << 1) + this.readBit() - 1;
    }

    public long readLongZeta(int k) throws IOException {
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        if (k == 3) {
            int preComp;
            if (this.fill < 8) {
                this.refill();
            }
            if (this.fill >= 8 && (preComp = ZETA_3[this.current >> (this.fill == 16 ? 8 : this.fill & 7) & 0xFF]) != 0) {
                this.readBits += (long)(preComp >> 8);
                this.fill -= preComp >> 8;
                return preComp & 0xFF;
            }
        }
        int h = this.readUnary();
        long left = 1 << h * k;
        long m = this.readLong(h * k + k - 1);
        if (m < left) {
            return m + left - 1L;
        }
        return (m << 1) + (long)this.readBit() - 1L;
    }

    public int readNibble() throws IOException {
        int b;
        int x = 0;
        do {
            x <<= 3;
            b = this.readBit();
            x |= this.readInt(3);
        } while (b == 0);
        return x;
    }

    public long readLongNibble() throws IOException {
        int b;
        long x = 0L;
        do {
            x <<= 3;
            b = this.readBit();
            x |= (long)this.readInt(3);
        } while (b == 0);
        return x;
    }

    public boolean hasNext() {
        return true;
    }

    public boolean nextBoolean() {
        try {
            boolean bl = false;
            if (this.readBit() != 0) {
                bl = true;
            }
            return bl;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public Object next() {
        return this.nextBoolean();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int skip(int n) {
        try {
            return (int)this.skip((long)n);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final /* synthetic */ void this() {
        this.ungetCount = 0;
        this.overflow = false;
        this.pastEOF = false;
    }

    protected InputBitStream() {
        this.this();
    }

    public InputBitStream(InputStream is) {
        this(is, 16384);
    }

    public InputBitStream(InputStream is, int bufSize) {
        this.this();
        this.is = is;
        boolean bl = false;
        if (bufSize == 0) {
            bl = this.noBuffer = true;
        }
        if (!bl) {
            this.buffer = new byte[bufSize];
        }
        if (is instanceof RepositionableStream) {
            this.repositionableStream = (RepositionableStream)is;
        }
        if (this.repositionableStream == null) {
            try {
                this.fileChannel = (FileChannel)is.getClass().getMethod("getChannel", new Class[0]).invoke((Object)is, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public InputBitStream(byte[] a) {
        this.this();
        this.is = NullInputStream.getInstance();
        this.buffer = a;
        this.avail = a.length;
        this.wrapping = true;
    }

    public InputBitStream(String name, int bufSize) throws FileNotFoundException {
        this(new FileInputStream(name), bufSize);
    }

    public InputBitStream(String name) throws FileNotFoundException {
        this(new FileInputStream(name), 16384);
    }

    public InputBitStream(File file) throws FileNotFoundException {
        this(new FileInputStream(file), 16384);
    }

    public InputBitStream(File file, int bufSize) throws FileNotFoundException {
        this(new FileInputStream(file), bufSize);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.io.InputBitStream;").getComponentType().desiredAssertionStatus() ^ true;
        int[] nArray = new int[256];
        nArray[16] = 1799;
        nArray[17] = 1799;
        nArray[18] = 1800;
        nArray[19] = 1800;
        nArray[20] = 1801;
        nArray[21] = 1801;
        nArray[22] = 1802;
        nArray[23] = 1802;
        nArray[24] = 1803;
        nArray[25] = 1803;
        nArray[26] = 1804;
        nArray[27] = 1804;
        nArray[28] = 1805;
        nArray[29] = 1805;
        nArray[30] = 1806;
        nArray[31] = 1806;
        nArray[32] = 1283;
        nArray[33] = 1283;
        nArray[34] = 1283;
        nArray[35] = 1283;
        nArray[36] = 1283;
        nArray[37] = 1283;
        nArray[38] = 1283;
        nArray[39] = 1283;
        nArray[40] = 1284;
        nArray[41] = 1284;
        nArray[42] = 1284;
        nArray[43] = 1284;
        nArray[44] = 1284;
        nArray[45] = 1284;
        nArray[46] = 1284;
        nArray[47] = 1284;
        nArray[48] = 1285;
        nArray[49] = 1285;
        nArray[50] = 1285;
        nArray[51] = 1285;
        nArray[52] = 1285;
        nArray[53] = 1285;
        nArray[54] = 1285;
        nArray[55] = 1285;
        nArray[56] = 1286;
        nArray[57] = 1286;
        nArray[58] = 1286;
        nArray[59] = 1286;
        nArray[60] = 1286;
        nArray[61] = 1286;
        nArray[62] = 1286;
        nArray[63] = 1286;
        nArray[64] = 769;
        nArray[65] = 769;
        nArray[66] = 769;
        nArray[67] = 769;
        nArray[68] = 769;
        nArray[69] = 769;
        nArray[70] = 769;
        nArray[71] = 769;
        nArray[72] = 769;
        nArray[73] = 769;
        nArray[74] = 769;
        nArray[75] = 769;
        nArray[76] = 769;
        nArray[77] = 769;
        nArray[78] = 769;
        nArray[79] = 769;
        nArray[80] = 769;
        nArray[81] = 769;
        nArray[82] = 769;
        nArray[83] = 769;
        nArray[84] = 769;
        nArray[85] = 769;
        nArray[86] = 769;
        nArray[87] = 769;
        nArray[88] = 769;
        nArray[89] = 769;
        nArray[90] = 769;
        nArray[91] = 769;
        nArray[92] = 769;
        nArray[93] = 769;
        nArray[94] = 769;
        nArray[95] = 769;
        nArray[96] = 770;
        nArray[97] = 770;
        nArray[98] = 770;
        nArray[99] = 770;
        nArray[100] = 770;
        nArray[101] = 770;
        nArray[102] = 770;
        nArray[103] = 770;
        nArray[104] = 770;
        nArray[105] = 770;
        nArray[106] = 770;
        nArray[107] = 770;
        nArray[108] = 770;
        nArray[109] = 770;
        nArray[110] = 770;
        nArray[111] = 770;
        nArray[112] = 770;
        nArray[113] = 770;
        nArray[114] = 770;
        nArray[115] = 770;
        nArray[116] = 770;
        nArray[117] = 770;
        nArray[118] = 770;
        nArray[119] = 770;
        nArray[120] = 770;
        nArray[121] = 770;
        nArray[122] = 770;
        nArray[123] = 770;
        nArray[124] = 770;
        nArray[125] = 770;
        nArray[126] = 770;
        nArray[127] = 770;
        nArray[128] = 256;
        nArray[129] = 256;
        nArray[130] = 256;
        nArray[131] = 256;
        nArray[132] = 256;
        nArray[133] = 256;
        nArray[134] = 256;
        nArray[135] = 256;
        nArray[136] = 256;
        nArray[137] = 256;
        nArray[138] = 256;
        nArray[139] = 256;
        nArray[140] = 256;
        nArray[141] = 256;
        nArray[142] = 256;
        nArray[143] = 256;
        nArray[144] = 256;
        nArray[145] = 256;
        nArray[146] = 256;
        nArray[147] = 256;
        nArray[148] = 256;
        nArray[149] = 256;
        nArray[150] = 256;
        nArray[151] = 256;
        nArray[152] = 256;
        nArray[153] = 256;
        nArray[154] = 256;
        nArray[155] = 256;
        nArray[156] = 256;
        nArray[157] = 256;
        nArray[158] = 256;
        nArray[159] = 256;
        nArray[160] = 256;
        nArray[161] = 256;
        nArray[162] = 256;
        nArray[163] = 256;
        nArray[164] = 256;
        nArray[165] = 256;
        nArray[166] = 256;
        nArray[167] = 256;
        nArray[168] = 256;
        nArray[169] = 256;
        nArray[170] = 256;
        nArray[171] = 256;
        nArray[172] = 256;
        nArray[173] = 256;
        nArray[174] = 256;
        nArray[175] = 256;
        nArray[176] = 256;
        nArray[177] = 256;
        nArray[178] = 256;
        nArray[179] = 256;
        nArray[180] = 256;
        nArray[181] = 256;
        nArray[182] = 256;
        nArray[183] = 256;
        nArray[184] = 256;
        nArray[185] = 256;
        nArray[186] = 256;
        nArray[187] = 256;
        nArray[188] = 256;
        nArray[189] = 256;
        nArray[190] = 256;
        nArray[191] = 256;
        nArray[192] = 256;
        nArray[193] = 256;
        nArray[194] = 256;
        nArray[195] = 256;
        nArray[196] = 256;
        nArray[197] = 256;
        nArray[198] = 256;
        nArray[199] = 256;
        nArray[200] = 256;
        nArray[201] = 256;
        nArray[202] = 256;
        nArray[203] = 256;
        nArray[204] = 256;
        nArray[205] = 256;
        nArray[206] = 256;
        nArray[207] = 256;
        nArray[208] = 256;
        nArray[209] = 256;
        nArray[210] = 256;
        nArray[211] = 256;
        nArray[212] = 256;
        nArray[213] = 256;
        nArray[214] = 256;
        nArray[215] = 256;
        nArray[216] = 256;
        nArray[217] = 256;
        nArray[218] = 256;
        nArray[219] = 256;
        nArray[220] = 256;
        nArray[221] = 256;
        nArray[222] = 256;
        nArray[223] = 256;
        nArray[224] = 256;
        nArray[225] = 256;
        nArray[226] = 256;
        nArray[227] = 256;
        nArray[228] = 256;
        nArray[229] = 256;
        nArray[230] = 256;
        nArray[231] = 256;
        nArray[232] = 256;
        nArray[233] = 256;
        nArray[234] = 256;
        nArray[235] = 256;
        nArray[236] = 256;
        nArray[237] = 256;
        nArray[238] = 256;
        nArray[239] = 256;
        nArray[240] = 256;
        nArray[241] = 256;
        nArray[242] = 256;
        nArray[243] = 256;
        nArray[244] = 256;
        nArray[245] = 256;
        nArray[246] = 256;
        nArray[247] = 256;
        nArray[248] = 256;
        nArray[249] = 256;
        nArray[250] = 256;
        nArray[251] = 256;
        nArray[252] = 256;
        nArray[253] = 256;
        nArray[254] = 256;
        nArray[255] = 256;
        GAMMA = nArray;
        int[] nArray2 = new int[256];
        nArray2[32] = 2055;
        nArray2[33] = 2056;
        nArray2[34] = 2057;
        nArray2[35] = 2058;
        nArray2[36] = 2059;
        nArray2[37] = 2060;
        nArray2[38] = 2061;
        nArray2[39] = 2062;
        nArray2[64] = 1025;
        nArray2[65] = 1025;
        nArray2[66] = 1025;
        nArray2[67] = 1025;
        nArray2[68] = 1025;
        nArray2[69] = 1025;
        nArray2[70] = 1025;
        nArray2[71] = 1025;
        nArray2[72] = 1025;
        nArray2[73] = 1025;
        nArray2[74] = 1025;
        nArray2[75] = 1025;
        nArray2[76] = 1025;
        nArray2[77] = 1025;
        nArray2[78] = 1025;
        nArray2[79] = 1025;
        nArray2[80] = 1026;
        nArray2[81] = 1026;
        nArray2[82] = 1026;
        nArray2[83] = 1026;
        nArray2[84] = 1026;
        nArray2[85] = 1026;
        nArray2[86] = 1026;
        nArray2[87] = 1026;
        nArray2[88] = 1026;
        nArray2[89] = 1026;
        nArray2[90] = 1026;
        nArray2[91] = 1026;
        nArray2[92] = 1026;
        nArray2[93] = 1026;
        nArray2[94] = 1026;
        nArray2[95] = 1026;
        nArray2[96] = 1283;
        nArray2[97] = 1283;
        nArray2[98] = 1283;
        nArray2[99] = 1283;
        nArray2[100] = 1283;
        nArray2[101] = 1283;
        nArray2[102] = 1283;
        nArray2[103] = 1283;
        nArray2[104] = 1284;
        nArray2[105] = 1284;
        nArray2[106] = 1284;
        nArray2[107] = 1284;
        nArray2[108] = 1284;
        nArray2[109] = 1284;
        nArray2[110] = 1284;
        nArray2[111] = 1284;
        nArray2[112] = 1285;
        nArray2[113] = 1285;
        nArray2[114] = 1285;
        nArray2[115] = 1285;
        nArray2[116] = 1285;
        nArray2[117] = 1285;
        nArray2[118] = 1285;
        nArray2[119] = 1285;
        nArray2[120] = 1286;
        nArray2[121] = 1286;
        nArray2[122] = 1286;
        nArray2[123] = 1286;
        nArray2[124] = 1286;
        nArray2[125] = 1286;
        nArray2[126] = 1286;
        nArray2[127] = 1286;
        nArray2[128] = 256;
        nArray2[129] = 256;
        nArray2[130] = 256;
        nArray2[131] = 256;
        nArray2[132] = 256;
        nArray2[133] = 256;
        nArray2[134] = 256;
        nArray2[135] = 256;
        nArray2[136] = 256;
        nArray2[137] = 256;
        nArray2[138] = 256;
        nArray2[139] = 256;
        nArray2[140] = 256;
        nArray2[141] = 256;
        nArray2[142] = 256;
        nArray2[143] = 256;
        nArray2[144] = 256;
        nArray2[145] = 256;
        nArray2[146] = 256;
        nArray2[147] = 256;
        nArray2[148] = 256;
        nArray2[149] = 256;
        nArray2[150] = 256;
        nArray2[151] = 256;
        nArray2[152] = 256;
        nArray2[153] = 256;
        nArray2[154] = 256;
        nArray2[155] = 256;
        nArray2[156] = 256;
        nArray2[157] = 256;
        nArray2[158] = 256;
        nArray2[159] = 256;
        nArray2[160] = 256;
        nArray2[161] = 256;
        nArray2[162] = 256;
        nArray2[163] = 256;
        nArray2[164] = 256;
        nArray2[165] = 256;
        nArray2[166] = 256;
        nArray2[167] = 256;
        nArray2[168] = 256;
        nArray2[169] = 256;
        nArray2[170] = 256;
        nArray2[171] = 256;
        nArray2[172] = 256;
        nArray2[173] = 256;
        nArray2[174] = 256;
        nArray2[175] = 256;
        nArray2[176] = 256;
        nArray2[177] = 256;
        nArray2[178] = 256;
        nArray2[179] = 256;
        nArray2[180] = 256;
        nArray2[181] = 256;
        nArray2[182] = 256;
        nArray2[183] = 256;
        nArray2[184] = 256;
        nArray2[185] = 256;
        nArray2[186] = 256;
        nArray2[187] = 256;
        nArray2[188] = 256;
        nArray2[189] = 256;
        nArray2[190] = 256;
        nArray2[191] = 256;
        nArray2[192] = 256;
        nArray2[193] = 256;
        nArray2[194] = 256;
        nArray2[195] = 256;
        nArray2[196] = 256;
        nArray2[197] = 256;
        nArray2[198] = 256;
        nArray2[199] = 256;
        nArray2[200] = 256;
        nArray2[201] = 256;
        nArray2[202] = 256;
        nArray2[203] = 256;
        nArray2[204] = 256;
        nArray2[205] = 256;
        nArray2[206] = 256;
        nArray2[207] = 256;
        nArray2[208] = 256;
        nArray2[209] = 256;
        nArray2[210] = 256;
        nArray2[211] = 256;
        nArray2[212] = 256;
        nArray2[213] = 256;
        nArray2[214] = 256;
        nArray2[215] = 256;
        nArray2[216] = 256;
        nArray2[217] = 256;
        nArray2[218] = 256;
        nArray2[219] = 256;
        nArray2[220] = 256;
        nArray2[221] = 256;
        nArray2[222] = 256;
        nArray2[223] = 256;
        nArray2[224] = 256;
        nArray2[225] = 256;
        nArray2[226] = 256;
        nArray2[227] = 256;
        nArray2[228] = 256;
        nArray2[229] = 256;
        nArray2[230] = 256;
        nArray2[231] = 256;
        nArray2[232] = 256;
        nArray2[233] = 256;
        nArray2[234] = 256;
        nArray2[235] = 256;
        nArray2[236] = 256;
        nArray2[237] = 256;
        nArray2[238] = 256;
        nArray2[239] = 256;
        nArray2[240] = 256;
        nArray2[241] = 256;
        nArray2[242] = 256;
        nArray2[243] = 256;
        nArray2[244] = 256;
        nArray2[245] = 256;
        nArray2[246] = 256;
        nArray2[247] = 256;
        nArray2[248] = 256;
        nArray2[249] = 256;
        nArray2[250] = 256;
        nArray2[251] = 256;
        nArray2[252] = 256;
        nArray2[253] = 256;
        nArray2[254] = 256;
        nArray2[255] = 256;
        DELTA = nArray2;
        int[] nArray3 = new int[256];
        nArray3[64] = 1799;
        nArray3[65] = 1799;
        nArray3[66] = 1800;
        nArray3[67] = 1800;
        nArray3[68] = 1801;
        nArray3[69] = 1801;
        nArray3[70] = 1802;
        nArray3[71] = 1802;
        nArray3[72] = 1803;
        nArray3[73] = 1803;
        nArray3[74] = 1804;
        nArray3[75] = 1804;
        nArray3[76] = 1805;
        nArray3[77] = 1805;
        nArray3[78] = 1806;
        nArray3[79] = 1806;
        nArray3[80] = 2063;
        nArray3[81] = 2064;
        nArray3[82] = 2065;
        nArray3[83] = 2066;
        nArray3[84] = 2067;
        nArray3[85] = 2068;
        nArray3[86] = 2069;
        nArray3[87] = 2070;
        nArray3[88] = 2071;
        nArray3[89] = 2072;
        nArray3[90] = 2073;
        nArray3[91] = 2074;
        nArray3[92] = 2075;
        nArray3[93] = 2076;
        nArray3[94] = 2077;
        nArray3[95] = 2078;
        nArray3[96] = 2079;
        nArray3[97] = 2080;
        nArray3[98] = 2081;
        nArray3[99] = 2082;
        nArray3[100] = 2083;
        nArray3[101] = 2084;
        nArray3[102] = 2085;
        nArray3[103] = 2086;
        nArray3[104] = 2087;
        nArray3[105] = 2088;
        nArray3[106] = 2089;
        nArray3[107] = 2090;
        nArray3[108] = 2091;
        nArray3[109] = 2092;
        nArray3[110] = 2093;
        nArray3[111] = 2094;
        nArray3[112] = 2095;
        nArray3[113] = 2096;
        nArray3[114] = 2097;
        nArray3[115] = 2098;
        nArray3[116] = 2099;
        nArray3[117] = 2100;
        nArray3[118] = 2101;
        nArray3[119] = 2102;
        nArray3[120] = 2103;
        nArray3[121] = 2104;
        nArray3[122] = 2105;
        nArray3[123] = 2106;
        nArray3[124] = 2107;
        nArray3[125] = 2108;
        nArray3[126] = 2109;
        nArray3[127] = 2110;
        nArray3[128] = 768;
        nArray3[129] = 768;
        nArray3[130] = 768;
        nArray3[131] = 768;
        nArray3[132] = 768;
        nArray3[133] = 768;
        nArray3[134] = 768;
        nArray3[135] = 768;
        nArray3[136] = 768;
        nArray3[137] = 768;
        nArray3[138] = 768;
        nArray3[139] = 768;
        nArray3[140] = 768;
        nArray3[141] = 768;
        nArray3[142] = 768;
        nArray3[143] = 768;
        nArray3[144] = 768;
        nArray3[145] = 768;
        nArray3[146] = 768;
        nArray3[147] = 768;
        nArray3[148] = 768;
        nArray3[149] = 768;
        nArray3[150] = 768;
        nArray3[151] = 768;
        nArray3[152] = 768;
        nArray3[153] = 768;
        nArray3[154] = 768;
        nArray3[155] = 768;
        nArray3[156] = 768;
        nArray3[157] = 768;
        nArray3[158] = 768;
        nArray3[159] = 768;
        nArray3[160] = 1025;
        nArray3[161] = 1025;
        nArray3[162] = 1025;
        nArray3[163] = 1025;
        nArray3[164] = 1025;
        nArray3[165] = 1025;
        nArray3[166] = 1025;
        nArray3[167] = 1025;
        nArray3[168] = 1025;
        nArray3[169] = 1025;
        nArray3[170] = 1025;
        nArray3[171] = 1025;
        nArray3[172] = 1025;
        nArray3[173] = 1025;
        nArray3[174] = 1025;
        nArray3[175] = 1025;
        nArray3[176] = 1026;
        nArray3[177] = 1026;
        nArray3[178] = 1026;
        nArray3[179] = 1026;
        nArray3[180] = 1026;
        nArray3[181] = 1026;
        nArray3[182] = 1026;
        nArray3[183] = 1026;
        nArray3[184] = 1026;
        nArray3[185] = 1026;
        nArray3[186] = 1026;
        nArray3[187] = 1026;
        nArray3[188] = 1026;
        nArray3[189] = 1026;
        nArray3[190] = 1026;
        nArray3[191] = 1026;
        nArray3[192] = 1027;
        nArray3[193] = 1027;
        nArray3[194] = 1027;
        nArray3[195] = 1027;
        nArray3[196] = 1027;
        nArray3[197] = 1027;
        nArray3[198] = 1027;
        nArray3[199] = 1027;
        nArray3[200] = 1027;
        nArray3[201] = 1027;
        nArray3[202] = 1027;
        nArray3[203] = 1027;
        nArray3[204] = 1027;
        nArray3[205] = 1027;
        nArray3[206] = 1027;
        nArray3[207] = 1027;
        nArray3[208] = 1028;
        nArray3[209] = 1028;
        nArray3[210] = 1028;
        nArray3[211] = 1028;
        nArray3[212] = 1028;
        nArray3[213] = 1028;
        nArray3[214] = 1028;
        nArray3[215] = 1028;
        nArray3[216] = 1028;
        nArray3[217] = 1028;
        nArray3[218] = 1028;
        nArray3[219] = 1028;
        nArray3[220] = 1028;
        nArray3[221] = 1028;
        nArray3[222] = 1028;
        nArray3[223] = 1028;
        nArray3[224] = 1029;
        nArray3[225] = 1029;
        nArray3[226] = 1029;
        nArray3[227] = 1029;
        nArray3[228] = 1029;
        nArray3[229] = 1029;
        nArray3[230] = 1029;
        nArray3[231] = 1029;
        nArray3[232] = 1029;
        nArray3[233] = 1029;
        nArray3[234] = 1029;
        nArray3[235] = 1029;
        nArray3[236] = 1029;
        nArray3[237] = 1029;
        nArray3[238] = 1029;
        nArray3[239] = 1029;
        nArray3[240] = 1030;
        nArray3[241] = 1030;
        nArray3[242] = 1030;
        nArray3[243] = 1030;
        nArray3[244] = 1030;
        nArray3[245] = 1030;
        nArray3[246] = 1030;
        nArray3[247] = 1030;
        nArray3[248] = 1030;
        nArray3[249] = 1030;
        nArray3[250] = 1030;
        nArray3[251] = 1030;
        nArray3[252] = 1030;
        nArray3[253] = 1030;
        nArray3[254] = 1030;
        nArray3[255] = 1030;
        ZETA_3 = nArray3;
    }
}

