/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.query.Marker;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MarkingMutableString
extends MutableString {
    public static final int DEFAULT_INTERVAL_SURROUND = 8;
    private static final char[] htmlEscapeChar = new char[]{'<', '&'};
    private static final String[] htmlEscapeString = new String[]{"&lt;", "&amp;"};
    public static final EscapeStrategy NULL_ESCAPE = new NullEscape();
    public static final EscapeStrategy HTML_ESCAPE = new HtmlEscape();
    public boolean resume;
    public boolean marking;
    private Interval[] interval;
    private int count;
    private int currMarkingInterval;
    private int currResumeInterval;
    private boolean skipping;
    private boolean oneCharOut;
    private final int intervalSurround;
    private final Marker marker;
    private final EscapeStrategy escapeStrategy;
    private final TermProcessor termProcessor;

    public MarkingMutableString startField(Interval[] interval) {
        if (interval == null) {
            throw new IllegalArgumentException();
        }
        this.count = -1;
        this.currMarkingInterval = 0;
        this.currResumeInterval = 0;
        this.marking = false;
        this.oneCharOut = false;
        this.skipping = false;
        this.interval = interval;
        this.append(this.marker.startOfField());
        return this;
    }

    public MarkingMutableString endField() {
        this.append(this.marker.endOfField());
        return this;
    }

    public MarkingMutableString appendAndMark(WordReader wordReader) {
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        try {
            while (wordReader.next(word, nonWord)) {
                if (word.length() != 0) {
                    ++this.count;
                }
                if (this.resume) {
                    while (this.currResumeInterval < this.interval.length && this.interval[this.currResumeInterval].compareTo(this.count, 8) > 0) {
                        ++this.currResumeInterval;
                    }
                    if (this.currResumeInterval == this.interval.length || !this.interval[this.currResumeInterval].contains(this.count, 8)) {
                        if (!this.skipping && this.oneCharOut) {
                            this.append(this.marker.endOfBlock());
                        }
                        if (this.resume && this.currResumeInterval == this.interval.length) {
                            return this;
                        }
                        this.skipping = true;
                        continue;
                    }
                    if (this.skipping) {
                        this.append(this.marker.startOfBlock());
                    }
                    this.skipping = false;
                }
                if (word.length() != 0) {
                    if (!this.marking && this.currMarkingInterval < this.interval.length && this.interval[this.currMarkingInterval].contains(this.count)) {
                        this.append(this.marker.startOfMark());
                        this.marking = true;
                    }
                    this.append(word);
                    if (this.marking && (this.currMarkingInterval == this.interval.length || !this.interval[this.currMarkingInterval].contains(this.count + 1))) {
                        this.append(this.marker.endOfMark());
                        this.marking = false;
                    }
                    this.oneCharOut = true;
                    if (this.currMarkingInterval < this.interval.length && this.interval[this.currMarkingInterval].compareTo(this.count + 1) > 0) {
                        ++this.currMarkingInterval;
                    }
                }
                if (nonWord.length() <= 0) continue;
                this.oneCharOut = true;
                this.append(this.escapeStrategy.escape(nonWord.squeezeSpace()));
            }
            if (this.marking) {
                this.append(this.marker.endOfMark());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private final /* synthetic */ void this() {
        this.resume = true;
    }

    public MarkingMutableString(Marker marker, EscapeStrategy escapeStrategy, TermProcessor termProcessor, int intervalSurround) {
        this.this();
        this.marker = marker;
        this.termProcessor = termProcessor;
        this.escapeStrategy = escapeStrategy;
        this.intervalSurround = intervalSurround;
    }

    public MarkingMutableString(Marker marker, EscapeStrategy escapeStrategy, TermProcessor termProcessor) {
        this(marker, escapeStrategy, termProcessor, 8);
    }

    public MarkingMutableString(Marker marker, EscapeStrategy escapeStrategy) {
        this(marker, escapeStrategy, null);
    }

    public MarkingMutableString(Marker marker) {
        this(marker, NULL_ESCAPE);
    }

    public static interface EscapeStrategy {
        public MutableString escape(MutableString var1);
    }

    private static final class NullEscape
    implements EscapeStrategy {
        public final MutableString escape(MutableString s) {
            return s;
        }

        private NullEscape() {
        }
    }

    private static final class HtmlEscape
    implements EscapeStrategy {
        public final MutableString escape(MutableString s) {
            return s.replace(htmlEscapeChar, htmlEscapeString);
        }

        private HtmlEscape() {
        }
    }
}

