/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.query.HttpQueryServer;
import it.unimi.dsi.mg4j.query.IntervalSelector;
import it.unimi.dsi.mg4j.query.Marker;
import it.unimi.dsi.mg4j.query.MarkingMutableString;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.TextMarker;
import it.unimi.dsi.mg4j.query.parser.ParseException;
import it.unimi.dsi.mg4j.query.parser.QueryParser;
import it.unimi.dsi.mg4j.query.parser.TokenMgrError;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jline.ConsoleReader;
import jline.History;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Query {
    private static final Logger LOGGER;
    private static final NumberFormat formatter;
    private static final int TIME_MODE = 0;
    private static final int SHORT_MODE = 1;
    private static final int LONG_MODE = 2;
    private static final int SNIPPET_MODE = 3;
    private static final int TREC_MODE = 4;
    private int maxOutput;
    private int trecTopicNumber;
    private String trecRunTag;
    private final Object2IntOpenHashMap mode2Index;
    private int displayMode;
    private double leastScoreAssignedSoFar;
    private PrintStream output;
    private final QueryEngine queryEngine;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$query$Query;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$search$score$Scorer;
    static /* synthetic */ Class class$java$lang$String;

    public static void parseBasenameWeights(String[] basenameWeight, DocumentCollection documentCollection, Object2ObjectMap name2Index, Reference2DoubleMap index2Weight) throws IOException {
        int i = 0;
        while (i < basenameWeight.length) {
            Index index;
            int split;
            int pos = 0;
            pos = basenameWeight[i].indexOf("mg4j:");
            if (pos != -1) {
                int portpos = basenameWeight[i].indexOf(":", pos + 5);
                split = basenameWeight[i].indexOf(58, portpos + 1);
            } else {
                split = basenameWeight[i].indexOf(58);
            }
            if (split == -1) {
                System.out.println(basenameWeight[i]);
                index = Index.getInstance(basenameWeight[i]);
                index2Weight.put((Object)index, 1.0);
            } else {
                index = Index.getInstance(basenameWeight[i].substring(0, split));
                index2Weight.put((Object)index, Double.parseDouble(basenameWeight[i].substring(split + 1)));
            }
            if (documentCollection != null && index.numberOfDocuments != documentCollection.size()) {
                LOGGER.warn((Object)("Index " + index + " has " + index.numberOfDocuments + " documents, but the document collection has size " + documentCollection.size()));
            }
            name2Index.put((Object)(index.field != null ? index.field : basenameWeight[i]), (Object)index);
            ++i;
        }
    }

    public static double parseScorerClass(String spec, Scorer[] scorerArray, int index) {
        int endOfName;
        int pos = spec.indexOf(58);
        double weightSpec = 1.0;
        if (pos >= 0) {
            try {
                weightSpec = Double.parseDouble(spec.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Malformed weight " + spec.substring(0, pos));
            }
            spec = spec.substring(0, pos);
        }
        if ((endOfName = spec.indexOf(40)) < 0) {
            endOfName = spec.length();
        }
        Class<?> scorerClass = null;
        try {
            scorerClass = Class.forName("it.unimi.dsi.mg4j.search.score." + spec.substring(0, endOfName));
            Class clazz = class$it$unimi$dsi$mg4j$search$score$Scorer;
            if (clazz == null) {
                clazz = class$it$unimi$dsi$mg4j$search$score$Scorer = Query.class("[Lit.unimi.dsi.mg4j.search.score.Scorer;", false);
            }
            if (scorerClass.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown or improper scorer class it.unimi.dsi.mg4j.search.score." + spec.substring(0, endOfName));
        }
        Object[] args = new String[]{};
        if (endOfName < spec.length()) {
            if (spec.charAt(spec.length() - 1) != ')') {
                throw new IllegalArgumentException(") missing at the end of argument list");
            }
            args = spec.substring(endOfName + 1, spec.length() - 1).split(",");
        }
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < argTypes.length) {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = Query.class("[Ljava.lang.String;", false);
            }
            argTypes[i] = clazz;
            ++i;
        }
        try {
            Constructor<?> constr = scorerClass.getConstructor(argTypes);
            scorerArray[index] = (Scorer)constr.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No constructor with " + argTypes.length + " strings as argument for class " + scorerClass.getName() + ": " + e);
        }
        return weightSpec;
    }

    public boolean interpretCommand(String command) {
        String[] part = command.substring(1).split("[ \t\n\r]+");
        if (part[0].equals("mode")) {
            if (part.length >= 2 && this.mode2Index.containsKey((Object)part[1])) {
                int tempMode = this.mode2Index.getInt((Object)part[1]);
                if (tempMode != 4 && part.length > 2) {
                    System.err.println("Extra arguments.");
                } else if (tempMode == 4 && part.length != 4) {
                    System.err.println("Missing or extra arguments.");
                } else {
                    this.displayMode = this.mode2Index.getInt((Object)part[1]);
                    if (this.displayMode == 4) {
                        this.trecTopicNumber = Integer.parseInt(part[2]);
                        this.trecRunTag = part[3];
                    }
                }
            } else {
                System.err.println("Unknown or missing mode.");
            }
        } else if (part[0].equals("limit")) {
            int out = -1;
            if (part.length == 2) {
                try {
                    out = Integer.parseInt(part[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (out >= 0) {
                    int n = this.maxOutput = out == 0 ? Integer.MAX_VALUE : out;
                }
            }
            if (out < 0) {
                System.err.println("Missing or incorrect limit.");
            }
        } else if (part[0].equals("restrict")) {
            int restrict = -1;
            if (part.length == 2) {
                try {
                    restrict = Integer.parseInt(part[1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (restrict >= 0) {
                    this.queryEngine.restrict(restrict == 0 ? Integer.MAX_VALUE : restrict);
                }
            }
            if (restrict < 0) {
                System.err.println("Missing or incorrect restriction.");
            }
        } else if (part[0].equals("selector")) {
            int max = -1;
            int maxLength = -1;
            if (part.length == 1) {
                this.queryEngine.intervalSelector(null);
                System.err.println("Interval selection has been disabled.");
            } else {
                if (part.length == 3) {
                    try {
                        max = Integer.parseInt(part[1]);
                        maxLength = Integer.parseInt(part[2]);
                        this.queryEngine.intervalSelector(new IntervalSelector(max, maxLength));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (max < 0 || maxLength < 0) {
                    System.err.println("Missing or incorrect selector parameters.");
                }
            }
        } else if (part[0].equals("score")) {
            Scorer[] scorer = new Scorer[part.length - 1];
            double[] weight = new double[part.length - 1];
            int i = 1;
            while (i < part.length) {
                try {
                    weight[i - 1] = Query.parseScorerClass(part[i], scorer, i - 1);
                    if (weight[i - 1] < 0.0) {
                        throw new IllegalArgumentException("Weights should be non-negative");
                    }
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Error while parsing specification: " + e.getMessage());
                    break;
                }
                ++i;
            }
            if (i == part.length) {
                this.queryEngine.score(scorer, weight);
            }
        } else if (part[0].equals("mplex")) {
            if (part.length > 2 || part.length == 2 && !"on".equals(part[1]) && !"off".equals(part[1])) {
                System.err.println("Wrong argument(s) to command");
            } else if (part.length > 1) {
                this.queryEngine.multiplex("on".equals(part[1]));
            }
            System.err.println("Multiplex: " + this.queryEngine.multiplex());
        } else if (part[0].equals("divert")) {
            if (part.length > 2) {
                System.err.println("Wrong argument(s) to command");
            } else {
                if (this.output != System.out) {
                    this.output.close();
                }
                try {
                    this.output = part.length == 1 ? System.out : new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(part[1])));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot create file " + part[1]);
                    this.output = System.out;
                }
            }
        } else if (part[0].equals("countall")) {
            if (part.length > 2 || part.length == 2 && !"on".equals(part[1]) && !"off".equals(part[1])) {
                System.err.println("Wrong argument(s) to command");
            } else if (part.length > 1) {
                this.queryEngine.countAll("on".equals(part[1]));
            }
            System.err.println("Count all: " + this.queryEngine.countAll());
        } else if (part[0].equals("divert")) {
            if (part.length > 2) {
                System.err.println("Wrong argument(s) to command");
            } else {
                if (this.output != System.out) {
                    this.output.close();
                }
                try {
                    this.output = part.length == 1 ? System.out : new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(part[1])));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot create file " + part[1]);
                    this.output = System.out;
                }
            }
        } else if (part[0].equals("weight")) {
            Reference2DoubleOpenHashMap newIndex2Weight = new Reference2DoubleOpenHashMap();
            int i = 1;
            while (i < part.length) {
                int pos = part[i].indexOf(58);
                if (pos < 0) {
                    System.err.println("Missing colon: " + part[i]);
                    break;
                }
                if (!this.queryEngine.indexMap.containsKey(part[i].substring(0, pos))) {
                    System.err.println("Unknown index: " + part[i].substring(0, pos));
                    break;
                }
                try {
                    double newWeight = Double.parseDouble(part[i].substring(pos + 1));
                    newIndex2Weight.put(this.queryEngine.indexMap.get(part[i].substring(0, pos)), newWeight);
                }
                catch (NumberFormatException e) {
                    System.err.println("Wrong weight specification: " + part[i].substring(pos + 1));
                    break;
                }
                ++i;
            }
            if (i == part.length) {
                if (i > 1) {
                    this.queryEngine.weight((Reference2DoubleMap)newIndex2Weight);
                }
                Iterator it = this.queryEngine.indexMap.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    System.err.print("" + key + ':' + newIndex2Weight.getDouble(this.queryEngine.indexMap.get(key)) + ' ');
                }
                System.err.println();
            }
        } else if (part[0].equals("equalize")) {
            try {
                if (part.length != 2) {
                    throw new NumberFormatException("Illegal number of arguments");
                }
                this.queryEngine.equalize(Integer.parseInt(part[1]));
                System.err.println("Equalization sample set to " + this.queryEngine.equalize());
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
        } else {
            if (part[0].equals("quit")) {
                return false;
            }
            if (part[0].length() == 0) {
                System.err.println("$                                                               prints this help.");
                System.err.println("$mode [time|short|long|snippet|trec <topicNo> <runTag>]         chooses display mode.");
                System.err.println("$selector [<max> <maxLength>]                                   (de)installs an interval selector.");
                System.err.println("$limit <max>                                                    output at most <max> results per query.");
                System.err.println("$restrict <max>                                                 examine at most <max> results per query.");
                System.err.println("$divert [<filename>]                                            diverts output to <filename> or to stdout.");
                System.err.println("$weight {index:weight}                                          set index weights (unspecified weights are set to 1).");
                System.err.println("$mplex [<on>|<off>]                                             set/unset multiplex mode.");
                System.err.println("$countall [<on>|<off>]                                          set/unset global result counting.");
                System.err.println("$equalize <sample>                                              equalize scores using the given sample size.");
                System.err.println("$score {<scorerClass>(<arg>,...)[:<weight>]}                    order documents according to <scorerClass>.");
                System.err.println("$quit                                                           quits.");
            } else {
                System.err.println("Invalid command \"" + command + "\"; type $ for help.");
            }
        }
        return true;
    }

    public int output(ObjectArrayList results, DocumentCollection documentCollection, List titleList, Marker marker) throws IOException {
        int i;
        if (this.displayMode == 4) {
            i = 0;
            while (i < results.size()) {
                DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                this.output.println(this.trecTopicNumber + " Q0 " + titleList.get(dsi.document) + ' ' + i + ' ' + formatter.format(dsi.score) + ' ' + this.trecRunTag);
                ++i;
            }
        } else {
            i = 0;
            while (i < results.size()) {
                DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                Reference2ReferenceMap index2interval = (Reference2ReferenceMap)dsi.info;
                int document = dsi.document;
                this.output.print("Document #" + document);
                this.output.print(" [" + dsi.score + ']');
                if (documentCollection != null) {
                    this.output.println(" " + documentCollection.document(document).title().toString().trim());
                } else if (titleList != null) {
                    this.output.println(" " + titleList.get(document));
                } else {
                    this.output.println();
                }
                if (this.displayMode >= 2) {
                    Iterator keyIterator = this.queryEngine.indexMap.keySet().iterator();
                    while (keyIterator.hasNext()) {
                        Index index = (Index)this.queryEngine.indexMap.get(keyIterator.next());
                        if (!index2interval.containsKey((Object)index) || !index.hasPositions) continue;
                        Object[] interval = (Interval[])index2interval.get((Object)index);
                        if (this.displayMode == 2 || documentCollection == null) {
                            this.output.println(index + ": " + ObjectArrayList.wrap((Object[])interval));
                            continue;
                        }
                        MarkingMutableString s = new MarkingMutableString(marker);
                        s.startField((Interval[])interval);
                        Document d = documentCollection.document(document);
                        int fieldIndex = documentCollection.factory().fieldIndex(index.field);
                        Reader reader = (Reader)d.content(fieldIndex);
                        s.appendAndMark(d.wordReader(fieldIndex).setReader(reader));
                        s.endField();
                        this.output.println(index.field + ": " + s.toString());
                    }
                }
                ++i;
            }
        }
        return i;
    }

    public static void main(String[] arg) throws Exception {
        Class clazz = class$it$unimi$dsi$mg4j$query$Query;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$Query = Query.class("[Lit.unimi.dsi.mg4j.query.Query;", false);
        }
        SimpleJSAP jsap = new SimpleJSAP(clazz.getName(), "Loads indices relative to a collection, possibly loads the collection, and answers to queries.", new Parameter[]{new FlaggedOption("collection", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "collection", "The collection of documents indexed by the given indices."), new FlaggedOption("titleList", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "titleList", "A serialized list of titles (only if collection is not specified)."), new Switch("http", 'h', "http", "Starts an HTTP query server."), new FlaggedOption("itemClass", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'i', "item-class", "The class that will handle item display in the HTTP server."), new FlaggedOption("itemMimeType", (StringParser)JSAP.STRING_PARSER, "text/html", false, 'm', "item-mime-type", "A MIME type suggested to the class handling item display in the HTTP server."), new FlaggedOption("port", (StringParser)JSAP.INTEGER_PARSER, "4242", false, 'p', "port", "The port on localhost where the server will appear."), new UnflaggedOption("basenameWeight", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The indices that the servlet will use. Indices are specified using their basename, optionally followed by a colon and a double representing the weight used to score results from that index. Indices without a specified weight are weighted 1.")});
        final JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentCollection documentCollection = (DocumentCollection)(jsapResult.getString("collection") != null ? BinIO.loadObject((CharSequence)jsapResult.getString("collection")) : null);
        List titleList = (List)(jsapResult.getString("titleList") != null ? BinIO.loadObject((CharSequence)jsapResult.getString("titleList")) : null);
        String[] basenameWeight = jsapResult.getStringArray("basenameWeight");
        Object2ObjectLinkedOpenHashMap indexMap = new Object2ObjectLinkedOpenHashMap(16, 0.5f);
        Reference2DoubleOpenHashMap index2Weight = new Reference2DoubleOpenHashMap();
        Query.parseBasenameWeights(basenameWeight, documentCollection, (Object2ObjectMap)indexMap, (Reference2DoubleMap)index2Weight);
        final QueryEngine queryEngine = new QueryEngine(new QueryParser((Map)indexMap, (String)indexMap.firstKey(), documentCollection));
        queryEngine.weight((Reference2DoubleMap)index2Weight);
        queryEngine.countAll(true);
        Query query = new Query(queryEngine);
        System.err.println("Welcome to the MG4J query class.");
        System.err.println("Please type $ for help.");
        String prompt = indexMap.keySet().toString() + '>';
        if (jsapResult.getBoolean("http")) {
            Thread http = new Thread(){

                public final void run() {
                    try {
                        new HttpQueryServer(queryEngine, jsapResult.getClass("itemClass"), jsapResult.getString("itemMimeType"), jsapResult.getInt("port"));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            http.setDaemon(true);
            http.start();
        }
        ConsoleReader consoleReader = new ConsoleReader();
        String string = System.getProperty("user.home");
        StringBuffer stringBuffer = new StringBuffer(".jline-");
        Class clazz2 = class$it$unimi$dsi$mg4j$query$Query;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$query$Query = Query.class("[Lit.unimi.dsi.mg4j.query.Query;", false);
        }
        consoleReader.setHistory(new History(new File(string, stringBuffer.append(clazz2.getName()).append(".history").toString())));
        ObjectArrayList results = new ObjectArrayList();
        try {
            while (true) {
                int n;
                String q;
                if ((q = consoleReader.readLine(prompt)) == null) {
                    System.err.println();
                    break;
                }
                if (q.length() == 0) continue;
                if (q.charAt(0) == '$') {
                    if (query.interpretCommand(q)) continue;
                    break;
                }
                long time = -System.currentTimeMillis();
                try {
                    n = queryEngine.result(q, 0, query.maxOutput, (ObjectList)results);
                }
                catch (TokenMgrError e) {
                    System.err.println(e.getMessage());
                    continue;
                }
                catch (ParseException e) {
                    System.err.println(e.getMessage());
                    continue;
                }
                time += System.currentTimeMillis();
                query.output(results, documentCollection, titleList, TextMarker.TEXT_BOLDFACE);
                if (n == 0 && query.displayMode == 4) {
                    query.output.println(query.trecTopicNumber + " Q0 GX000-00-0000000 1 0 " + query.trecRunTag);
                }
                System.err.println(n + " documents; " + time + " ms; " + (double)n * 1000.0 / (double)time + " documents/s");
            }
        }
        catch (EOFException endOfInput) {
            // empty catch block
        }
        if (query.output != System.out) {
            query.output.close();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.maxOutput = 10;
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        this.mode2Index = new Object2IntOpenHashMap((Object[])new String[]{"time", "short", "long", "snippet", "trec"}, nArray);
        this.displayMode = 1;
        this.output = System.out;
    }

    public Query(QueryEngine queryEngine) {
        this.this();
        this.queryEngine = queryEngine;
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$query$Query;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$Query = Query.class("[Lit.unimi.dsi.mg4j.query.Query;", false);
        }
        LOGGER = Fast.getLogger(clazz);
        formatter = new DecimalFormat("#,##0.0000000000");
    }
}

