/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import cern.colt.list.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.mg4j.query.IntervalSelector;
import it.unimi.dsi.mg4j.query.parser.ParseException;
import it.unimi.dsi.mg4j.query.parser.QueryParser;
import it.unimi.dsi.mg4j.query.parser.TokenMgrError;
import it.unimi.dsi.mg4j.search.CachingDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterators;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.search.score.LinearCombinationScorer;
import it.unimi.dsi.mg4j.search.score.ScoredDocumentBoundedSizeQueue;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryEngine {
    private static final Logger LOGGER;
    public final QueryParser queryParser;
    public final Map indexMap;
    public final int numIndices;
    private int maxExamined;
    private boolean mplex;
    private int equalizeSample;
    private boolean countAll;
    private Scorer[] scorer;
    private double[] weight;
    private LinearCombinationScorer linearAggregator;
    private Reference2DoubleMap index2Weight;
    private IntervalSelector intervalSelector;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$query$QueryEngine;

    public void intervalSelector(IntervalSelector intervalSelector) {
        this.intervalSelector = intervalSelector;
    }

    public void restrict(int max) {
        this.maxExamined = max;
    }

    public int restrict() {
        return this.maxExamined;
    }

    public void countAll(boolean b) {
        this.countAll = b;
    }

    public boolean countAll() {
        return this.countAll;
    }

    public void weight(Reference2DoubleMap index2Weight) {
        this.index2Weight = index2Weight;
        if (this.linearAggregator != null) {
            this.linearAggregator.setWeights(index2Weight);
        }
    }

    public void multiplex(boolean b) {
        this.mplex = b;
    }

    public boolean multiplex() {
        return this.mplex;
    }

    public void equalize(int sample) {
        this.equalizeSample = sample;
        if (sample == 0) {
            this.linearAggregator.resetScaleFactor();
        }
    }

    public int equalize() {
        return this.equalizeSample;
    }

    public void score(Scorer[] scorer, double[] weight) {
        this.scorer = scorer;
        this.weight = weight;
        this.linearAggregator = new LinearCombinationScorer(scorer, weight);
        this.linearAggregator.setWeights(this.index2Weight);
    }

    public void noscore() {
        this.scorer = null;
        this.weight = null;
        this.linearAggregator = null;
    }

    private final String process(String query) {
        if (!this.mplex) {
            return query;
        }
        Iterator it = this.indexMap.keySet().iterator();
        MutableString ms = new MutableString();
        while (it.hasNext()) {
            ms.append(it.next() + ":(" + query + ')');
            if (!it.hasNext()) continue;
            ms.append(" OR ");
        }
        LOGGER.debug((Object)("Multiplex is active: submitting " + ms));
        return ms.toString();
    }

    public int scoredResult(String query, int offset, int length, ObjectList results) throws ParseException, TokenMgrError, IOException {
        LOGGER.debug((Object)("Processing (scored) query \"" + query + "\", offset=" + offset + ", length=" + length));
        if (this.linearAggregator == null) {
            throw new IllegalStateException();
        }
        results.clear();
        if (query.indexOf(44) == -1) {
            String q = this.process(query);
            if (this.equalizeSample > 0) {
                double[] scale = DocumentIterators.evalScoreMax(new CachingDocumentIterator(this.queryParser.parse(q)), this.scorer, this.equalizeSample);
                this.linearAggregator.setScaleFactor(scale);
                LOGGER.debug((Object)("Equalization factors for \"" + q + "\": " + new DoubleArrayList(scale)));
            }
            return this.scoredResult(this.queryParser.parse(q), offset, length, results, null);
        }
        String[] part = query.split(",");
        double lastMinScore = 1.0;
        int count = 0;
        IntOpenHashSet alreadySeen = new IntOpenHashSet();
        int i = 0;
        while (i < part.length) {
            String q = this.process(part[i]);
            int initialResultSize = results.size();
            if (this.equalizeSample > 0) {
                double[] scale = DocumentIterators.evalScoreMax(new CachingDocumentIterator(this.queryParser.parse(q)), this.scorer, this.equalizeSample);
                this.linearAggregator.setScaleFactor(scale);
                LOGGER.debug((Object)("Equalization factors for \"" + q + "\": " + new DoubleArrayList(scale)));
            }
            int total = this.scoredResult(this.queryParser.parse(q), offset, length - results.size(), results, (IntSet)alreadySeen);
            int j = results.size();
            while (j-- != initialResultSize) {
                ((DocumentScoreInfo)results.get((int)j)).score *= lastMinScore;
            }
            if (results.size() > 0) {
                lastMinScore = ((DocumentScoreInfo)results.get((int)(results.size() - 1))).score;
            }
            count += total;
            if ((offset -= total) < 0) {
                offset = 0;
            }
            if (results.size() == length && !this.countAll) break;
            ++i;
        }
        return count;
    }

    public int scoredResult(DocumentIterator documentIterator, int offset, int length, ObjectList results, IntSet alreadySeen) {
        if (this.linearAggregator == null) {
            throw new IllegalStateException();
        }
        CachingDocumentIterator cachingDocumentIterator = new CachingDocumentIterator(documentIterator);
        ScoredDocumentBoundedSizeQueue top = new ScoredDocumentBoundedSizeQueue(offset + length);
        int k = this.maxExamined;
        int count = 0;
        this.linearAggregator.reset();
        while (k-- != 0 && cachingDocumentIterator.hasNext()) {
            int document = cachingDocumentIterator.nextDocument();
            if (alreadySeen != null && !alreadySeen.add(document)) continue;
            ++count;
            if (length <= 0) continue;
            double score = this.linearAggregator.score(cachingDocumentIterator);
            if (this.intervalSelector != null) {
                top.enqueue(document, score, this.intervalSelector.select(cachingDocumentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(this.numIndices, 0.5f)));
                continue;
            }
            top.enqueue(document, score, IntervalSelector.selectAll(cachingDocumentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(this.numIndices, 0.5f)));
        }
        int n = Math.max(Math.min(top.size() - offset, length), 0);
        int s = results.size();
        results.size(s + n);
        int i = n;
        while (i-- != 0) {
            results.set(i + s, top.dequeue());
        }
        cachingDocumentIterator.dispose();
        return count;
    }

    public int nonscoredResult(String query, int offset, int length, ObjectList results) throws ParseException, TokenMgrError, IOException {
        LOGGER.debug((Object)("Processing (nonscored) query \"" + query + "\", offset=" + offset + ", length=" + length));
        results.clear();
        if (query.indexOf(44) == -1) {
            return this.nonscoredResult(this.queryParser.parse(this.process(query)), offset, length, results, null);
        }
        String[] part = query.split(",");
        int count = 0;
        IntOpenHashSet alreadySeen = new IntOpenHashSet();
        int i = 0;
        while (i < part.length) {
            int total = this.nonscoredResult(this.queryParser.parse(this.process(part[i])), offset, length - results.size(), results, (IntSet)alreadySeen);
            count += total;
            if ((offset -= total) < 0) {
                offset = 0;
            }
            if (results.size() == length && !this.countAll) break;
            ++i;
        }
        return count;
    }

    public int nonscoredResult(DocumentIterator documentIterator, int offset, int length, ObjectList results, IntSet alreadySeen) {
        int document;
        int count = 0;
        int i = offset;
        while (i-- != 0 && documentIterator.hasNext()) {
            document = documentIterator.nextDocument();
            if (alreadySeen != null && !alreadySeen.add(document)) continue;
            ++count;
        }
        int k = Math.max(Math.min(this.maxExamined - offset, length), 0);
        while (k-- != 0 && documentIterator.hasNext()) {
            document = documentIterator.nextDocument();
            if (alreadySeen != null && !alreadySeen.add(document)) continue;
            ++count;
            if (this.intervalSelector != null) {
                results.add((Object)new DocumentScoreInfo(document, -1.0, this.intervalSelector.select(documentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(this.numIndices, 0.5f))));
                continue;
            }
            results.add((Object)new DocumentScoreInfo(document, -1.0, IntervalSelector.selectAll(documentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(this.numIndices, 0.5f))));
        }
        if (this.countAll) {
            while (documentIterator.hasNext()) {
                document = documentIterator.nextDocument();
                if (alreadySeen != null && !alreadySeen.add(document)) continue;
                ++count;
            }
        }
        documentIterator.dispose();
        return count;
    }

    public Iterator nonscoredIterator(final DocumentIterator documentIterator) {
        return new AbstractObjectIterator(){
            private int k;

            public final boolean hasNext() {
                boolean bl = false;
                if (this.k != 0 && documentIterator.hasNext()) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                --this.k;
                if (QueryEngine.this.intervalSelector != null) {
                    return new DocumentScoreInfo(documentIterator.nextDocument(), -1.0, QueryEngine.this.intervalSelector.select(documentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(QueryEngine.this.numIndices, 0.5f)));
                }
                return new DocumentScoreInfo(documentIterator.nextDocument(), -1.0, IntervalSelector.selectAll(documentIterator, (Reference2ReferenceMap)new Reference2ReferenceOpenHashMap(QueryEngine.this.numIndices, 0.5f)));
            }

            private final /* synthetic */ void this() {
                this.k = QueryEngine.this.maxExamined;
            }
            {
                this.this();
            }
        };
    }

    public int result(String query, int offset, int length, ObjectList results) throws ParseException, TokenMgrError, IOException {
        if (this.linearAggregator != null) {
            return this.scoredResult(query, offset, length, results);
        }
        return this.nonscoredResult(query, offset, length, results);
    }

    public String toString() {
        return "QueryEngine: " + this.indexMap;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.maxExamined = Integer.MAX_VALUE;
        this.mplex = false;
        this.index2Weight = new Reference2DoubleOpenHashMap();
    }

    public QueryEngine(QueryParser queryParser) {
        this.this();
        this.queryParser = queryParser;
        this.indexMap = queryParser.indexMap;
        this.numIndices = queryParser.indexMap.size();
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$query$QueryEngine;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$query$QueryEngine = QueryEngine.class("[Lit.unimi.dsi.mg4j.query.QueryEngine;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

