/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.ints.AbstractIntSortedSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.mg4j.search.Intervals;
import java.io.Serializable;
import java.util.Comparator;

public final class Interval
extends AbstractIntSortedSet
implements IntSortedSet,
Serializable {
    private static final int MAX_SINGLE_POINT = 1024;
    private static final Interval[] POINT_INTERVAL = new Interval[1024];
    public final int left;
    public final int right;

    public static final Interval getInstance(int left, int right) {
        if (left > right) {
            throw new IllegalArgumentException("The left extreme (" + left + ") is greater than the right extreme (" + right + ')');
        }
        if (left == right) {
            return Interval.getInstance(left);
        }
        return new Interval(left, right);
    }

    public static final Interval getInstance(int point) {
        if (point >= 0 && point < 1024) {
            return POINT_INTERVAL[point];
        }
        return new Interval(point, point);
    }

    public final int length() {
        return this.right - this.left + 1;
    }

    public final int size() {
        return this.length();
    }

    public final IntIterator intIterator() {
        if (this == Intervals.EMPTY_INTERVAL) {
            return Iterators.EMPTY_ITERATOR;
        }
        return IntIterators.fromTo((int)this.left, (int)(this.right + 1));
    }

    public final boolean contains(int x) {
        boolean bl = false;
        if (x >= this.left && x <= this.right) {
            bl = true;
        }
        return bl;
    }

    public final boolean contains(int x, int radius) {
        boolean bl = false;
        if (x >= this.left - radius && x <= this.right + radius) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(int x) {
        if (x < this.left) {
            return -1;
        }
        if (x > this.right) {
            return 1;
        }
        return 0;
    }

    public final int compareTo(int x, int radius) {
        if (x < this.left - radius) {
            return -1;
        }
        if (x > this.right + radius) {
            return 1;
        }
        return 0;
    }

    public final Comparator comparator() {
        return null;
    }

    public final IntSortedSet headSet(int to) {
        if (to > this.left) {
            return to > this.right ? this : Interval.getInstance(this.left, to - 1);
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public final IntSortedSet tailSet(int from) {
        if (from <= this.right) {
            return from <= this.left ? this : Interval.getInstance(from, this.right);
        }
        return Intervals.EMPTY_INTERVAL;
    }

    public final IntSortedSet subSet(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ')');
        }
        if (to <= this.left || from > this.right || from == to) {
            return Intervals.EMPTY_INTERVAL;
        }
        if (from <= this.left && to > this.right) {
            return this;
        }
        return Interval.getInstance(Math.max(this.left, from), Math.min(this.right, to - 1));
    }

    public final int firstInt() {
        return this.left;
    }

    public final int lastInt() {
        return this.right;
    }

    public final String toString() {
        if (this == Intervals.EMPTY_INTERVAL) {
            return "[]";
        }
        return "[" + this.left + ',' + this.right + ']';
    }

    public final int hashCode() {
        return this.left ^ this.right;
    }

    public final boolean equals(Object o) {
        if (o instanceof Interval) {
            boolean bl = false;
            if (((Interval)o).left == this.left && ((Interval)o).right == this.right) {
                bl = true;
            }
            return bl;
        }
        if (o instanceof IntSortedSet) {
            IntSortedSet s = (IntSortedSet)o;
            if (s.size() != this.length()) {
                return false;
            }
            int n = this.length();
            IntIterator i = this.intIterator();
            IntIterator j = s.intIterator();
            while (n-- != 0) {
                if (i.nextInt() == j.nextInt()) continue;
                return false;
            }
            return true;
        }
        if (o instanceof IntSet) {
            IntSet s = (IntSet)o;
            if (s.size() != this.length()) {
                return false;
            }
            int n = this.length();
            IntIterator i = this.intIterator();
            while (n-- != 0) {
                if (s.contains(i.nextInt())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Interval(int left, int right) {
        this.left = left;
        this.right = right;
    }

    static {
        int i = 1024;
        while (i-- != 0) {
            Interval.POINT_INTERVAL[i] = new Interval(i, i);
        }
    }
}

