/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.mg4j.index.CachingOutputBitStream;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Combine;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Paste
extends Combine {
    private static final Logger LOGGER;
    private static final boolean ASSERTS = false;
    public static final String DEFAULT_TEMP_BUFFER_SIZE = "16Mi";
    protected int[] doc;
    protected IntHeapPriorityQueue documentQueue;
    private File tempFile;
    private CachingOutputBitStream cacheBitStreamOut;
    private InputBitStream cacheBitStreamIn;
    private InputBitStream cacheBitStreamInWrapper;
    private final int[] sizesSize;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$tool$Paste;

    protected final Index getIndex(CharSequence basename) {
        return Index.getInstance(basename, null, null, false, true);
    }

    protected final int combineNumberOfDocuments() {
        int n = 0;
        int i = 0;
        while (i < this.numIndices) {
            n = Math.max(n, this.index[i].numberOfDocuments);
            ++i;
        }
        return n;
    }

    protected final int combineSizes() throws IOException {
        int currDoc = 0;
        int maxDocSize = 0;
        int i = 0;
        while (i < this.numIndices) {
            LOGGER.debug((Object)("Reading sizes from " + this.inputBasename[i] + ".sizes"));
            InputBitStream sizes = new InputBitStream(this.inputBasename[i] + ".sizes");
            int s = 0;
            int j = this.index[i].numberOfDocuments;
            currDoc = 0;
            while (j-- != 0) {
                int n = currDoc++;
                this.size[n] = this.size[n] + sizes.readGamma();
                s = this.size[n];
                if (s <= maxDocSize) continue;
                maxDocSize = s;
            }
            sizes.close();
            ++i;
        }
        return maxDocSize;
    }

    protected final int combine(int numUsedIndices) throws IOException {
        InputBitStream ibs;
        int count;
        int currDoc;
        int currIndex;
        int prevDoc = -1;
        int k = numUsedIndices;
        while (k-- != 0) {
            currIndex = this.usedIndex[k];
            this.frequency[currIndex] = this.indexReader[currIndex].readFrequency();
            this.doc[currIndex] = this.indexReader[currIndex].readDocumentPointer();
            this.documentQueue.enqueue(currIndex);
        }
        this.cacheBitStreamOut.position(0L);
        int totalFrequency = 0;
        while (!this.documentQueue.isEmpty()) {
            int k2;
            currIndex = this.documentQueue.firstInt();
            currDoc = this.doc[currIndex];
            this.cacheBitStreamOut.writeDelta(currDoc - prevDoc - 1);
            ++totalFrequency;
            int totalCount = 0;
            int increment = 0;
            int prevIndex = 0;
            while (true) {
                if (prevIndex < currIndex) {
                    if (this.sizesSize[prevIndex] > currDoc) {
                        increment += this.index[prevIndex].sizes.getInt(currDoc);
                    }
                    ++prevIndex;
                    continue;
                }
                Index i = this.index[currIndex];
                IndexReader ir = this.indexReader[currIndex];
                if (i.hasCounts) {
                    count = ir.readPositionCount();
                    if (i.hasPositions) {
                        ir.readDocumentPositions(this.position, totalCount);
                        if (increment != 0) {
                            k2 = count;
                            while (k2-- != 0) {
                                int n = totalCount + k2;
                                this.position[n] = this.position[n] + increment;
                            }
                        }
                    }
                    totalCount += count;
                }
                int n = currIndex;
                this.frequency[n] = this.frequency[n] - 1;
                if (this.frequency[n] == 0) {
                    this.documentQueue.dequeue();
                } else {
                    this.doc[currIndex] = ir.readDocumentPointer();
                    this.documentQueue.changed();
                }
                if (this.documentQueue.isEmpty() || this.doc[currIndex = this.documentQueue.firstInt()] != currDoc) break;
            }
            if (totalCount > this.maxCount) {
                this.maxCount = totalCount;
            }
            if (this.indexWriter.hasCounts) {
                this.cacheBitStreamOut.writeGamma(totalCount);
                if (this.indexWriter.hasPositions) {
                    this.cacheBitStreamOut.writeDelta(this.position[0]);
                    k2 = 1;
                    while (k2 < totalCount) {
                        this.cacheBitStreamOut.writeDelta(this.position[k2] - this.position[k2 - 1] - 1);
                        ++k2;
                    }
                }
            }
            prevDoc = currDoc;
        }
        this.indexWriter.newInvertedList();
        this.indexWriter.writeFrequency(totalFrequency);
        this.cacheBitStreamOut.align();
        if (this.cacheBitStreamOut.buffer() != null) {
            ibs = this.cacheBitStreamInWrapper;
        } else {
            this.cacheBitStreamOut.flush();
            ibs = this.cacheBitStreamIn;
            ibs.flush();
        }
        ibs.position(0L);
        currDoc = -1;
        int j = totalFrequency;
        while (j-- != 0) {
            OutputBitStream obs = this.indexWriter.newDocumentRecord();
            currDoc = ibs.readDelta() + currDoc + 1;
            this.indexWriter.writeDocumentPointer(obs, currDoc);
            count = ibs.readGamma();
            if (!this.indexWriter.hasCounts) continue;
            this.indexWriter.writePositionCount(obs, count);
            if (!this.indexWriter.hasPositions) continue;
            this.position[0] = ibs.readDelta();
            int k3 = 1;
            while (k3 < count) {
                this.position[k3] = this.position[k3 - 1] + ibs.readDelta() + 1;
                ++k3;
            }
            this.indexWriter.writeDocumentPositions(obs, this.position, 0, count, this.size != null ? this.size[currDoc] : -1);
        }
        return totalFrequency;
    }

    public final void run() throws ConfigurationException, IOException {
        super.run();
        this.cacheBitStreamOut.close();
        this.tempFile.delete();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Paste(String outputBasename, String[] inputBasename, int bufferSize, File tempFileDir, int tempBufferSize, long writerFlags, CharSequence writerFlagsString, boolean skips, int quantum, int height, long logInterval) throws IOException, ConfigurationException {
        super(outputBasename, inputBasename, bufferSize, writerFlags, writerFlagsString, skips, quantum, height, logInterval);
        this.tempFile = File.createTempFile("MG4J", ".data", tempFileDir);
        this.cacheBitStreamOut = new CachingOutputBitStream(this.tempFile, tempBufferSize);
        this.cacheBitStreamIn = new InputBitStream(this.tempFile, bufferSize);
        this.cacheBitStreamInWrapper = new InputBitStream(this.cacheBitStreamOut.buffer());
        int estimatedForMaxCount = 0;
        this.sizesSize = new int[this.numIndices];
        int i = 0;
        while (i < this.numIndices) {
            this.sizesSize[i] = this.index[i].sizes.size();
            estimatedForMaxCount += this.index[i].maxCount;
            ++i;
        }
        this.position = new int[estimatedForMaxCount];
        this.doc = new int[this.numIndices];
        this.documentQueue = new IntHeapPriorityQueue(this.numIndices, (IntComparator)new DocumentIndexComparator(this.doc));
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Paste;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Paste = Paste.class("[Lit.unimi.dsi.mg4j.tool.Paste;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }

    private static final class DocumentIndexComparator
    extends AbstractIntComparator {
        private final int[] refArray;

        public final int compare(int i, int j) {
            int t = this.refArray[i] - this.refArray[j];
            return t != 0 ? t : i - j;
        }

        public DocumentIndexComparator(int[] refArray) {
            this.refArray = refArray;
        }
    }
}

