/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import cern.colt.Sorting;
import cern.colt.function.IntComparator;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.ZipDocumentCollectionBuilder;
import it.unimi.dsi.mg4j.index.DowncaseTermProcessor;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.tool.Index;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Scan {
    private static final Logger LOGGER;
    private static final boolean ASSERTS = true;
    private final TermProcessor termProcessor;
    private final String basenameField;
    private final int bufferSize;
    private final int occsPerBatch;
    private final File tempDir;
    private Object2IntOpenHashMap termMap;
    private long totOccurrences;
    private int totDocuments;
    private int globMaxDocSize;
    private int documentCount;
    private int numTerms;
    int maxDocSize;
    private int batch;
    private int numOccurrences;
    private final boolean documentsAreInOrder;
    private int occsInCurrDoc;
    private int newTermsInCurrDoc;
    protected int[] termIndex;
    protected int[] docIndex;
    protected int[] docPosition;
    private final IntComparator documentPositionComparator;
    private final ZipDocumentCollectionBuilder builder;
    private final boolean keepUnsorted;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$tool$Scan;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$NullTermProcessor;
    private static final /* synthetic */ boolean assert;

    /*
     * Unable to fully structure code
     */
    public static void countSortOnTerms(int[] key, int[] sorted, int len, int n, int[] perm) {
        block4: {
            count = new int[n];
            IntArrays.fill((int[])count, (int)0, (int)n, (int)0);
            i = len;
            while (i-- != 0) {
                v0 = key[i];
                count[v0] = count[v0] + 1;
            }
            i = 1;
            while (i < n) {
                v1 = i;
                count[v1] = count[v1] + count[i - 1];
                ++i;
            }
            i = len;
            if (perm != null) ** GOTO lbl27
            while (i-- != 0) {
                v2 = key[i];
                v3 = count[v2] - 1;
                count[v2] = v3;
                sorted[v3] = i;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                v4 = key[perm[i]];
                v5 = count[v4] - 1;
                count[v4] = v5;
                sorted[v5] = perm[i];
lbl27:
                // 2 sources

                ** while (i-- != 0)
            }
        }
    }

    protected void writeOccurrences() throws IOException, ConfigurationException {
        PrintWriter pw;
        MutableString s;
        int numTermsInBatch = this.numTerms - this.newTermsInCurrDoc;
        int numOccsInBatch = this.numOccurrences - this.occsInCurrDoc;
        LOGGER.debug((Object)("Generating index " + this.basenameField + '@' + this.batch + "; documents: " + this.documentCount + "; terms in batch: " + numTermsInBatch + "; terms seen:" + this.numTerms + "; occurrences per batch: " + this.numOccurrences + "; occurrences seen: " + numOccsInBatch));
        MutableString[] termArray = new MutableString[this.numTerms];
        int i = this.numTerms;
        Iterator t = this.termMap.keySet().iterator();
        while (i-- != 0) {
            s = (MutableString)t.next();
            if (!assert && termArray[this.termMap.getInt((Object)s)] != null) {
                throw new AssertionError();
            }
            termArray[this.termMap.getInt((Object)s)] = s;
        }
        this.termMap.clear();
        int w = 0;
        i = this.numOccurrences - this.occsInCurrDoc;
        while (i < this.numOccurrences) {
            s = termArray[this.termIndex[i]];
            int t2 = this.termMap.getInt((Object)s);
            if (t2 < 0) {
                t2 = w++;
                this.termMap.put((Object)s, t2);
            }
            this.termIndex[i] = t2;
            if (this.documentsAreInOrder) {
                this.docIndex[i] = 0;
            }
            ++i;
        }
        this.numTerms = this.newTermsInCurrDoc = w;
        if (!assert && this.numTerms != this.termMap.size()) {
            throw new AssertionError();
        }
        if (this.keepUnsorted) {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.basenameField + '@' + this.batch + ".terms.unsorted"), this.bufferSize), "UTF-8"));
            i = 0;
            while (i < numTermsInBatch) {
                pw.println(termArray[i]);
                ++i;
            }
            pw.close();
        }
        int[] perm = new int[numTermsInBatch];
        i = numTermsInBatch;
        while (i-- != 0) {
            perm[i] = i;
        }
        Sorting.quickSort((int[])perm, (int)0, (int)numTermsInBatch, (IntComparator)new PermutationComparator(termArray));
        pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.basenameField + '@' + this.batch + ".terms"), this.bufferSize), "UTF-8"));
        i = 0;
        while (i < numTermsInBatch) {
            pw.println(termArray[perm[i]]);
            ++i;
        }
        pw.close();
        termArray = null;
        int[] invPerm = new int[numTermsInBatch];
        i = numTermsInBatch;
        while (i-- != 0) {
            invPerm[perm[i]] = i;
        }
        perm = null;
        i = 0;
        while (i < numOccsInBatch) {
            this.termIndex[i] = invPerm[this.termIndex[i]];
            ++i;
        }
        invPerm = null;
        try {
            int curr;
            int[] sortedByDocument = null;
            if (!this.documentsAreInOrder) {
                sortedByDocument = new int[numOccsInBatch];
                i = numOccsInBatch;
                while (i-- != 0) {
                    sortedByDocument[i] = i;
                }
                Sorting.quickSort((int[])sortedByDocument, (int)0, (int)numOccsInBatch, (IntComparator)this.documentPositionComparator);
            }
            OutputBitStream sizes = new OutputBitStream(this.basenameField + '@' + this.batch + ".sizes");
            int document = 0;
            if (this.documentsAreInOrder) {
                i = 0;
                while (i < numOccsInBatch) {
                    curr = this.docIndex[i];
                    while (document < curr) {
                        sizes.writeGamma(0);
                        ++document;
                    }
                    while (i < numOccsInBatch && this.docIndex[i] == curr) {
                        ++i;
                    }
                    sizes.writeGamma(this.docPosition[i - 1] + 1);
                    ++document;
                }
                while (document < this.documentCount) {
                    sizes.writeGamma(0);
                    ++document;
                }
            } else {
                i = 0;
                while (i < numOccsInBatch) {
                    curr = this.docIndex[sortedByDocument[i]];
                    while (document++ < curr) {
                        sizes.writeGamma(0);
                    }
                    while (i < numOccsInBatch && this.docIndex[sortedByDocument[i]] == curr) {
                        ++i;
                    }
                    sizes.writeGamma(this.docPosition[sortedByDocument[i - 1]] + 1);
                }
            }
            sizes.close();
            File propertyFile = new File(this.basenameField + '@' + this.batch + ".properties");
            propertyFile.createNewFile();
            Properties properties = new Properties(propertyFile);
            properties.setProperty("documents", document);
            properties.setProperty("terms", numTermsInBatch);
            properties.setProperty("maxdocsize", this.maxDocSize);
            properties.setProperty("occurrences", numOccsInBatch);
            properties.setProperty("termprocessor", this.termProcessor.getClass().getName());
            int[] sortedByTerm = new int[numOccsInBatch];
            Scan.countSortOnTerms(this.termIndex, sortedByTerm, numOccsInBatch, numTermsInBatch, sortedByDocument);
            sortedByDocument = null;
            OutputBitStream frequencies = new OutputBitStream(this.basenameField + '@' + this.batch + ".frequencies");
            OutputBitStream globCounts = new OutputBitStream(this.basenameField + '@' + this.batch + ".globcounts");
            IndexWriter indexWriter = new IndexWriter(this.basenameField + '@' + this.batch, document, true, 0x1000000L);
            curr = 0;
            int[] pos = new int[1024];
            while (curr < numOccsInBatch) {
                int currTermIndex = this.termIndex[sortedByTerm[curr]];
                int last = curr + 1;
                int freq = 1;
                while (last < numOccsInBatch && this.termIndex[sortedByTerm[last]] == currTermIndex) {
                    if (this.docIndex[sortedByTerm[last - 1]] != this.docIndex[sortedByTerm[last]]) {
                        ++freq;
                    }
                    ++last;
                }
                frequencies.writeGamma(freq);
                globCounts.writeGamma(last - curr);
                indexWriter.newInvertedList();
                indexWriter.writeFrequency(freq);
                int next = curr;
                while (next < last) {
                    int currDocIndex = this.docIndex[sortedByTerm[curr]];
                    OutputBitStream obs = indexWriter.newDocumentRecord();
                    indexWriter.writeDocumentPointer(obs, currDocIndex);
                    while (next < last && this.docIndex[sortedByTerm[next]] == currDocIndex) {
                        pos = IntArrays.grow((int[])pos, (int)(next - curr + 1));
                        pos[next - curr] = this.docPosition[sortedByTerm[next]];
                        ++next;
                    }
                    indexWriter.writePositionCount(obs, next - curr);
                    indexWriter.writeDocumentPositions(obs, pos, 0, next - curr, -1);
                    curr = next;
                }
                if (!assert && curr != last) {
                    throw new AssertionError();
                }
            }
            properties.setProperty("size", indexWriter.writtenBits());
            properties.save();
            indexWriter.close();
            frequencies.close();
            globCounts.close();
            i = 0;
            while (i < this.occsInCurrDoc) {
                this.termIndex[i] = this.termIndex[i + numOccsInBatch];
                this.docIndex[i] = this.docIndex[i + numOccsInBatch];
                this.docPosition[i] = this.docPosition[i + numOccsInBatch];
                ++i;
            }
            this.numOccurrences = this.occsInCurrDoc;
            this.globMaxDocSize = Math.max(this.maxDocSize, this.globMaxDocSize);
            this.documentCount = 0;
            this.maxDocSize = 0;
            System.gc();
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("I/O Error on batch " + this.batch));
            throw e;
        }
    }

    public static void run(String basename, DocumentSequence documentSequence, TermProcessor termProcessor, String zipCollectionBasename, int bufferSize, int[] indexedField, int[] occsPerBatch, String renumberingFile, boolean keepUnsorted, long logInterval, String tempDirName) throws ConfigurationException, IOException {
        Document document;
        boolean zipping;
        int numDocuments = 0;
        int numberOfIndexedFields = indexedField.length;
        if (numberOfIndexedFields == 0) {
            throw new IllegalArgumentException("You must specify at least one field");
        }
        DocumentFactory factory = documentSequence.factory();
        File tempDir = tempDirName == null ? new File(basename).getParentFile() : new File(tempDirName);
        int[] permutation = renumberingFile != null ? BinIO.loadInts((CharSequence)renumberingFile) : null;
        String basenameField = basename + '-' + factory.fieldName(indexedField[0]);
        Scan[] scan = new Scan[numberOfIndexedFields];
        ProgressLogger pl = new ProgressLogger(LOGGER, logInterval, "documents");
        if (documentSequence instanceof DocumentCollection) {
            pl.expectedUpdates = ((DocumentCollection)documentSequence).size();
        }
        boolean bl = false;
        if (zipCollectionBasename != null) {
            bl = true;
        }
        ZipDocumentCollectionBuilder builder = (zipping = bl) ? new ZipDocumentCollectionBuilder(zipCollectionBasename + ".zip", documentSequence.factory(), true, pl) : null;
        int i = 0;
        while (i < numberOfIndexedFields) {
            basenameField = basename + '-' + factory.fieldName(indexedField[i]);
            boolean bl2 = false;
            if (permutation == null) {
                bl2 = true;
            }
            scan[i] = new Scan(basenameField, termProcessor, bl2, bufferSize, occsPerBatch[i], keepUnsorted, builder, tempDir);
            ++i;
        }
        pl.start("Indexing documents...");
        DocumentIterator iterator = documentSequence.iterator();
        int documentPointer = 0;
        while ((document = iterator.nextDocument()) != null) {
            if (zipping) {
                builder.startDocument(document.title(), document.uri());
            }
            int i2 = 0;
            while (i2 < numberOfIndexedFields) {
                Reader reader = (Reader)document.content(indexedField[i2]);
                WordReader wordReader = document.wordReader(indexedField[i2]);
                wordReader.setReader(reader);
                if (zipping) {
                    builder.startTextField();
                }
                scan[i2].processDocument(permutation != null ? permutation[documentPointer] : documentPointer, 0, wordReader);
                if (zipping) {
                    builder.endTextField();
                }
                ++i2;
            }
            if (zipping) {
                builder.endDocument();
            }
            ++documentPointer;
            document.close();
            pl.update();
        }
        iterator.close();
        if (builder != null) {
            BinIO.storeObject((Object)builder.close(), (CharSequence)(zipCollectionBasename + ".collection"));
        }
        Properties additionalProperties = new Properties();
        int i3 = 0;
        while (i3 < numberOfIndexedFields) {
            additionalProperties.setProperty("field", factory.fieldName(indexedField[i3]));
            scan[i3].close(additionalProperties);
            ++i3;
        }
        pl.done();
        if (numDocuments > 0 && documentPointer != numDocuments) {
            LOGGER.error((Object)("The document sequence contains " + documentPointer + " documents, but the ZerothPass property file claims that there are " + numDocuments + " documents"));
        }
        if (permutation != null && documentPointer != permutation.length) {
            LOGGER.error((Object)("The document sequence contains " + documentPointer + " documents, but the permutation contains " + permutation.length + " integers"));
        }
    }

    public void processDocument(int documentPointer, int firstPosition, WordReader wordReader) throws ConfigurationException, IOException {
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        int pos = firstPosition;
        this.newTermsInCurrDoc = 0;
        this.occsInCurrDoc = 0;
        while (wordReader.next(word, nonWord)) {
            int term;
            if (this.builder != null) {
                this.builder.add(word, nonWord);
            }
            if (word.length() == 0 || !this.termProcessor.processTerm(word)) continue;
            if (this.numOccurrences == this.occsPerBatch) {
                if (this.documentCount == 0) {
                    throw new IllegalStateException("There is a document with more occurrences than the maximum size of a batch (" + this.occsPerBatch + ')');
                }
                this.writeOccurrences();
                ++this.batch;
            }
            if ((term = this.termMap.getInt((Object)word)) == -1) {
                term = this.numTerms++;
                this.termMap.put((Object)word.copy(), term);
                ++this.newTermsInCurrDoc;
                if (this.numTerms % 1000000 == 0) {
                    LOGGER.info((Object)("[" + Fast.format(this.numTerms) + " term(s), " + Fast.format(this.totOccurrences) + " occ(s)]"));
                }
            }
            ++this.occsInCurrDoc;
            this.termIndex[this.numOccurrences] = term;
            this.docIndex[this.numOccurrences] = this.documentsAreInOrder ? this.documentCount : documentPointer;
            this.docPosition[this.numOccurrences] = pos++;
            ++this.numOccurrences;
            ++this.totOccurrences;
        }
        if (pos > this.maxDocSize) {
            this.maxDocSize = pos;
        }
        pos = 0;
        ++this.documentCount;
        ++this.totDocuments;
    }

    public void close(Properties additionalProperties) throws ConfigurationException, IOException {
        if (this.numOccurrences > 0) {
            this.occsInCurrDoc = 0;
            this.newTermsInCurrDoc = 0;
            this.writeOccurrences();
            ++this.batch;
        }
        this.docPosition = null;
        this.docIndex = null;
        this.termIndex = null;
        this.termMap = null;
        Properties properties = new Properties();
        if (additionalProperties != null) {
            properties.addAll((Configuration)additionalProperties);
        }
        properties.setProperty("batches", this.batch);
        properties.setProperty("documents", this.totDocuments);
        properties.setProperty("maxdocsize", this.globMaxDocSize);
        properties.setProperty("occurrences", this.totOccurrences);
        properties.save(this.basenameField + ".properties");
    }

    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, ConfigurationException, IllegalArgumentException, SecurityException, ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        Class clazz = class$it$unimi$dsi$mg4j$tool$Scan;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Scan = Scan.class("[Lit.unimi.dsi.mg4j.tool.Scan;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[15];
        parameterArray[0] = new FlaggedOption("sequence", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'S', "sequence", "A serialised document sequence that will be used instead of stdin.");
        Class clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory = Scan.class("[Lit.unimi.dsi.mg4j.document.IdentityDocumentFactory;", false);
        }
        parameterArray[1] = new FlaggedOption("factory", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'f', "factory", "A document factory with a standard constructor.");
        parameterArray[2] = new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true);
        Class clazz3 = class$it$unimi$dsi$mg4j$index$NullTermProcessor;
        if (clazz3 == null) {
            clazz3 = class$it$unimi$dsi$mg4j$index$NullTermProcessor = Scan.class("[Lit.unimi.dsi.mg4j.index.NullTermProcessor;", false);
        }
        parameterArray[3] = new FlaggedOption("termProcessor", (StringParser)JSAP.CLASS_PARSER, clazz3.getName(), false, 't', "term-processor", "Sets the term processor to the given class.");
        parameterArray[4] = new Switch("downcase", '\u0000', "downcase", "A shortcut for setting the term processor to the downcasing processor.");
        parameterArray[5] = new FlaggedOption("indexedField", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'I', "indexed-field", "The field(s) of the document factory that will be indexed. (default: all fields)").setAllowMultipleDeclarations(true);
        parameterArray[6] = new FlaggedOption("zipCollection", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'z', "zip", "Creates a support ZipDocumentCollection with given basename.");
        parameterArray[7] = new FlaggedOption("batchSize", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 's', "batch-size", "The size of a batch. It can be specified several times in the form [<field>:]<size>. If the field is omitted, it sets the batch size for all fields. (default: 2Mi)").setAllowMultipleDeclarations(true);
        parameterArray[8] = new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, "1Mi", false, 'b', "buffer-size", "The size of an I/O buffer.");
        parameterArray[9] = new FlaggedOption("delimiter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(10), false, 'd', "delimiter", "The document delimiter.");
        parameterArray[10] = new FlaggedOption("renumber", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "renumber", "The filename of a document renumbering.");
        parameterArray[11] = new Switch("keepUnsorted", 'u', "keep-unsorted", "Keep the unsorted term file.");
        parameterArray[12] = new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds.");
        parameterArray[13] = new FlaggedOption("tempDir", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for all temporary files (e.g., batches).");
        parameterArray[14] = new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Builds a set of batches from a sequence of documents.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentSequence documentSequence = Index.getSequence(jsapResult.getString("sequence"), jsapResult.getClass("factory"), jsapResult.getStringArray("property"), jsapResult.getInt("delimiter"));
        Class termProcessorClass = jsapResult.getClass("termProcessor");
        DocumentFactory factory = documentSequence.factory();
        int[] indexedField = Index.parseFieldNames(jsapResult.getStringArray("indexedField"), factory);
        int[] occsPerBatch = Index.parseQualifiedSizes(jsapResult.getStringArray("batchSize"), "2Mi", indexedField, factory);
        Fast.ensureLog4JIsConfigured();
        Scan.run(jsapResult.getString("basename"), documentSequence, jsapResult.getBoolean("downcase") ? DowncaseTermProcessor.getInstance() : (TermProcessor)termProcessorClass.getMethod("getInstance", null).invoke((Object)termProcessorClass, null), jsapResult.getString("zipCollection"), jsapResult.getInt("bufferSize"), indexedField, occsPerBatch, jsapResult.getString("renumber"), jsapResult.getBoolean("keepUnsorted"), jsapResult.getLong("logInterval"), jsapResult.getString("tempDir"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Scan(String basenameField, TermProcessor termProcessor, boolean documentsAreInOrder, int bufferSize, int occsPerBatch, boolean keepUnsorted, ZipDocumentCollectionBuilder builder, File tempDir) {
        this.basenameField = basenameField;
        this.documentsAreInOrder = documentsAreInOrder;
        this.termProcessor = termProcessor;
        this.bufferSize = bufferSize;
        this.occsPerBatch = occsPerBatch;
        this.keepUnsorted = keepUnsorted;
        this.builder = builder;
        this.tempDir = tempDir;
        this.termMap = new Object2IntOpenHashMap();
        this.termMap.defaultReturnValue(-1);
        this.termIndex = new int[occsPerBatch];
        this.docIndex = new int[occsPerBatch];
        this.docPosition = new int[occsPerBatch];
        this.documentPositionComparator = new DocumentPositionComparator(this.docIndex, this.docPosition);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.tool.Scan;").getComponentType().desiredAssertionStatus() ^ true;
        Class clazz = class$it$unimi$dsi$mg4j$tool$Scan;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$tool$Scan = Scan.class("[Lit.unimi.dsi.mg4j.tool.Scan;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }

    private static final class PermutationComparator
    implements IntComparator {
        private final MutableString[] term;

        public final int compare(int x, int y) {
            return this.term[x].compareTo(this.term[y]);
        }

        private PermutationComparator(MutableString[] term) {
            this.term = term;
        }
    }

    private static final class DocumentPositionComparator
    implements IntComparator {
        private final int[] docIndex;
        private final int[] docPosition;

        public final int compare(int x, int y) {
            int t = this.docIndex[x] - this.docIndex[y];
            if (t != 0) {
                return t;
            }
            return this.docPosition[x] - this.docPosition[y];
        }

        public DocumentPositionComparator(int[] docIndex, int[] docPosition) {
            this.docIndex = docIndex;
            this.docPosition = docPosition;
        }
    }
}

