/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LogEntry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class SyncedLogManager
extends LogManager {
    public SyncedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LogManager.LogResult logItem(LogEntryHeader header, LogEntry item, boolean isProvisional, boolean flushRequired, boolean forceNewLogFile, long oldNodeLsn, int oldNodeSize, boolean marshallOutsideLatch, ByteBuffer marshalledBuffer, UtilizationTracker tracker, boolean shouldReplicate) throws IOException, DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.logInternal(header, item, isProvisional, flushRequired, forceNewLogFile, oldNodeLsn, oldNodeSize, marshallOutsideLatch, marshalledBuffer, tracker, shouldReplicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInternal() throws LogException, DatabaseException {
        try {
            Latch latch = this.logWriteLatch;
            synchronized (latch) {
                this.logBufferPool.writeBufferToFile(0);
            }
        }
        catch (IOException e) {
            throw new LogException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.getUnflushableTrackedSummaryInternal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackedFile(TrackedFileSummary tfs) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.removeTrackedFileInternal(tfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNode(long lsn, LogEntryType type, int size) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteNodeInternal(tracker, lsn, type, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNodes(TrackedFileSummary[] summaries) throws DatabaseException {
        UtilizationTracker tracker = this.envImpl.getUtilizationTracker();
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteNodesInternal(tracker, summaries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteINs(List lsnList) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteINsInternal(lsnList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEndOfLogStat(EnvironmentStats stats) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.loadEndOfLogStatInternal(stats);
        }
    }
}

