/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.WriteLockInfo;
import java.nio.ByteBuffer;

public class LN
extends Node
implements Loggable {
    private static final String BEGIN_TAG = "<ln>";
    private static final String END_TAG = "</ln>";
    private byte[] data;
    private static final int DIRTY_BIT = Integer.MIN_VALUE;
    private static final int CLEAR_DIRTY_BIT = Integer.MAX_VALUE;
    private static final int LAST_LOGGED_SIZE_MASK = Integer.MAX_VALUE;
    private static final int CLEAR_LAST_LOGGED_SIZE = Integer.MIN_VALUE;
    private int state;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LN() {
        super(false);
        this.data = null;
    }

    public LN(byte[] data) {
        super(true);
        if (data == null) {
            this.data = null;
        } else {
            this.init(data, 0, data.length);
        }
        this.setDirty();
    }

    public LN(DatabaseEntry dbt) {
        super(true);
        byte[] data = dbt.getData();
        if (data == null) {
            this.data = null;
        } else if (dbt.getPartial()) {
            this.init(data, dbt.getOffset(), dbt.getPartialOffset() + dbt.getSize(), dbt.getPartialOffset(), dbt.getSize());
        } else {
            this.init(data, dbt.getOffset(), dbt.getSize());
        }
        this.setDirty();
    }

    private void init(byte[] data, int off, int len, int doff, int dlen) {
        if (len == 0) {
            this.data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        } else {
            this.data = new byte[len];
            System.arraycopy(data, off, this.data, doff, dlen);
        }
    }

    private void init(byte[] data, int off, int len) {
        this.init(data, off, len, 0, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] copyData() {
        int len = this.data.length;
        byte[] ret = new byte[len];
        System.arraycopy(this.data, 0, ret, 0, len);
        return ret;
    }

    public boolean isDeleted() {
        return this.data == null;
    }

    void makeDeleted() {
        this.data = null;
    }

    public boolean isDirty() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    void setDirty() {
        this.state |= Integer.MIN_VALUE;
    }

    private void clearDirty() {
        this.state &= Integer.MAX_VALUE;
    }

    boolean isValidForDelete() {
        return false;
    }

    boolean isEvictableInexact() {
        return true;
    }

    boolean isEvictable() throws DatabaseException {
        return true;
    }

    protected boolean isSoughtNode(long nid, boolean updateGeneration) {
        return false;
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return false;
    }

    boolean canMemorySizeChangeDuringLogging() {
        return false;
    }

    public long delete(DatabaseImpl database, byte[] lnKey, byte[] dupKey, long oldLsn, Locker locker) throws DatabaseException {
        int oldSize = this.getLastLoggedSize();
        this.makeDeleted();
        this.setDirty();
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = -1L;
        if (dupKey != null) {
            if (database.isDeferredWrite() && oldLsn == -1L) {
                this.clearDirty();
            } else {
                newLsn = this.log(env, database.getId(), lnKey, dupKey, oldLsn, oldSize, locker, false, false);
            }
        } else {
            newLsn = this.optionalLog(env, database, lnKey, oldLsn, oldSize, locker);
        }
        return newLsn;
    }

    public long modify(byte[] newData, DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker) throws DatabaseException {
        int oldSize = this.getLastLoggedSize();
        this.data = newData;
        this.setDirty();
        EnvironmentImpl env = database.getDbEnvironment();
        long newLsn = this.optionalLog(env, database, lnKey, oldLsn, oldSize, locker);
        return newLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long logUpdateMemUsage(DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker, IN parent, boolean backgroundIO) throws DatabaseException {
        EnvironmentImpl env = database.getDbEnvironment();
        int oldLogSize = this.getLastLoggedSize();
        long oldMemSize = 0L;
        boolean possibleMemSizeChange = this.canMemorySizeChangeDuringLogging();
        if (possibleMemSizeChange) {
            oldMemSize = this.getMemorySizeIncludedByParent();
        }
        try {
            long l = this.log(env, database.getId(), lnKey, null, oldLsn, oldLogSize, locker, backgroundIO, false);
            return l;
        }
        finally {
            long newMemSize;
            if (possibleMemSizeChange && (newMemSize = this.getMemorySizeIncludedByParent()) != oldMemSize) {
                parent.updateMemorySize(oldMemSize, newMemSize);
            }
        }
    }

    public long logUpdateMemUsage(DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker, IN parent) throws DatabaseException {
        return this.logUpdateMemUsage(database, lnKey, oldLsn, locker, parent, false);
    }

    public long optionalLogUpdateMemUsage(DatabaseImpl database, byte[] lnKey, long oldLsn, Locker locker, IN parent) throws DatabaseException {
        if (database.isDeferredWrite()) {
            return -1L;
        }
        return this.logUpdateMemUsage(database, lnKey, oldLsn, locker, parent);
    }

    void rebuildINList(INList inList) {
    }

    void accountForSubtreeRemoval(INList inList, UtilizationTracker tracker) {
    }

    public long getMemorySizeIncludedByParent() {
        int size = MemoryBudget.LN_OVERHEAD;
        if (this.data != null) {
            size += MemoryBudget.byteArraySize(this.data.length);
        }
        return size;
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer self = new StringBuffer();
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.beginTag());
            self.append('\n');
        }
        self.append(super.dumpString(nSpaces + 2, true));
        self.append('\n');
        if (this.data != null) {
            self.append(TreeUtils.indent(nSpaces + 2));
            self.append("<data>");
            self.append(TreeUtils.dumpByteArray(this.data));
            self.append("</data>");
            self.append('\n');
        }
        if (dumpTags) {
            self.append(TreeUtils.indent(nSpaces));
            self.append(this.endTag());
        }
        return self.toString();
    }

    public long optionalLog(EnvironmentImpl env, DatabaseImpl databaseImpl, byte[] key, long oldLsn, int oldSize, Locker locker) throws DatabaseException {
        if (databaseImpl.isDeferredWrite()) {
            return -1L;
        }
        return this.log(env, databaseImpl.getId(), key, null, oldLsn, oldSize, locker, false, false);
    }

    public long optionalLogProvisional(EnvironmentImpl env, DatabaseImpl databaseImpl, byte[] key, long oldLsn, int oldSize) throws DatabaseException {
        if (databaseImpl.isDeferredWrite()) {
            return -1L;
        }
        return this.log(env, databaseImpl.getId(), key, null, oldLsn, oldSize, null, false, true);
    }

    public long log(EnvironmentImpl env, DatabaseId dbId, byte[] key, byte[] delDupKey, long oldLsn, int oldSize, Locker locker, boolean backgroundIO, boolean isProvisional) throws DatabaseException {
        Txn logTxn;
        boolean logAbortKnownDeleted;
        long logAbortLsn;
        LogEntryType entryType;
        boolean isDelDup;
        boolean bl = isDelDup = delDupKey != null;
        if (locker != null && locker.isTransactional()) {
            entryType = isDelDup ? LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL : this.getTransactionalLogType();
            WriteLockInfo info = locker.getWriteLockInfo(this.getNodeId());
            logAbortLsn = info.getAbortLsn();
            logAbortKnownDeleted = info.getAbortKnownDeleted();
            logTxn = locker.getTxnLocker();
            if (!$assertionsDisabled && logTxn == null) {
                throw new AssertionError();
            }
            if (oldLsn == logAbortLsn) {
                info.setAbortLogSize(oldSize);
            }
        } else {
            entryType = isDelDup ? LogEntryType.LOG_DEL_DUPLN : this.getLogType();
            logAbortLsn = -1L;
            logAbortKnownDeleted = false;
            logTxn = null;
        }
        if (oldLsn == logAbortLsn) {
            oldLsn = -1L;
        }
        LNLogEntry logEntry = isDelDup ? new DeletedDupLNLogEntry(entryType, this, dbId, delDupKey, key, logAbortLsn, logAbortKnownDeleted, logTxn) : new LNLogEntry(entryType, this, dbId, key, logAbortLsn, logAbortKnownDeleted, logTxn);
        LogManager logManager = env.getLogManager();
        long lsn = logManager.log(logEntry, isProvisional, backgroundIO, oldLsn, oldSize);
        this.clearDirty();
        return lsn;
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_LN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_LN;
    }

    public int getLastLoggedSize() {
        return this.state & Integer.MAX_VALUE;
    }

    public void setLastLoggedSize(int size) {
        this.state = this.state & Integer.MIN_VALUE | size;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        size += LogUtils.getBooleanLogSize();
        if (!this.isDeleted()) {
            size += LogUtils.getByteArrayLogSize(this.data);
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        boolean dataExists = !this.isDeleted();
        LogUtils.writeBoolean(logBuffer, dataExists);
        if (dataExists) {
            LogUtils.writeByteArray(logBuffer, this.data);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        boolean dataExists = LogUtils.readBoolean(itemBuffer);
        if (dataExists) {
            this.data = LogUtils.readByteArray(itemBuffer);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        if (this.data != null) {
            sb.append("<data>");
            sb.append(TreeUtils.dumpByteArray(this.data));
            sb.append("</data>");
        }
        this.dumpLogAdditional(sb, verbose);
        sb.append(this.endTag());
    }

    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
    }

    static {
        $assertionsDisabled = !LN.class.desiredAssertionStatus();
    }
}

