/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchStats;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LockManager
implements EnvConfigObserver {
    static final long TOTAL_LOCK_OVERHEAD;
    private static final long REMOVE_TOTAL_LOCK_OVERHEAD;
    protected int nLockTables = 1;
    protected Latch[] lockTableLatches;
    private Map[] lockTables;
    private EnvironmentImpl envImpl;
    private MemoryBudget memoryBudget;
    private long nRequests;
    private long nWaits;
    private static RangeRestartException rangeRestartException;
    private static boolean lockTableDump;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LockManager(EnvironmentImpl envImpl) throws DatabaseException {
        DbConfigManager configMgr = envImpl.getConfigManager();
        this.nLockTables = configMgr.getInt(EnvironmentParams.N_LOCK_TABLES);
        this.lockTables = new Map[this.nLockTables];
        this.lockTableLatches = new Latch[this.nLockTables];
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTables[i] = new HashMap();
            this.lockTableLatches[i] = LatchSupport.makeLatch("Lock Table " + i, envImpl);
        }
        this.envImpl = envImpl;
        this.memoryBudget = envImpl.getMemoryBudget();
        this.nRequests = 0L;
        this.nWaits = 0L;
        this.envConfigUpdate(configMgr);
        envImpl.addConfigObserver(this);
    }

    public void envConfigUpdate(DbConfigManager configMgr) throws DatabaseException {
        LockInfo.setDeadlockStackTrace(configMgr.getBoolean(EnvironmentParams.TXN_DEADLOCK_STACK_TRACE));
        LockManager.setLockTableDump(configMgr.getBoolean(EnvironmentParams.TXN_DUMPLOCKS));
    }

    static void setLockTableDump(boolean enable) {
        lockTableDump = enable;
    }

    protected int getLockTableIndex(Long nodeId) {
        return ((int)nodeId.longValue() & Integer.MAX_VALUE) % this.nLockTables;
    }

    protected int getLockTableIndex(long nodeId) {
        return ((int)nodeId & Integer.MAX_VALUE) % this.nLockTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType lock(long nodeId, Locker locker, LockType type, long timeout, boolean nonBlockingRequest, DatabaseImpl database) throws DeadlockException, DatabaseException {
        if (!$assertionsDisabled && timeout < 0L) {
            throw new AssertionError();
        }
        Locker locker2 = locker;
        synchronized (locker2) {
            Long nid = new Long(nodeId);
            LockAttemptResult result = this.attemptLock(nid, locker, type, nonBlockingRequest);
            if (result.success || result.lockGrant == LockGrantType.DENIED) {
                return result.lockGrant;
            }
            if (!$assertionsDisabled && !this.checkNoLatchesHeld(nonBlockingRequest)) {
                throw new AssertionError((Object)(LatchSupport.countLatchesHeld() + " latches held while trying to lock, lock table =" + LatchSupport.latchesHeldToString()));
            }
            if (!$assertionsDisabled && nonBlockingRequest) {
                throw new AssertionError();
            }
            try {
                long startTime;
                boolean doWait = true;
                if (locker.isTimedOut()) {
                    if (this.validateOwnership(nid, locker, type, true, this.memoryBudget)) {
                        doWait = false;
                    } else {
                        DeadlockException DE = this.makeTimeoutMsg("Transaction", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), System.currentTimeMillis(), database);
                        throw DE;
                    }
                }
                boolean keepTime = timeout > 0L;
                long l = startTime = keepTime ? System.currentTimeMillis() : 0L;
                while (doWait) {
                    locker.setWaitingFor(result.useLock);
                    try {
                        locker.wait(timeout);
                    }
                    catch (InterruptedException IE) {
                        throw new RunRecoveryException(this.envImpl, (Throwable)IE);
                    }
                    boolean lockerTimedOut = locker.isTimedOut();
                    long now = System.currentTimeMillis();
                    boolean thisLockTimedOut = keepTime && now - startTime > timeout;
                    boolean isRestart = result.lockGrant == LockGrantType.WAIT_RESTART;
                    if (this.validateOwnership(nid, locker, type, lockerTimedOut || thisLockTimedOut || isRestart, this.memoryBudget)) {
                        break;
                    }
                    if (isRestart) {
                        throw rangeRestartException;
                    }
                    if (thisLockTimedOut) {
                        locker.setOnlyAbortable();
                        DeadlockException DE = this.makeTimeoutMsg("Lock", locker, nodeId, type, result.lockGrant, result.useLock, timeout, startTime, now, database);
                        throw DE;
                    }
                    if (!lockerTimedOut) continue;
                    locker.setOnlyAbortable();
                    DeadlockException DE = this.makeTimeoutMsg("Transaction", locker, nodeId, type, result.lockGrant, result.useLock, locker.getTxnTimeOut(), locker.getTxnStartMillis(), now, database);
                    throw DE;
                }
            }
            finally {
                locker.setWaitingFor(null);
                if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                    throw new AssertionError();
                }
            }
            locker.addLock(nid, type, result.lockGrant);
            return result.lockGrant;
        }
    }

    protected abstract Lock lookupLock(Long var1) throws DatabaseException;

    protected Lock lookupLockInternal(Long nodeId, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(nodeId);
        return useLock;
    }

    protected abstract LockAttemptResult attemptLock(Long var1, Locker var2, LockType var3, boolean var4) throws DatabaseException;

    protected LockAttemptResult attemptLockInternal(Long nodeId, Locker locker, LockType type, boolean nonBlockingRequest, int lockTableIndex) throws DatabaseException {
        ++this.nRequests;
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(nodeId);
        if (useLock == null) {
            useLock = new Lock();
            lockTable.put(nodeId, useLock);
            this.memoryBudget.updateLockMemoryUsage(TOTAL_LOCK_OVERHEAD, lockTableIndex);
        }
        LockGrantType lockGrant = useLock.lock(type, locker, nonBlockingRequest, this.memoryBudget, lockTableIndex);
        boolean success = false;
        if (lockGrant == LockGrantType.NEW || lockGrant == LockGrantType.PROMOTION) {
            locker.addLock(nodeId, type, lockGrant);
            success = true;
        } else if (lockGrant == LockGrantType.EXISTING) {
            success = true;
        } else if (lockGrant != LockGrantType.DENIED) {
            ++this.nWaits;
        }
        return new LockAttemptResult(useLock, lockGrant, success);
    }

    protected abstract DeadlockException makeTimeoutMsg(String var1, Locker var2, long var3, LockType var5, LockGrantType var6, Lock var7, long var8, long var10, long var12, DatabaseImpl var14) throws DatabaseException;

    protected DeadlockException makeTimeoutMsgInternal(String lockOrTxn, Locker locker, long nodeId, LockType type, LockGrantType grantType, Lock useLock, long timeout, long start, long now, DatabaseImpl database) {
        if (lockTableDump) {
            System.out.println("++++++++++ begin lock table dump ++++++++++");
            for (int i = 0; i < this.nLockTables; ++i) {
                StringBuffer sb = new StringBuffer();
                this.dumpToStringNoLatch(sb, i);
                System.out.println(sb.toString());
            }
            System.out.println("++++++++++ end lock table dump ++++++++++");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(lockOrTxn);
        sb.append(" expired. Locker ").append(locker);
        sb.append(": waited for lock");
        if (database != null) {
            sb.append(" on database=").append(database.getDebugName());
        }
        sb.append(" node=").append(nodeId);
        sb.append(" type=").append(type);
        sb.append(" grant=").append(grantType);
        sb.append(" timeoutMillis=").append(timeout);
        sb.append(" startTime=").append(start);
        sb.append(" endTime=").append(now);
        Set owners = useLock.getOwnersClone();
        List waiters = useLock.getWaitersListClone();
        sb.append("\nOwners: ").append(owners);
        sb.append("\nWaiters: ").append(waiters).append("\n");
        StringBuffer deadlockInfo = this.findDeadlock(useLock, locker);
        if (deadlockInfo != null) {
            sb.append(deadlockInfo);
        }
        DeadlockException ret = new DeadlockException(sb.toString());
        ret.setOwnerTxnIds(this.getTxnIds(owners));
        ret.setWaiterTxnIds(this.getTxnIds(waiters));
        return ret;
    }

    private long[] getTxnIds(Collection c) {
        long[] ret = new long[c.size()];
        Iterator iter = c.iterator();
        int i = 0;
        while (iter.hasNext()) {
            LockInfo info = (LockInfo)iter.next();
            ret[i++] = info.getLocker().getId();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean release(long nodeId, Locker locker) throws DatabaseException {
        Locker locker2 = locker;
        synchronized (locker2) {
            Set newOwners = this.releaseAndFindNotifyTargets(nodeId, locker);
            if (newOwners == null) {
                return false;
            }
            if (newOwners.size() > 0) {
                Iterator iter = newOwners.iterator();
                while (iter.hasNext()) {
                    Locker lockerToNotify;
                    Locker locker3 = lockerToNotify = (Locker)iter.next();
                    synchronized (locker3) {
                        lockerToNotify.notifyAll();
                    }
                    if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                        throw new AssertionError();
                    }
                }
            }
            return true;
        }
    }

    protected abstract Set releaseAndFindNotifyTargets(long var1, Locker var3) throws DatabaseException;

    protected Set releaseAndFindNotifyTargetsInternal(long nodeId, Locker locker, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(new Long(nodeId));
        if (useLock == null) {
            return null;
        }
        Set lockersToNotify = useLock.release(locker, this.memoryBudget, lockTableIndex);
        if (lockersToNotify == null) {
            return null;
        }
        if (useLock.nWaiters() == 0 && useLock.nOwners() == 0) {
            this.lockTables[lockTableIndex].remove(new Long(nodeId));
            this.memoryBudget.updateLockMemoryUsage(REMOVE_TOTAL_LOCK_OVERHEAD, lockTableIndex);
        }
        return lockersToNotify;
    }

    abstract void transfer(long var1, Locker var3, Locker var4, boolean var5) throws DatabaseException;

    protected void transferInternal(long nodeId, Locker owningLocker, Locker destLocker, boolean demoteToRead, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        if (demoteToRead) {
            useLock.demote(owningLocker);
        }
        useLock.transfer(new Long(nodeId), owningLocker, destLocker, this.memoryBudget, lockTableIndex);
        owningLocker.removeLock(nodeId);
    }

    abstract void transferMultiple(long var1, Locker var3, Locker[] var4) throws DatabaseException;

    protected void transferMultipleInternal(long nodeId, Locker owningLocker, Locker[] destLockers, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(new Long(nodeId));
        if (!$assertionsDisabled && useLock == null) {
            throw new AssertionError((Object)("Transfer, lock " + nodeId + " was null"));
        }
        useLock.demote(owningLocker);
        useLock.transferMultiple(new Long(nodeId), owningLocker, destLockers, this.memoryBudget, lockTableIndex);
        owningLocker.removeLock(nodeId);
    }

    abstract void demote(long var1, Locker var3) throws DatabaseException;

    protected void demoteInternal(long nodeId, Locker locker, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock useLock = (Lock)lockTable.get(new Long(nodeId));
        useLock.demote(locker);
        locker.moveWriteToReadLock(nodeId, useLock);
    }

    abstract boolean isLocked(Long var1) throws DatabaseException;

    protected boolean isLockedInternal(Long nodeId, int lockTableIndex) {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock entry = (Lock)lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.nOwners() != 0;
    }

    abstract boolean isOwner(Long var1, Locker var2, LockType var3) throws DatabaseException;

    protected boolean isOwnerInternal(Long nodeId, Locker locker, LockType type, int lockTableIndex) {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock entry = (Lock)lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isOwner(locker, type);
    }

    abstract boolean isWaiter(Long var1, Locker var2) throws DatabaseException;

    protected boolean isWaiterInternal(Long nodeId, Locker locker, int lockTableIndex) {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock entry = (Lock)lockTable.get(nodeId);
        if (entry == null) {
            return false;
        }
        return entry.isWaiter(locker);
    }

    abstract int nWaiters(Long var1) throws DatabaseException;

    protected int nWaitersInternal(Long nodeId, int lockTableIndex) {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock entry = (Lock)lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nWaiters();
    }

    abstract int nOwners(Long var1) throws DatabaseException;

    protected int nOwnersInternal(Long nodeId, int lockTableIndex) {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock entry = (Lock)lockTable.get(nodeId);
        if (entry == null) {
            return -1;
        }
        return entry.nOwners();
    }

    abstract Locker getWriteOwnerLocker(Long var1) throws DatabaseException;

    protected Locker getWriteOwnerLockerInternal(Long nodeId, int lockTableIndex) throws DatabaseException {
        Map lockTable = this.lockTables[lockTableIndex];
        Lock lock = (Lock)lockTable.get(nodeId);
        if (lock == null) {
            return null;
        }
        if (lock.nOwners() > 1) {
            return null;
        }
        return lock.getWriteOwnerLocker();
    }

    protected abstract boolean validateOwnership(Long var1, Locker var2, LockType var3, boolean var4, MemoryBudget var5) throws DatabaseException;

    protected boolean validateOwnershipInternal(Long nodeId, Locker locker, LockType type, boolean flushFromWaiters, MemoryBudget mb, int lockTableIndex) throws DatabaseException {
        Lock entry;
        if (this.isOwnerInternal(nodeId, locker, type, lockTableIndex)) {
            return true;
        }
        if (flushFromWaiters && (entry = (Lock)this.lockTables[lockTableIndex].get(nodeId)) != null) {
            entry.flushWaiter(locker, mb, lockTableIndex);
        }
        return false;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        LockStats stats = new LockStats();
        stats.setNRequests(this.nRequests);
        stats.setNWaits(this.nWaits);
        if (config.getClear()) {
            this.nWaits = 0L;
            this.nRequests = 0L;
        }
        for (int i = 0; i < this.nLockTables; ++i) {
            LatchStats latchStats = this.lockTableLatches[i].getLatchStats();
            stats.accumulateLockTableLatchStats(latchStats);
        }
        if (!config.getFast()) {
            this.dumpLockTable(stats);
        }
        return stats;
    }

    protected abstract void dumpLockTable(LockStats var1) throws DatabaseException;

    protected void dumpLockTableInternal(LockStats stats, int i) {
        Map lockTable = this.lockTables[i];
        stats.accumulateNTotalLocks(lockTable.size());
        Iterator iter = lockTable.values().iterator();
        while (iter.hasNext()) {
            Lock lock = (Lock)iter.next();
            stats.setNWaiters(stats.getNWaiters() + lock.nWaiters());
            stats.setNOwners(stats.getNOwners() + lock.nOwners());
            Iterator ownerIter = lock.getOwnersClone().iterator();
            while (ownerIter.hasNext()) {
                LockInfo info = (LockInfo)ownerIter.next();
                if (info.getLockType().isWriteLock()) {
                    stats.setNWriteLocks(stats.getNWriteLocks() + 1);
                    continue;
                }
                stats.setNReadLocks(stats.getNReadLocks() + 1);
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpToString() throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.nLockTables; ++i) {
            this.lockTableLatches[i].acquire();
            try {
                this.dumpToStringNoLatch(sb, i);
                continue;
            }
            finally {
                this.lockTableLatches[i].release();
            }
        }
        return sb.toString();
    }

    private void dumpToStringNoLatch(StringBuffer sb, int whichTable) {
        Map lockTable = this.lockTables[whichTable];
        Iterator entries = lockTable.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Long nid = (Long)entry.getKey();
            Lock lock = (Lock)entry.getValue();
            sb.append("---- Node Id: ").append(nid).append("----\n");
            sb.append(lock);
            sb.append('\n');
        }
    }

    private boolean checkNoLatchesHeld(boolean nonBlockingRequest) {
        if (nonBlockingRequest) {
            return true;
        }
        return LatchSupport.countLatchesHeld() == 0;
    }

    private StringBuffer findDeadlock(Lock lock, Locker rootLocker) {
        HashSet<Locker> ownerSet = new HashSet<Locker>();
        ownerSet.add(rootLocker);
        StringBuffer ret = this.findDeadlock1(ownerSet, lock, rootLocker);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private StringBuffer findDeadlock1(Set ownerSet, Lock lock, Locker rootLocker) {
        Iterator ownerIter = lock.getOwnersClone().iterator();
        while (ownerIter.hasNext()) {
            LockInfo info = (LockInfo)ownerIter.next();
            Locker locker = info.getLocker();
            Lock waitsFor = locker.getWaitingFor();
            if (ownerSet.contains(locker) || locker == rootLocker) {
                StringBuffer ret = new StringBuffer();
                ret.append("Transaction ").append(locker.toString());
                ret.append(" owns ").append(System.identityHashCode(lock));
                ret.append(" ").append(info).append("\n");
                ret.append("Transaction ").append(locker.toString());
                ret.append(" waits for ");
                if (waitsFor == null) {
                    ret.append(" nothing");
                } else {
                    ret.append(" node ");
                    ret.append(System.identityHashCode(waitsFor));
                }
                ret.append("\n");
                return ret;
            }
            if (waitsFor == null) continue;
            ownerSet.add(locker);
            StringBuffer sb = this.findDeadlock1(ownerSet, waitsFor, rootLocker);
            String overflowTag = "<Overflow>\n";
            if (sb != null) {
                String waitInfo = "Transaction " + locker + " waits for " + waitsFor + "\n";
                if (sb.length() < 100000) {
                    sb.insert(0, waitInfo);
                } else if (!sb.substring(0, overflowTag.length()).equals(overflowTag)) {
                    sb.insert(0, overflowTag);
                }
                return sb;
            }
            ownerSet.remove(locker);
        }
        return null;
    }

    static {
        $assertionsDisabled = !LockManager.class.desiredAssertionStatus();
        TOTAL_LOCK_OVERHEAD = MemoryBudget.LOCK_OVERHEAD + MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
        REMOVE_TOTAL_LOCK_OVERHEAD = 0L - TOTAL_LOCK_OVERHEAD;
        rangeRestartException = new RangeRestartException();
        lockTableDump = false;
    }

    static class LockAttemptResult {
        boolean success;
        Lock useLock;
        LockGrantType lockGrant;

        LockAttemptResult(Lock useLock, LockGrantType lockGrant, boolean success) {
            this.useLock = useLock;
            this.lockGrant = lockGrant;
            this.success = success;
        }
    }
}

