/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.Segment;
import java.io.IOException;
import java.io.Writer;

final class BlankOutputSegment
implements OutputSegment {
    private int begin;
    private int end;

    public BlankOutputSegment(int n, int n2) {
        this.begin = n;
        this.end = n2;
    }

    public BlankOutputSegment(Segment segment) {
        this(segment.getBegin(), segment.getEnd());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = this.begin; i < this.end; ++i) {
            writer.write(32);
        }
    }

    public long getEstimatedMaximumOutputLength() {
        return this.end - this.begin;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.end - this.begin);
        for (int i = this.begin; i < this.end; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getDebugInfo() {
        return "(" + this.begin + ',' + this.end + ')';
    }
}

