/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int n, int n2, EndTagType endTagType, String string) {
        super(source, n, n2, string);
        this.endTagType = endTagType;
    }

    public Element getElement() {
        StartTag startTag;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int n = this.begin;
        while (n != 0 && (startTag = this.source.findPreviousStartTag(n - 1)) != null) {
            Element element = startTag.getElement();
            if (element.getEndTag() == this) {
                return element;
            }
            n = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    public TagType getTagType() {
        return this.endTagType;
    }

    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.toString();
    }

    public static String generateHTML(String string) {
        return EndTagType.NORMAL.generateHTML(string);
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"/").append(this.name).append("\" ");
        if (this.endTagType != EndTagType.NORMAL) {
            stringBuffer.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    public String regenerateHTML() {
        return this.toString();
    }

    public static boolean isForbidden(String string) {
        return HTMLElements.getEndTagForbiddenElementNames().contains(string.toLowerCase());
    }

    public static boolean isOptional(String string) {
        return HTMLElements.getEndTagOptionalElementNames().contains(string.toLowerCase());
    }

    public static boolean isRequired(String string) {
        return HTMLElements.getEndTagRequiredElementNames().contains(string.toLowerCase());
    }

    static EndTag findPreviousOrNext(Source source, int n, String string, EndTagType endTagType, boolean bl) {
        if (string == null) {
            return (EndTag)Tag.findPreviousOrNextTag(source, n, endTagType, bl);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String string2 = endTagType.generateHTML(string);
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            while (true) {
                int n3 = n2 = bl ? parseText.lastIndexOf(string2, n2) : parseText.indexOf(string2, n2);
                if (n2 == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source.getTagAt(n2);
                if (endTag != null && endTag.getEndTagType() == endTagType) {
                    return endTag;
                }
                if (bl) {
                    if (--n2 >= 0) {
                        continue;
                    }
                    break;
                }
                if (++n2 >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static EndTag findPreviousOrNext(Source source, int n, boolean bl) {
        Tag tag;
        while ((tag = Tag.findPreviousOrNextTag(source, n, bl)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }
}

