/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import java.util.HashMap;

public final class FormControlType {
    private String formControlTypeId;
    private String elementName;
    private boolean hasPredefinedValue;
    private boolean submit;
    private static final HashMap ID_MAP = new HashMap(16, 1.0f);
    private static final HashMap INPUT_ELEMENT_TYPE_MAP = new HashMap(11, 1.0f);
    public static final FormControlType BUTTON = new FormControlType("button", "button", true, true).register();
    public static final FormControlType CHECKBOX = new FormControlType("checkbox", "input", true, false).register();
    public static final FormControlType FILE = new FormControlType("file", "input", false, false).register();
    public static final FormControlType HIDDEN = new FormControlType("hidden", "input", false, false).register();
    public static final FormControlType IMAGE = new FormControlType("image", "input", true, true).register();
    public static final FormControlType PASSWORD = new FormControlType("password", "input", false, false).register();
    public static final FormControlType RADIO = new FormControlType("radio", "input", true, false).register();
    public static final FormControlType SELECT_MULTIPLE = new FormControlType("select_multiple", "select", true, false).register();
    public static final FormControlType SELECT_SINGLE = new FormControlType("select_single", "select", true, false).register();
    public static final FormControlType SUBMIT = new FormControlType("submit", "input", true, true).register();
    public static final FormControlType TEXT = new FormControlType("text", "input", false, false).register();
    public static final FormControlType TEXTAREA = new FormControlType("textarea", "textarea", false, false).register();

    private FormControlType(String string, String string2, boolean bl, boolean bl2) {
        this.formControlTypeId = string;
        this.elementName = string2;
        this.hasPredefinedValue = bl;
        this.submit = bl2;
    }

    private FormControlType register() {
        ID_MAP.put(this.formControlTypeId, this);
        if (this.elementName == "input") {
            INPUT_ELEMENT_TYPE_MAP.put(this.formControlTypeId, this);
        }
        return this;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean hasPredefinedValue() {
        return this.hasPredefinedValue;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    public String getTagName() {
        return this.elementName;
    }

    public boolean isPredefinedValue() {
        return this.hasPredefinedValue;
    }

    public boolean allowsMultipleValues() {
        return this != RADIO && !this.isSubmit();
    }

    public String getFormControlTypeId() {
        return this.formControlTypeId;
    }

    public static FormControlType get(String string) {
        return (FormControlType)ID_MAP.get(string);
    }

    public String[] getAdditionalSubmitNames(String string) {
        if (this != IMAGE) {
            return null;
        }
        String[] stringArray = new String[]{string + ".x", string + ".y"};
        return stringArray;
    }

    public static boolean isPotentialControl(String string) {
        return string.equalsIgnoreCase("input") || string.equalsIgnoreCase("textarea") || string.equalsIgnoreCase("button") || string.equalsIgnoreCase("select");
    }

    public String toString() {
        return this.formControlTypeId;
    }

    static FormControlType getFromInputElementType(String string) {
        return (FormControlType)INPUT_ELEMENT_TYPE_MAP.get(string);
    }
}

