/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Segment
implements Comparable,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    List childElements = null;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int n, int n2) {
        if (n == -1 || n2 == -1 || n > n2) {
            throw new IllegalArgumentException();
        }
        this.begin = n;
        this.end = n2;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int n) {
        this.begin = 0;
        this.end = n;
        this.source = (Source)this;
    }

    Segment() {
        this.begin = 0;
        this.end = 0;
        this.source = null;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int n) {
        return this.begin <= n && n < this.end;
    }

    public String toString() {
        return this.source.string.substring(this.begin, this.end).toString();
    }

    public String extractText() {
        return this.extractText(false);
    }

    public String extractText(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.length());
        int n = this.begin;
        Object object = this.findAllTags().iterator();
        while (object.hasNext()) {
            Tag tag = (Tag)object.next();
            int n2 = tag.begin;
            if (n2 < n) continue;
            while (n < n2) {
                stringBuffer.append(this.source.charAt(n++));
            }
            if (tag.getTagType() == StartTagType.NORMAL) {
                Tag tag2;
                if ((tag.name == "script" || tag.name == "style") && (tag2 = this.source.findNextEndTag(tag.end, tag.name, EndTagType.NORMAL)) != null) {
                    n = ((EndTag)tag2).end;
                    while (object.hasNext() && object.next() != tag2) {
                    }
                    continue;
                }
                if (bl) {
                    Attribute attribute;
                    Attribute attribute2;
                    Attribute attribute3;
                    tag2 = (StartTag)tag;
                    Attribute attribute4 = ((StartTag)tag2).getAttributes().get("title");
                    if (attribute4 != null) {
                        stringBuffer.append(' ').append((Object)attribute4.getValueSegment()).append(' ');
                    }
                    if ((attribute3 = ((StartTag)tag2).getAttributes().get("alt")) != null) {
                        stringBuffer.append(' ').append((Object)attribute3.getValueSegment()).append(' ');
                    }
                    if ((attribute2 = ((StartTag)tag2).getAttributes().get("label")) != null) {
                        stringBuffer.append(' ').append((Object)attribute2.getValueSegment()).append(' ');
                    }
                    if ((attribute = ((StartTag)tag2).getAttributes().get("summary")) != null) {
                        stringBuffer.append(' ').append((Object)attribute.getValueSegment()).append(' ');
                    }
                }
            }
            if (tag.getName() == "br" || !HTMLElements.getInlineLevelElementNames().contains(tag.getName())) {
                stringBuffer.append('\n');
            }
            n = tag.end;
        }
        while (n < this.end) {
            stringBuffer.append(this.source.charAt(n++));
        }
        object = CharacterReference.decodeCollapseWhiteSpace(stringBuffer);
        return object;
    }

    public List findAllTags() {
        return this.findAllTags(null);
    }

    public List findAllTags(TagType tagType) {
        Tag tag = this.checkEnclosure(Tag.findPreviousOrNextTag(this.source, this.begin, tagType, false));
        if (tag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        do {
            arrayList.add(tag);
        } while ((tag = this.checkEnclosure(Tag.findPreviousOrNextTag(this.source, tag.begin + 1, tagType, false))) != null);
        return arrayList;
    }

    public List findAllStartTags() {
        return this.findAllStartTags(null);
    }

    public List findAllStartTags(String string) {
        boolean bl;
        StartTag startTag;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((startTag = (StartTag)this.checkEnclosure(StartTag.findPreviousOrNext(this.source, this.begin, string, bl = Tag.isXMLName(string), false))) == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(StartTag.findPreviousOrNext(this.source, startTag.begin + 1, string, bl, false))) != null);
        return arrayList;
    }

    public List findAllStartTags(String string, String string2, boolean bl) {
        StartTag startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(this.begin, string, string2, bl));
        if (startTag == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(this.source.findNextStartTag(startTag.begin + 1, string, string2, bl))) != null);
        return arrayList;
    }

    public List getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag startTag;
                this.childElements = new ArrayList();
                int n = this.begin;
                while ((startTag = this.source.findNextStartTag(n)) != null && startTag.begin < this.end) {
                    if (startTag.getTagType().isServerTag()) {
                        n = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    this.childElements.add(element);
                    element.getChildElements();
                    n = element.end;
                }
            }
        }
        return this.childElements;
    }

    public List findAllElements() {
        return this.findAllElements((String)null);
    }

    public List findAllElements(String string) {
        List list;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((list = this.findAllStartTags(string)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StartTag startTag = (StartTag)iterator.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List findAllElements(StartTagType startTagType) {
        List list = this.findAllTags(startTagType);
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StartTag startTag = (StartTag)iterator.next();
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List findAllCharacterReferences() {
        CharacterReference characterReference = this.findNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CharacterReference> arrayList = new ArrayList<CharacterReference>();
        do {
            arrayList.add(characterReference);
        } while ((characterReference = this.findNextCharacterReference(characterReference.end)) != null);
        return arrayList;
    }

    public List findFormControls() {
        return FormControl.findAll(this);
    }

    public FormFields findFormFields() {
        return new FormFields(this.findFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Segment segment = (Segment)object;
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char c) {
        for (int i = 0; i < WHITESPACE.length; ++i) {
            if (c != WHITESPACE[i]) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(stringBuffer);
        stringBuffer.append('-');
        this.source.getRowColumnVector(this.end).appendTo(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final char charAt(int n) {
        return this.source.string.charAt(this.begin + n);
    }

    public final CharSequence subSequence(int n, int n2) {
        return this.source.string.subSequence(this.begin + n, this.begin + n2);
    }

    public boolean isComment() {
        return false;
    }

    public List findAllComments() {
        return this.findAllTags(StartTagType.COMMENT);
    }

    public String getSourceText() {
        return this.toString();
    }

    public final String getSourceTextNoWhitespace() {
        return Segment.appendCollapseWhiteSpace(new StringBuffer(this.length()), this).toString();
    }

    public final List findWords() {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n = -1;
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) {
                if (n == -1) continue;
                arrayList.add(new Segment(this.source, n, i));
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            arrayList.add(new Segment(this.source, n, this.end));
        }
        return arrayList;
    }

    static final StringBuffer appendCollapseWhiteSpace(StringBuffer stringBuffer, CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        boolean bl = false;
        while (true) {
            if (n2 >= n) {
                return stringBuffer;
            }
            if (!Segment.isWhiteSpace(charSequence.charAt(n2))) break;
            ++n2;
        }
        do {
            char c;
            if (Segment.isWhiteSpace(c = charSequence.charAt(n2++))) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(' ');
                bl = false;
            }
            stringBuffer.append(c);
        } while (n2 < n);
        return stringBuffer;
    }

    private Tag checkEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference findNextCharacterReference(int n) {
        CharacterReference characterReference = this.source.findNextCharacterReference(n);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

