/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.HTMLElementTerminatingTagNameSets;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.MasonTagTypes;
import au.id.jericho.lib.html.PHPTagTypes;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;

    StartTag(Source source, int n, int n2, StartTagType startTagType, String string, Attributes attributes) {
        super(source, n, n2, string);
        this.attributes = attributes;
        this.startTagType = startTagType;
    }

    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.findEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.isLoggingEnabled()) {
                    this.source.log(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuffer(200).append("End tag ").append((Object)endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        return this.attributes == null ? null : this.attributes.getValue(string);
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - this.startTagType.getClosingDelimiter().length();
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, n3, n2, this.startTagType, this.name, n);
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isEmptyElementTag();
    }

    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean bl) {
        if (this.attributes == null) {
            return this.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        if (bl && this.startTagType == StartTagType.NORMAL) {
            stringBuffer.append(this.name);
        } else {
            int n;
            int n2 = n + this.name.length();
            for (n = this.begin + this.startTagType.startDelimiterPrefix.length(); n < n2; ++n) {
                stringBuffer.append(this.source.charAt(n));
            }
        }
        this.attributes.appendTidy(stringBuffer, this.findNextTag());
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            stringBuffer.append(" /");
        }
        stringBuffer.append(this.startTagType.getClosingDelimiter());
        return stringBuffer.toString();
    }

    public static String generateHTML(String string, Map map, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        stringBuffer.append('<').append(string);
        try {
            Attributes.appendHTML(stringWriter, map);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            stringBuffer.append(" />");
        } else {
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendStartTagDebugInfo(stringBuffer);
        stringBuffer.append(super.getDebugInfo());
        return stringBuffer.toString();
    }

    StringBuffer appendStartTagDebugInfo(StringBuffer stringBuffer) {
        stringBuffer.append('\"').append(this.name).append("\" ");
        if (this.startTagType != StartTagType.NORMAL) {
            stringBuffer.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return stringBuffer;
    }

    public String regenerateHTML() {
        return this.tidy();
    }

    public boolean isEndTagOptional() {
        return this.getStartTagType() == StartTagType.NORMAL && HTMLElements.getEndTagOptionalElementNames().contains(this.name);
    }

    public EndTag findEndTag() {
        return this.getElement().getEndTag();
    }

    public FormControlType getFormControlType() {
        FormControl formControl = this.getFormControl();
        if (formControl == null) {
            return null;
        }
        return formControl.getFormControlType();
    }

    public Segment getFollowingTextSegment() {
        int n = this.source.getParseText().indexOf('<', this.end);
        if (n == -1) {
            n = this.source.end;
        }
        return new Segment(this.source, this.end, n);
    }

    public boolean isServerTag() {
        return this.getTagType().isServerTag();
    }

    public boolean isComment() {
        return this.startTagType == StartTagType.COMMENT;
    }

    public boolean isProcessingInstruction() {
        return this.charAt(1) == '?';
    }

    public boolean isXMLDeclaration() {
        return this.startTagType == StartTagType.XML_DECLARATION;
    }

    public boolean isDocTypeDeclaration() {
        return this.startTagType == StartTagType.DOCTYPE_DECLARATION;
    }

    public boolean isCommonServerTag() {
        return this.startTagType == StartTagType.SERVER_COMMON;
    }

    public boolean isPHPTag() {
        return this.startTagType == PHPTagTypes.PHP_STANDARD;
    }

    public boolean isMasonTag() {
        return this.startTagType == StartTagType.SERVER_COMMON || this.startTagType == MasonTagTypes.MASON_NAMED_BLOCK || this.startTagType == MasonTagTypes.MASON_COMPONENT_CALL || this.startTagType == MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    public boolean isMasonNamedBlock() {
        return this.startTagType == MasonTagTypes.MASON_NAMED_BLOCK;
    }

    public boolean isMasonComponentCall() {
        return this.startTagType == MasonTagTypes.MASON_COMPONENT_CALL;
    }

    public boolean isMasonComponentCalledWithContent() {
        return this.startTagType == MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT;
    }

    private EndTag findEndTagInternal() {
        Object object;
        boolean bl = true;
        if (this.startTagType == StartTagType.NORMAL) {
            object = HTMLElements.getTerminatingTagNameSets(this.name);
            if (object != null) {
                return this.findOptionalEndTag((HTMLElementTerminatingTagNameSets)object);
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            boolean bl2 = bl = !HTMLElements.getEndTagRequiredElementNames().contains(this.name);
            if (bl && this.isEmptyElementTag()) {
                return null;
            }
        } else if (this.startTagType.getCorrespondingEndTagType() == null) {
            return null;
        }
        if ((object = this.source.findNextEndTag(this.end, this.name, this.startTagType.getCorrespondingEndTagType())) != null) {
            if (HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag startTag = this.source.findNextStartTag(this.end, this.name);
                if (startTag == null || startTag.begin > ((EndTag)object).begin) {
                    return object;
                }
                if (this.source.isLoggingEnabled()) {
                    this.source.log(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, startTag.begin, startTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] segmentArray = this.findEndTag((EndTag)object, bl);
            if (segmentArray != null) {
                return (EndTag)segmentArray[0];
            }
        }
        if (this.source.isLoggingEnabled()) {
            this.source.log(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag findOptionalEndTag(HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets) {
        Tag tag;
        int n = this.end;
        while (n < this.source.end && (tag = Tag.findPreviousOrNextTag(this.source, n, false)) != null) {
            Set set;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                set = hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    n = element.end;
                    continue;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (set != null && set.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            n = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static StartTag findPreviousOrNext(Source source, int n, String string, boolean bl, boolean bl2) {
        if (string == null) {
            return StartTag.findPreviousOrNext(source, n, bl2);
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        char[] cArray = new char[string.length() + 1];
        cArray[0] = 60;
        for (int i = 1; i < cArray.length; ++i) {
            cArray[i] = string.charAt(i - 1);
        }
        if (cArray[1] == '/') {
            throw new IllegalArgumentException("searchName argument \"" + string + "\" must not start with '/'");
        }
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            while (true) {
                char c;
                int n3 = n2 = bl2 ? parseText.lastIndexOf(cArray, n2) : parseText.indexOf(cArray, n2);
                if (n2 == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, n2);
                if (!(startTag == null || bl && startTag.isUnregistered() || startTag.startTagType.isNameAfterPrefixRequired() && startTag.name.length() > string.length() && (c = string.charAt(string.length() - 1)) != ':' && StartTag.isXMLNameChar(c))) {
                    return startTag;
                }
                if (bl2) {
                    if ((n2 -= 2) >= 0) {
                        continue;
                    }
                    break;
                }
                if (++n2 >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag findPreviousOrNext(Source source, int n, boolean bl) {
        Tag tag;
        while ((tag = Tag.findPreviousOrNextTag(source, n, bl)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    static StartTag findNext(Source source, int n, String string, String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        char[] cArray = string2.toLowerCase().toCharArray();
        ParseText parseText = source.getParseText();
        while (n < source.end) {
            String string3;
            if ((n = parseText.indexOf(cArray, n)) == -1) {
                return null;
            }
            Tag tag = source.findEnclosingTag(n);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n;
                continue;
            }
            StartTag startTag = (StartTag)tag;
            if (startTag.getAttributes() != null && (string3 = startTag.getAttributes().getValue(string)) != null) {
                if (string2.equals(string3)) {
                    return startTag;
                }
                if (string2.equalsIgnoreCase(string3)) {
                    if (!bl) {
                        return startTag;
                    }
                    if (source.isLoggingEnabled()) {
                        source.log(source.getRowColumnVector(n).appendTo(new StringBuffer(200)).append(": StartTag with attribute ").append(string).append("=\"").append(string3).append("\" ignored during search because its case does not match search value \"").append(string2).append('\"').toString());
                    }
                }
            }
            n = startTag.end + 5;
        }
        return null;
    }

    private Segment[] findEndTag(EndTag endTag, boolean bl) {
        StartTag startTag = this.source.findNextStartTag(this.end, this.name);
        if (bl) {
            while (startTag != null && startTag.isEmptyElementTag()) {
                startTag = this.source.findNextStartTag(startTag.end, this.name);
            }
        }
        return this.findEndTag(this.end, startTag, endTag, bl);
    }

    private Segment[] findEndTag(int n, StartTag startTag, EndTag endTag, boolean bl) {
        if (endTag == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag, startTag};
        if (startTag == null || startTag.begin > endTag.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag.findEndTag(endTag, bl);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag2 = (EndTag)segmentArray2[0];
        startTag = (StartTag)segmentArray2[1];
        endTag = this.source.findNextEndTag(endTag2.end, this.name);
        return this.findEndTag(endTag2.end, startTag, endTag, bl);
    }
}

