/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.xbill.DNS.Client;

final class UDPClient
extends Client {
    public UDPClient(long endTime) throws IOException {
        super(DatagramChannel.open(), endTime);
    }

    void bind(SocketAddress addr) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        channel.socket().bind(addr);
    }

    void connect(SocketAddress addr) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        channel.connect(addr);
    }

    void send(byte[] data) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        UDPClient.verboseLog("UDP write", data);
        channel.write(ByteBuffer.wrap(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] recv(int max) throws IOException {
        byte[] temp;
        DatagramChannel channel;
        block5: {
            channel = (DatagramChannel)this.key.channel();
            temp = new byte[max];
            this.key.interestOps(1);
            try {
                while (!this.key.isReadable()) {
                    UDPClient.blockUntil(this.key, this.endTime);
                }
                Object var5_4 = null;
                if (!this.key.isValid()) break block5;
                this.key.interestOps(0);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.key.isValid()) {
                    this.key.interestOps(0);
                }
                throw throwable;
            }
            {
            }
        }
        long ret = channel.read(ByteBuffer.wrap(temp));
        if (ret <= 0L) {
            throw new EOFException();
        }
        int len = (int)ret;
        byte[] data = new byte[len];
        System.arraycopy(temp, 0, data, 0, len);
        UDPClient.verboseLog("UDP read", data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress local, SocketAddress remote, byte[] data, int max, long endTime) throws IOException {
        UDPClient client = new UDPClient(endTime);
        try {
            if (local != null) {
                client.bind(local);
            }
            client.connect(remote);
            client.send(data);
            byte[] byArray = client.recv(max);
            return byArray;
        }
        finally {
            client.cleanup();
        }
    }

    static byte[] sendrecv(SocketAddress addr, byte[] data, int max, long endTime) throws IOException {
        return UDPClient.sendrecv(null, addr, data, max, endTime);
    }
}

