/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.RequestLog;
import org.mortbay.util.Code;
import org.mortbay.util.DateCache;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringUtil;

public class NCSARequestLog
implements RequestLog {
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private boolean _buffered;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MMM/yyyy:HH:mm:ss ZZZ";
    private Locale _logLocale = Locale.US;
    private String _logTimeZone = TimeZone.getDefault().getID();
    private String[] _ignorePaths;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient PathMap _ignorePathMap;
    private transient Writer _writer;

    public NCSARequestLog() {
        this._buffered = false;
    }

    public NCSARequestLog(String filename) throws IOException {
        this.setFilename(filename);
        this._buffered = filename != null;
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public boolean isBuffered() {
        return this._buffered;
    }

    public void setBuffered(boolean buffered) {
        this._buffered = buffered;
    }

    public void setLogDateFormat(String format) {
        this._logDateFormat = format;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogTimeZone(String tz) {
        this._logTimeZone = tz;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setRetainDays(int retainDays) {
        this._retainDays = retainDays;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setExtended(boolean e) {
        this._extended = e;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setAppend(boolean a) {
        this._append = a;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setPreferProxiedForAddress(boolean value) {
        this._preferProxiedForAddress = value;
    }

    public void start() throws Exception {
        this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
        this._logDateCache.setTimeZoneID(this._logTimeZone);
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
            this._closeOut = true;
        } else {
            this._fileOut = System.err;
        }
        this._out = this._buffered ? new BufferedOutputStream(this._fileOut) : this._fileOut;
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            int i = 0;
            while (i < this._ignorePaths.length) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
                ++i;
            }
        } else {
            this._ignorePathMap = null;
        }
        this._writer = new OutputStreamWriter(this._out);
    }

    public boolean isStarted() {
        return this._fileOut != null;
    }

    public void stop() {
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        if (this._out != null && this._closeOut) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
        this._out = null;
        this._fileOut = null;
        this._closeOut = false;
        this._logDateCache = null;
        this._writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(HttpRequest request, HttpResponse response, int responseLength) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getPath()) != null) {
                return;
            }
            if (this._fileOut == null) {
                return;
            }
            StringBuffer buf = new StringBuffer(160);
            String addr = null;
            if (this._preferProxiedForAddress) {
                addr = request.getField("X-Forwarded-For");
            }
            if (addr == null) {
                addr = request.getRemoteAddr();
            }
            buf.append(addr);
            buf.append(" - ");
            String user = request.getAuthUser();
            buf.append(user == null ? "-" : user);
            buf.append(" [");
            buf.append(this._logDateCache.format(request.getTimeStamp()));
            buf.append("] \"");
            buf.append(request.getMethod());
            buf.append(' ');
            buf.append(request.getURI());
            buf.append(' ');
            buf.append(request.getVersion());
            buf.append("\" ");
            int status = response.getStatus();
            buf.append((char)(48 + status / 100 % 10));
            buf.append((char)(48 + status / 10 % 10));
            buf.append((char)(48 + status % 10));
            if (responseLength >= 0) {
                buf.append(' ');
                if (responseLength > 99999) {
                    buf.append(Integer.toString(responseLength));
                } else {
                    if (responseLength > 9999) {
                        buf.append((char)(48 + responseLength / 10000 % 10));
                    }
                    if (responseLength > 999) {
                        buf.append((char)(48 + responseLength / 1000 % 10));
                    }
                    if (responseLength > 99) {
                        buf.append((char)(48 + responseLength / 100 % 10));
                    }
                    if (responseLength > 9) {
                        buf.append((char)(48 + responseLength / 10 % 10));
                    }
                    buf.append((char)(48 + responseLength % 10));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            String log = buf.toString();
            Writer writer = this._writer;
            synchronized (writer) {
                this._writer.write(log);
                if (this._extended) {
                    this.logExtended(request, response, this._writer);
                }
                this._writer.write(StringUtil.__LINE_SEPARATOR);
                if (!this._buffered) {
                    this._writer.flush();
                }
            }
        }
        catch (IOException e) {
            Code.warning(e);
        }
    }

    protected void logExtended(HttpRequest request, HttpResponse response, Writer log) throws IOException {
        String referer = request.getField("Referer");
        if (referer == null) {
            log.write("\"-\" ");
        } else {
            log.write(34);
            log.write(referer);
            log.write("\" ");
        }
        String agent = request.getField("User-Agent");
        if (agent == null) {
            log.write("\"-\"");
        } else {
            log.write(34);
            log.write(agent);
            log.write(34);
        }
    }
}

