/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.PrintStream;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.Frame;
import org.mortbay.util.Log;

public class LogStream
extends PrintStream {
    static final PrintStream STDERR_STREAM = System.err;
    static final PrintStream STDOUT_STREAM = System.out;
    private String tag;
    private ByteArrayOutputStream2 bout;

    public static void setLogStdErr(boolean log) {
        if (log) {
            if (!(System.err instanceof LogStream)) {
                System.setErr(new STDERR());
            }
        } else {
            System.setErr(STDERR_STREAM);
        }
    }

    public static boolean getLogStdErr() {
        return System.err instanceof LogStream;
    }

    public static void setLogStdOut(boolean log) {
        if (log) {
            if (!(System.out instanceof LogStream)) {
                System.setOut(new STDOUT());
            }
        } else {
            System.setOut(STDOUT_STREAM);
        }
    }

    public static boolean getLogStdOut() {
        return System.out instanceof LogStream;
    }

    public void flush() {
        String s;
        super.flush();
        if (this.bout.size() > 0 && (s = new String(this.bout.getBuf(), 0, this.bout.size()).trim()).length() > 0) {
            Log.message(this.tag, s, new Frame());
        }
        this.bout.reset();
    }

    public LogStream(String tag) {
        super(new ByteArrayOutputStream2(128), true);
        this.bout = (ByteArrayOutputStream2)this.out;
        this.tag = tag;
    }

    public void close() {
        this.flush();
        super.close();
    }

    public void println() {
        super.println();
        this.flush();
    }

    public void println(boolean arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(char arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(char[] arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(double arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(float arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(int arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(long arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(Object arg0) {
        super.println(arg0);
        this.flush();
    }

    public void println(String arg0) {
        super.println(arg0);
        this.flush();
    }

    public void write(byte[] arg0, int arg1, int arg2) {
        super.write(arg0, arg1, arg2);
        this.flush();
    }

    public static class STDOUT
    extends LogStream {
        STDOUT() {
            super("STDOUT ");
        }
    }

    public static class STDERR
    extends LogStream {
        STDERR() {
            super("STDERR ");
        }
    }
}

