/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.Segment;
import java.io.IOException;
import java.io.Writer;

final class CharOutputSegment
implements OutputSegment {
    private int begin;
    private int end;
    private char ch;

    public CharOutputSegment(int n, int n2, char c) {
        this.begin = n;
        this.end = n2;
        this.ch = c;
    }

    public CharOutputSegment(Segment segment, char c) {
        this.begin = segment.begin;
        this.end = segment.end;
        this.ch = c;
    }

    public CharOutputSegment(CharacterReference characterReference) {
        this(characterReference, characterReference.getChar());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.ch);
    }

    public long getEstimatedMaximumOutputLength() {
        return 1L;
    }

    public String toString() {
        return Character.toString(this.ch);
    }

    public String getDebugInfo() {
        return "(" + this.begin + ',' + this.end + "):" + this.ch;
    }
}

