/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

final class EncodedSource {
    public final Reader Reader;
    public final String Encoding;
    public final String EncodingSpecificationInfo;
    public final HttpURLConnection HttpURLConnection;
    private static final int PREVIEW_BUFFER_SIZE = 2048;
    private static final int PREVIEW_MAX_BYTES = 8192;
    private static final String UTF_32 = "UTF-32";
    private static final String UTF_16 = "UTF-16";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    private static final String EBCDIC = "Cp037";
    private static final String ISO_8859_1 = "ISO-8859-1";

    EncodedSource(InputStream inputStream, String string, String string2, HttpURLConnection httpURLConnection) throws UnsupportedEncodingException {
        this.Reader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        this.Encoding = string;
        this.EncodingSpecificationInfo = string2;
        this.HttpURLConnection = httpURLConnection;
    }

    public static EncodedSource construct(URL uRL) throws IOException {
        String string;
        URLConnection uRLConnection = uRL.openConnection();
        HttpURLConnection httpURLConnection = uRLConnection instanceof HttpURLConnection ? (HttpURLConnection)uRLConnection : null;
        InputStream inputStream = uRLConnection.getInputStream();
        String string2 = uRLConnection.getContentType();
        if (string2 != null && (string = Source.getCharsetParameterFromHttpHeaderValue(string2)) != null) {
            return new EncodedSource(inputStream, string, "HTTP header Content-Type: " + string2, httpURLConnection);
        }
        return EncodedSource.construct(inputStream, httpURLConnection);
    }

    public static EncodedSource construct(InputStream inputStream, HttpURLConnection httpURLConnection) throws IOException {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        bufferedInputStream.mark(8192);
        String string = EncodedSource.getPreliminaryEncoding(bufferedInputStream);
        if (string == null) {
            return new EncodedSource(bufferedInputStream, null, "empty input stream", httpURLConnection);
        }
        bufferedInputStream.reset();
        Source source = EncodedSource.getPreviewSource(bufferedInputStream, string);
        bufferedInputStream.reset();
        if (source.getEncoding() != null) {
            return new EncodedSource(bufferedInputStream, source.encoding, source.encodingSpecificationInfo, httpURLConnection);
        }
        if (httpURLConnection != null && string == UTF_8 && !source.isXML()) {
            return new EncodedSource(bufferedInputStream, ISO_8859_1, "HTTP default 8-bit encoding for non-XML document", httpURLConnection);
        }
        return new EncodedSource(bufferedInputStream, string, "XML default matching first four bytes of input stream", httpURLConnection);
    }

    private static String getPreliminaryEncoding(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        if (n == -1) {
            return null;
        }
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        int n4 = bufferedInputStream.read();
        if ((n & 0xFE) == 254 && n2 == (n ^ 1)) {
            return n3 == 0 ? UTF_32 : UTF_16;
        }
        if (n == 0) {
            if (n2 == 0 || n4 == 0) {
                return UTF_32;
            }
            return UTF_16BE;
        }
        if (n2 == 0) {
            return n3 == 0 ? UTF_32 : UTF_16LE;
        }
        if (n == 76 && n2 == 111 && n3 == 167 && n4 == 148) {
            return EBCDIC;
        }
        return UTF_8;
    }

    private static Source getPreviewSource(BufferedInputStream bufferedInputStream, String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string), 2048);
        StringBuffer stringBuffer = new StringBuffer(2048);
        for (int i = 0; i < 2048 && (n = bufferedReader.read()) != -1; ++i) {
            stringBuffer.append((char)n);
        }
        return new Source(stringBuffer);
    }
}

