/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.AttributesOutputSegment;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharOutputSegment;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.OverlappingOutputSegmentsException;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StringOutputSegment;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.sourceText = source;
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(Segment segment) {
        this.replace(segment, (CharSequence)null);
    }

    public void remove(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove((Segment)iterator.next());
        }
    }

    public void insert(int n, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n, charSequence));
    }

    public void replace(Segment segment, CharSequence charSequence) {
        this.replace(segment.getBegin(), segment.getEnd(), charSequence);
    }

    public void replace(int n, int n2, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n2, charSequence));
    }

    public void replace(int n, int n2, char c) {
        this.register(new CharOutputSegment(n, n2, c));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map replace(Attributes attributes, boolean bl) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, bl);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int n, int n2) {
        this.register(new BlankOutputSegment(n, n2));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.outputSegments.isEmpty()) {
            Util.appendTo(writer, this.sourceText);
            return;
        }
        int n = 0;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        OutputSegment outputSegment = null;
        Iterator iterator = this.outputSegments.iterator();
        while (iterator.hasNext()) {
            OutputSegment outputSegment2 = (OutputSegment)iterator.next();
            if (outputSegment2 == outputSegment) continue;
            if (outputSegment2.getBegin() < n) {
                throw new OverlappingOutputSegmentsException(outputSegment, outputSegment2);
            }
            if (outputSegment2.getBegin() > n) {
                Util.appendTo(writer, this.sourceText, n, outputSegment2.getBegin());
            }
            outputSegment2.writeTo(writer);
            outputSegment = outputSegment2;
            n = outputSegment2.getEnd();
        }
        if (n < this.sourceText.length()) {
            Util.appendTo(writer, this.sourceText, n, this.sourceText.length());
        }
        writer.close();
    }

    public long getEstimatedMaximumOutputLength() {
        long l = this.sourceText.length();
        Iterator iterator = this.outputSegments.iterator();
        while (iterator.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)iterator.next();
            int n = outputSegment.getEnd() - outputSegment.getBegin();
            l += outputSegment.getEstimatedMaximumOutputLength() - (long)n;
        }
        return l;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public OutputDocument(CharSequence charSequence) {
        if (charSequence == null) {
            throw new IllegalArgumentException("sourceText argument must not be null");
        }
        this.sourceText = charSequence;
    }

    public void add(OutputSegment outputSegment) {
        this.register(outputSegment);
    }

    public void add(FormControl formControl) {
        this.replace(formControl);
    }

    public void add(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public void output(Writer writer) throws IOException {
        this.writeTo(writer);
    }

    public Reader getReader() {
        return CharStreamSourceUtil.getReader(this);
    }
}

