/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.MasonTagTypes;
import au.id.jericho.lib.html.PHPTagTypes;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.TagType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Tag
extends Segment
implements HTMLElementName {
    String name = null;
    Element element = Element.NOT_CACHED;
    int allTagsArrayIndex = -1;
    private Object userData = null;
    public static final String PROCESSING_INSTRUCTION = StartTagType.XML_PROCESSING_INSTRUCTION.getNamePrefixForTagConstant();
    public static final String XML_DECLARATION = StartTagType.XML_DECLARATION.getNamePrefixForTagConstant();
    public static final String DOCTYPE_DECLARATION = StartTagType.DOCTYPE_DECLARATION.getNamePrefixForTagConstant();
    public static final String SERVER_PHP = PHPTagTypes.PHP_STANDARD.getNamePrefixForTagConstant();
    public static final String SERVER_COMMON = StartTagType.SERVER_COMMON.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_NAMED_BLOCK = MasonTagTypes.MASON_NAMED_BLOCK.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALL = MasonTagTypes.MASON_COMPONENT_CALL.getNamePrefixForTagConstant();
    public static final String SERVER_MASON_COMPONENT_CALLED_WITH_CONTENT = MasonTagTypes.MASON_COMPONENT_CALLED_WITH_CONTENT.getNamePrefixForTagConstant();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int n, int n2, String string) {
        super(source, n, n2);
        this.name = HTMLElements.getConstantElementName(string.toLowerCase());
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int n = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, n, n + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Tag findNextTag() {
        Tag[] tagArray = this.source.allTagsArray;
        if (tagArray != null) {
            int n = this.allTagsArrayIndex + 1;
            if (tagArray.length == n) {
                return null;
            }
            return tagArray[n];
        }
        return this.source.findNextTag(this.begin + 1);
    }

    public Tag findPreviousTag() {
        Tag[] tagArray = this.source.allTagsArray;
        if (tagArray != null) {
            if (this.allTagsArrayIndex == 0) {
                return null;
            }
            return tagArray[this.allTagsArrayIndex - 1];
        }
        if (this.begin == 0) {
            return null;
        }
        return this.source.findPreviousTag(this.begin - 1);
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || !Tag.isXMLNameStartChar(charSequence.charAt(0))) {
            return false;
        }
        for (int i = 1; i < charSequence.length(); ++i) {
            if (Tag.isXMLNameChar(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    public static final boolean isXMLNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    public abstract String regenerateHTML();

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag findPreviousOrNextTag(Source source, int n, boolean bl) {
        return source.useAllTypesCache ? source.cache.findPreviousOrNextTag(n, bl) : Tag.findPreviousOrNextTagUncached(source, n, bl, -1);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int n, boolean bl, int n2) {
        try {
            ParseText parseText = source.getParseText();
            int n3 = n;
            while (true) {
                int n4 = n3 = bl ? parseText.lastIndexOf('<', n3, n2) : parseText.indexOf('<', n3, n2);
                if (n3 == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, n3);
                if (tag != null && tag.includeInSearch()) {
                    return tag;
                }
                if (bl) {
                    if (--n3 >= 0) {
                        continue;
                    }
                    break;
                }
                if (++n3 >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag findPreviousOrNextTag(Source source, int n, TagType tagType, boolean bl) {
        if (source.useSpecialTypesCache) {
            return source.cache.findPreviousOrNextTag(n, tagType, bl);
        }
        return Tag.findPreviousOrNextTagUncached(source, n, tagType, bl, -1);
    }

    static final Tag findPreviousOrNextTagUncached(Source source, int n, TagType tagType, boolean bl, int n2) {
        if (tagType == null) {
            return Tag.findPreviousOrNextTagUncached(source, n, bl, n2);
        }
        char[] cArray = tagType.getStartDelimiterCharArray();
        try {
            ParseText parseText = source.getParseText();
            int n3 = n;
            while (true) {
                int n4 = n3 = bl ? parseText.lastIndexOf(cArray, n3, n2) : parseText.indexOf(cArray, n3, n2);
                if (n3 == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, n3);
                if (tag != null && tag.getTagType() == tagType) {
                    return tag;
                }
                if (bl) {
                    if (--n3 >= 0) {
                        continue;
                    }
                    break;
                }
                if (++n3 >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int n) {
        return source.useAllTypesCache ? source.cache.getTagAt(n) : Tag.getTagAtUncached(source, n);
    }

    static final Tag getTagAtUncached(Source source, int n) {
        return TagType.getTagAt(source, n, false);
    }

    static final Tag[] parseAll(Source source, boolean bl) {
        int n;
        Object object;
        Tag[] tagArray;
        int n2 = 0;
        int n3 = 0;
        ArrayList<StartTag[]> arrayList = new ArrayList<StartTag[]>();
        if (source.end != 0) {
            tagArray = source.getParseText();
            object = Tag.parseAllFindNextTag(source, (ParseText)tagArray, 0, bl);
            while (object != null) {
                arrayList.add((StartTag[])object);
                if (!object.isUnregistered()) {
                    ++n2;
                    if (object instanceof StartTag) {
                        ++n3;
                    }
                }
                int n4 = n = bl && !object.isUnregistered() ? object.end : object.begin + 1;
                if (n == source.end) break;
                object = Tag.parseAllFindNextTag(source, (ParseText)tagArray, n, bl);
            }
        }
        tagArray = new Tag[n2];
        object = new StartTag[n3];
        source.cache.loadAllTags(arrayList, tagArray, (StartTag[])object);
        source.allTagsArray = tagArray;
        source.allTags = Arrays.asList(tagArray);
        source.allStartTags = Arrays.asList(object);
        for (n = 0; n < tagArray.length; ++n) {
            tagArray[n].allTagsArrayIndex = n;
        }
        return tagArray;
    }

    private static final Tag parseAllFindNextTag(Source source, ParseText parseText, int n, boolean bl) {
        try {
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf('<', n2)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source, n2, bl);
                if (tag == null) continue;
                if (!bl) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source.endOfLastTagIgnoringEnclosedMarkup && !tagType.isServerTag() && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source.endOfLastTagIgnoringEnclosedMarkup = tag.end;
                    }
                }
                return tag;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static Iterator getNextTagIterator(Source source, int n) {
        return new NextTagIterator(source, n);
    }

    private static final class NextTagIterator
    implements Iterator {
        private Tag nextTag = null;

        public NextTagIterator(Source source, int n) {
            this.nextTag = Tag.findPreviousOrNextTag(source, n, false);
        }

        public boolean hasNext() {
            return this.nextTag != null;
        }

        public Object next() {
            Tag tag = this.nextTag;
            try {
                this.nextTag = Tag.findPreviousOrNextTag(tag.source, tag.begin + 1, false);
            }
            catch (NullPointerException nullPointerException) {
                throw new NoSuchElementException();
            }
            return tag;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

