/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.markup;

import com.lowagie.text.FontFactory;
import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;

public class MarkupParser {
    private MarkupParser() {
    }

    public static Properties parseAttributes(String string) {
        Properties result = new Properties();
        if (string == null) {
            return result;
        }
        StringTokenizer keyValuePairs = new StringTokenizer(string, ";");
        while (keyValuePairs.hasMoreTokens()) {
            StringTokenizer keyValuePair = new StringTokenizer(keyValuePairs.nextToken(), ":");
            if (!keyValuePair.hasMoreTokens()) continue;
            String key = keyValuePair.nextToken().trim();
            if (!keyValuePair.hasMoreTokens()) continue;
            String value = keyValuePair.nextToken().trim();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            result.setProperty(key, value);
        }
        return result;
    }

    public static Properties parseFont(String string) {
        Properties result = new Properties();
        if (string == null) {
            return result;
        }
        int pos = 0;
        string = string.trim();
        while (string.length() > 0) {
            float f;
            String value;
            if ((pos = string.indexOf(" ", pos)) == -1) {
                value = string;
                string = "";
            } else {
                value = string.substring(0, pos);
                string = string.substring(pos).trim();
            }
            if (value.equalsIgnoreCase("bold")) {
                result.setProperty("font-weight", "bold");
                continue;
            }
            if (value.equalsIgnoreCase("italic")) {
                result.setProperty("font-style", "italic");
                continue;
            }
            if (value.equalsIgnoreCase("oblique")) {
                result.setProperty("font-style", "oblique");
                continue;
            }
            float f2 = MarkupParser.parseLength(value);
            if (f > 0.0f) {
                result.setProperty("font-size", String.valueOf(String.valueOf(f2)) + "pt");
                int p = value.indexOf("/");
                if (p > -1 && p < value.length() - 1) {
                    result.setProperty("line-height", String.valueOf(String.valueOf(value.substring(p + 1))) + "pt");
                }
            }
            if (value.endsWith(",") && FontFactory.contains(value = value.substring(0, value.length() - 1))) {
                result.setProperty("font-family", value);
                return result;
            }
            if (!"".equals(string) || !FontFactory.contains(value)) continue;
            result.setProperty("font-family", value);
        }
        return result;
    }

    public static float parseLength(String string) {
        int pos = 0;
        int length = string.length();
        boolean ok = true;
        while (ok && pos < length) {
            switch (string.charAt(pos)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++pos;
                    break;
                }
                default: {
                    ok = false;
                }
            }
        }
        if (pos == 0) {
            return 0.0f;
        }
        if (pos == length) {
            return Float.valueOf(String.valueOf(string) + "f").floatValue();
        }
        float f = Float.valueOf(String.valueOf(string.substring(0, pos)) + "f").floatValue();
        if ((string = string.substring(pos)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        return f;
    }

    public static Color decodeColor(String color) {
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(color.substring(1, 3), 16);
            green = Integer.parseInt(color.substring(3, 5), 16);
            blue = Integer.parseInt(color.substring(5), 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Color(red, green, blue);
    }
}

