/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog((Class)XmlResponsesSaxParser.class);
    private XMLReader xr = null;

    public XmlResponsesSaxParser() throws S3ServiceException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new S3ServiceException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws S3ServiceException {
        try {
            log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
            }
            throw new S3ServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws S3ServiceException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws S3ServiceException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws S3ServiceException {
        AccessControlListHandler handler = new AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingStatusHandler parseLoggingStatusResponse(InputStream inputStream) throws S3ServiceException {
        BucketLoggingStatusHandler handler = new BucketLoggingStatusHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public class BucketLoggingStatusHandler
    extends DefaultHandler {
        private S3BucketLoggingStatus bucketLoggingStatus = null;
        private String targetBucket = null;
        private String targetPrefix = null;
        private StringBuffer currText = new StringBuffer();

        public S3BucketLoggingStatus getBucketLoggingStatus() {
            return this.bucketLoggingStatus;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("BucketLoggingStatus")) {
                this.bucketLoggingStatus = new S3BucketLoggingStatus();
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("TargetBucket")) {
                this.targetBucket = elementText;
            } else if (name.equals("TargetPrefix")) {
                this.targetPrefix = elementText;
            } else if (name.equals("LoggingEnabled")) {
                this.bucketLoggingStatus.setTargetBucketName(this.targetBucket);
                this.bucketLoggingStatus.setLogfilePrefix(this.targetPrefix);
            }
            this.currText = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class AccessControlListHandler
    extends DefaultHandler {
        private AccessControlList accessControlList = null;
        private S3Owner owner = null;
        private GranteeInterface currentGrantee = null;
        private Permission currentPermission = null;
        private StringBuffer currText = new StringBuffer();
        private boolean insideACL = false;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Owner")) {
                this.owner = new S3Owner();
            } else if (name.equals("AccessControlList")) {
                this.accessControlList = new AccessControlList();
                this.accessControlList.setOwner(this.owner);
                this.insideACL = true;
            } else if (name.equals("Grantee")) {
                if ("AmazonCustomerByEmail".equals(attrs.getValue("xsi:type"))) {
                    this.currentGrantee = new EmailAddressGrantee();
                } else if ("CanonicalUser".equals(attrs.getValue("xsi:type"))) {
                    this.currentGrantee = new CanonicalGrantee();
                } else if ("Group".equals(attrs.getValue("xsi:type"))) {
                    this.currentGrantee = new GroupGrantee();
                }
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID") && !this.insideACL) {
                this.owner.setId(elementText);
            } else if (name.equals("DisplayName") && !this.insideACL) {
                this.owner.setDisplayName(elementText);
            } else if (name.equals("ID")) {
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI")) {
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
            } else if (name.equals("AccessControlList")) {
                this.insideACL = false;
            }
            this.currText = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListAllMyBucketsHandler
    extends DefaultHandler {
        private S3Owner bucketsOwner = null;
        private S3Bucket currentBucket = null;
        private StringBuffer currText = null;
        private List buckets = new ArrayList();

        public ListAllMyBucketsHandler() {
            this.currText = new StringBuffer();
        }

        public S3Bucket[] getBuckets() {
            return this.buckets.toArray(new S3Bucket[this.buckets.size()]);
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Bucket")) {
                this.currentBucket = new S3Bucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new S3Owner();
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID")) {
                this.bucketsOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.bucketsOwner.setDisplayName(elementText);
            } else if (name.equals("Bucket")) {
                log.debug((Object)("=== Created new bucket from listing: " + this.currentBucket));
                this.currentBucket.setOwner(this.bucketsOwner);
                this.buckets.add(this.currentBucket);
            } else if (name.equals("Name")) {
                this.currentBucket.setName(elementText);
            } else if (name.equals("CreationDate")) {
                try {
                    this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            }
            this.currText = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class ListBucketHandler
    extends DefaultHandler {
        private S3Object currentObject = null;
        private S3Owner currentOwner = null;
        private StringBuffer currText = null;
        private List objects = new ArrayList();
        private String bucketName = null;
        private String requestPrefix = null;
        private String requestMarker = null;
        private long requestMaxKeys = 0L;
        private boolean listingTruncated = false;
        private String lastKey = null;

        public ListBucketHandler() {
            this.currText = new StringBuffer();
        }

        public String getLastKey() {
            return this.lastKey;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public S3Object[] getObjects() {
            return this.objects.toArray(new S3Object[this.objects.size()]);
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.currentObject = new S3Object(null);
            } else if (name.equals("Owner")) {
                this.currentOwner = new S3Owner();
                this.currentObject.setOwner(this.currentOwner);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("Name")) {
                this.bucketName = elementText;
                log.debug((Object)("Examining listing for bucket: " + this.bucketName));
            } else if (name.equals("Prefix")) {
                this.requestPrefix = elementText;
            } else if (name.equals("Marker")) {
                this.requestMarker = elementText;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = Long.parseLong(elementText);
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.listingTruncated = false;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.listingTruncated = true;
                }
            } else if (name.equals("Contents")) {
                this.objects.add(this.currentObject);
                log.debug((Object)("=== Created new S3Object from listing: " + this.currentObject));
            } else if (name.equals("Key")) {
                this.currentObject.setKey(elementText);
                this.lastKey = elementText;
            } else if (name.equals("LastModified")) {
                try {
                    this.currentObject.setLastModifiedDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unexpected date format in list bucket output", e);
                }
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(elementText);
            } else if (name.equals("Size")) {
                this.currentObject.setContentLength(Long.parseLong(elementText));
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(elementText);
            } else if (name.equals("ID")) {
                this.currentOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(elementText);
            }
            this.currText = new StringBuffer();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }
}

