/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class GetObjectHeadsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private GetObjectHeadsEvent(int eventCode) {
        super(eventCode);
    }

    public static GetObjectHeadsEvent newErrorEvent(Throwable t) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static GetObjectHeadsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static GetObjectHeadsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static GetObjectHeadsEvent newCompletedEvent() {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(2);
        return event;
    }

    public static GetObjectHeadsEvent newCancelledEvent(S3Object[] incompletedObjects) {
        GetObjectHeadsEvent event = new GetObjectHeadsEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getCompletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

