/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class LookupACLEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private LookupACLEvent(int eventCode) {
        super(eventCode);
    }

    public static LookupACLEvent newErrorEvent(Throwable t) {
        LookupACLEvent event = new LookupACLEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static LookupACLEvent newStartedEvent(ThreadWatcher threadWatcher) {
        LookupACLEvent event = new LookupACLEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static LookupACLEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        LookupACLEvent event = new LookupACLEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static LookupACLEvent newCompletedEvent() {
        LookupACLEvent event = new LookupACLEvent(2);
        return event;
    }

    public static LookupACLEvent newCancelledEvent(S3Object[] incompletedObjects) {
        LookupACLEvent event = new LookupACLEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getObjectsWithACL() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

