/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EncryptionUtil {
    private static final Log log = LogFactory.getLog((Class)EncryptionUtil.class);
    public static final String UNICODE_FORMAT = "UTF8";
    public static final String DEFAULT_VERSION = "2";
    private String algorithm = null;
    private String version = null;
    private SecretKey key = null;
    private AlgorithmParameterSpec algParamSpec = null;
    int ITERATION_COUNT = 5000;
    byte[] salt = new byte[]{-92, 11, -56, 52, -42, -107, -13, 19};

    public EncryptionUtil(String encryptionKey, String algorithm, String version) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this.algorithm = algorithm;
        this.version = version;
        log.debug((Object)("Cryptographic properties: algorithm=" + this.algorithm + ", version=" + this.version));
        if (!DEFAULT_VERSION.equals(version)) {
            throw new RuntimeException("Unrecognised crypto version setting: " + version);
        }
        PBEKeySpec keyspec = new PBEKeySpec(encryptionKey.toCharArray(), this.salt, this.ITERATION_COUNT, 32);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
        this.key = skf.generateSecret(keyspec);
        this.algParamSpec = new PBEParameterSpec(this.salt, this.ITERATION_COUNT);
    }

    public EncryptionUtil(String encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException {
        this(encryptionKey, "PBEWithMD5AndDES", DEFAULT_VERSION);
    }

    private EncryptionUtil(String encryptionKey, String encryptionScheme, String blockMode, String paddingMode) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, UnsupportedEncodingException {
        byte[] KEY_BASE_BYTES = new byte[]{-62, -85, -30, -128, -96, 14, -62, -69, -61, -90, -30, -128, -108, 114, 61, -61, -76, 24, 20, 81, -59, -110, 32, 121, -30, -124, -94, 83, 52, 67, 46, 36, 83, -61, -65, -61, -110, 116, -53, -102, -61, -96, -61, -95, 73, -61, -116, 91, -30, -120, -122, 79, -61, -117, -61, -106, -61, -124, 117, 64, -30, -128, -99, 28, -62, -87, 100, 70, 22, 84, 23, 3, -62, -76, -61, -92, -30, -127, -124, -61, -95, 78, 104, -61, -117, -61, -86, 118, -62, -85, 29, -30, -128, -108, -62, -93, 108, -61, -69, 94, 117, -30, -128, -99, -61, -125, 16, -49, -128, 43, 116, -59, -109, 58, -61, -128, 75, 55, 81, -62, -89, -30, -120, -98, 72, 62, -30, -128, -98, 58, 105, -61, -118, 117, 17, -30, -128, -80, -61, -108, -61, -68, 81, -61, -109, 35, -30, -128, -70, -62, -91, 49, -30, -128, -108, 122, 106, -62, -75, -30, -127, -124, -30, -128, -71, 41, 49, 111, -30, -128, -80, -61, -73, 77, -61, -104, 53, 68, 70, -61, -83, -62, -85, -59, -72, 46, 35, 99, 59, -62, -81, -62, -73, -17, -93, -65, -53, -122, -61, -116, 66, -50, -87, -30, -120, -122, 118, -30, -124, -94};
        this.algorithm = "DESede/CBC/PKCS5Padding";
        encryptionKey = encryptionKey + new String(KEY_BASE_BYTES, UNICODE_FORMAT);
        int keyOffset = 0;
        byte[] spec = new byte[8];
        for (int specOffset = 0; specOffset < spec.length; ++specOffset) {
            keyOffset = (keyOffset + 7) % encryptionKey.length();
            spec[specOffset] = encryptionKey.getBytes()[keyOffset];
        }
        DESedeKeySpec keySpec = new DESedeKeySpec(encryptionKey.getBytes());
        this.algParamSpec = new IvParameterSpec(spec);
        this.key = SecretKeyFactory.getInstance(encryptionScheme).generateSecret(keySpec);
    }

    public static EncryptionUtil getObsoleteEncryptionUtil(String encryptionKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, UnsupportedEncodingException {
        return new EncryptionUtil(encryptionKey, "DESede", "CBC", "PKCS5Padding");
    }

    protected Cipher initEncryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    protected Cipher initDecryptModeCipher() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, (Key)this.key, this.algParamSpec);
        return cipher;
    }

    public byte[] encrypt(String data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data.getBytes(UNICODE_FORMAT));
    }

    public String decryptString(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new String(cipher.doFinal(data), UNICODE_FORMAT);
    }

    public String decryptString(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new String(cipher.doFinal(data, startIndex, endIndex), UNICODE_FORMAT);
    }

    public byte[] encrypt(byte[] data) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data, int startIndex, int endIndex) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return cipher.doFinal(data, startIndex, endIndex);
    }

    public CipherInputStream encrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherInputStream decrypt(InputStream is) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherInputStream(is, cipher);
    }

    public CipherOutputStream encrypt(OutputStream os) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initEncryptModeCipher();
        return new CipherOutputStream(os, cipher);
    }

    public CipherOutputStream decrypt(OutputStream os) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.initDecryptModeCipher();
        return new CipherOutputStream(os, cipher);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static String[] listAvailableCiphers() {
        Set<String> ciphers = Security.getAlgorithms("Cipher");
        return ciphers.toArray(new String[ciphers.size()]);
    }

    public static String[] listAvailableAlgorithms() {
        Set<String> algorithms = Security.getAlgorithms("SecretKeyAlgorithm");
        return algorithms.toArray(new String[algorithms.size()]);
    }

    public static void main(String[] args) throws Exception {
        String[] ciphers = EncryptionUtil.listAvailableCiphers();
        System.out.println("Ciphers:");
        for (int i = 0; i < ciphers.length; ++i) {
            System.out.println(ciphers[i]);
        }
        String[] algorithms = EncryptionUtil.listAvailableCiphers();
        System.out.println("Algorithms:");
        for (int i = 0; i < algorithms.length; ++i) {
            System.out.println(algorithms[i]);
        }
    }
}

