/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils.gatekeeper;

import java.util.HashMap;
import java.util.Map;

public class SignatureRequest {
    public static final String SIGNATURE_TYPE_GET = "get";
    public static final String SIGNATURE_TYPE_HEAD = "head";
    public static final String SIGNATURE_TYPE_PUT = "put";
    public static final String SIGNATURE_TYPE_DELETE = "delete";
    private String signatureType = null;
    private String objectKey = null;
    private String bucketName = null;
    private Map objectMetadata = new HashMap();
    private String signedUrl = null;
    private String declineReason = null;

    public SignatureRequest() {
    }

    public SignatureRequest(String signatureType, String objectKey) {
        this.setSignatureType(signatureType);
        this.objectKey = objectKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public Map getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(Map objectMetadata) {
        this.objectMetadata.putAll(objectMetadata);
    }

    public void addObjectMetadata(String metadataName, String metadataValue) {
        this.objectMetadata.put(metadataName, metadataValue);
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(String signatureType) {
        if (!(SIGNATURE_TYPE_GET.equals(signatureType) || SIGNATURE_TYPE_HEAD.equals(signatureType) || SIGNATURE_TYPE_PUT.equals(signatureType) || SIGNATURE_TYPE_DELETE.equals(signatureType))) {
            throw new IllegalArgumentException("Illegal signature type: " + signatureType);
        }
        this.signatureType = signatureType;
    }

    public void signRequest(String signedUrl) {
        this.signedUrl = signedUrl;
    }

    public String getSignedUrl() {
        return this.signedUrl;
    }

    public void declineRequest(String reason) {
        this.declineReason = reason;
    }

    public String getDeclineReason() {
        return this.declineReason;
    }

    public boolean isSigned() {
        return this.getSignedUrl() != null;
    }
}

