/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

public class HSSFDateUtil {
    private static final int BAD_DATE = -1;
    private static final long DAY_MILLISECONDS = 86400000L;
    private static final double CAL_1900_ABSOLUTE = (double)HSSFDateUtil.absoluteDay(new GregorianCalendar(1900, 0, 1)) - 2.0;

    private HSSFDateUtil() {
    }

    public static double getExcelDate(Date date) {
        Calendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        if (calStart.get(1) < 1900) {
            return -1.0;
        }
        calStart = HSSFDateUtil.dayStart(calStart);
        double fraction = (double)(date.getTime() - calStart.getTime().getTime()) / 8.64E7;
        return fraction + (double)HSSFDateUtil.absoluteDay(calStart) - CAL_1900_ABSOLUTE;
    }

    public static Date getJavaDate(double date) {
        return HSSFDateUtil.getJavaDate(date, false);
    }

    public static Date getJavaDate(double date, boolean use1904windowing) {
        if (HSSFDateUtil.isValidExcelDate(date)) {
            int startYear = 1900;
            int dayAdjust = -1;
            int wholeDays = (int)Math.floor(date);
            if (use1904windowing) {
                startYear = 1904;
                dayAdjust = 1;
            } else if (wholeDays < 61) {
                dayAdjust = 0;
            }
            GregorianCalendar calendar = new GregorianCalendar(startYear, 0, wholeDays + dayAdjust);
            int millisecondsInDay = (int)((date - Math.floor(date)) * 8.64E7 + 0.5);
            calendar.set(14, millisecondsInDay);
            return calendar.getTime();
        }
        return null;
    }

    public static boolean isInternalDateFormat(int format) {
        boolean retval = false;
        switch (format) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: {
                retval = true;
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    public static boolean isCellDateFormatted(HSSFCell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = cell.getNumericCellValue();
        if (HSSFDateUtil.isValidExcelDate(d)) {
            HSSFCellStyle style = cell.getCellStyle();
            short i = style.getDataFormat();
            bDate = HSSFDateUtil.isInternalDateFormat(i);
        }
        return bDate;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    private static int absoluteDay(Calendar cal) {
        return cal.get(6) + HSSFDateUtil.daysInPriorYears(cal.get(1));
    }

    private static int daysInPriorYears(int yr) {
        if (yr < 1601) {
            throw new IllegalArgumentException("'year' must be 1601 or greater");
        }
        int y = yr - 1601;
        int days = 365 * y + y / 4 - y / 100 + y / 400;
        return days;
    }

    private static Calendar dayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }
}

