/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;

public class PdfBarcode
extends Chunk {
    public static final int CODE39 = 1;
    public static final int UPCA = 2;
    public static final int EAN13 = 3;
    public static final int INTERLEAVED_2_OF_5 = 4;
    public static final int[][] variableParity;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[12];
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[2] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[12];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 2;
        nArray3[7] = 2;
        nArray3[8] = 2;
        nArray3[9] = 2;
        nArray3[10] = 2;
        nArray3[11] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[12];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[6] = 2;
        nArray4[7] = 2;
        nArray4[8] = 2;
        nArray4[9] = 2;
        nArray4[10] = 2;
        nArray4[11] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 2;
        nArray5[7] = 2;
        nArray5[8] = 2;
        nArray5[9] = 2;
        nArray5[10] = 2;
        nArray5[11] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[12];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[5] = 1;
        nArray6[6] = 2;
        nArray6[7] = 2;
        nArray6[8] = 2;
        nArray6[9] = 2;
        nArray6[10] = 2;
        nArray6[11] = 2;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[12];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[6] = 2;
        nArray7[7] = 2;
        nArray7[8] = 2;
        nArray7[9] = 2;
        nArray7[10] = 2;
        nArray7[11] = 2;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[12];
        nArray8[1] = 1;
        nArray8[3] = 1;
        nArray8[5] = 1;
        nArray8[6] = 2;
        nArray8[7] = 2;
        nArray8[8] = 2;
        nArray8[9] = 2;
        nArray8[10] = 2;
        nArray8[11] = 2;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[12];
        nArray9[1] = 1;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[6] = 2;
        nArray9[7] = 2;
        nArray9[8] = 2;
        nArray9[9] = 2;
        nArray9[10] = 2;
        nArray9[11] = 2;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[12];
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[4] = 1;
        nArray10[6] = 2;
        nArray10[7] = 2;
        nArray10[8] = 2;
        nArray10[9] = 2;
        nArray10[10] = 2;
        nArray10[11] = 2;
        nArrayArray[9] = nArray10;
        variableParity = nArrayArray;
    }

    public PdfBarcode(String ttf, int type, int size, String number) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(type, number), new Font(BaseFont.createFont(ttf, "winansi", true), (float)size));
    }

    public PdfBarcode(String ttf, int type, int size, long number) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(type, String.valueOf(number)), new Font(BaseFont.createFont(ttf, "winansi", true), (float)size));
    }

    private static String convertToCode(int type, String number) throws BadElementException {
        StringBuffer code = new StringBuffer();
        int length = number.length();
        int pos = 0;
        try {
            switch (type) {
                case 1: {
                    code.append('*');
                    while (pos < length) {
                        code.append(number.substring(pos++, pos));
                    }
                    code.append('*');
                    break;
                }
                case 2: {
                    if (length > 12) {
                        throw new BadElementException("An UPC-A barcode can only encode a 12 digit number (your number was " + number + ").");
                    }
                    number = PdfBarcode.addZero(number, 12);
                    int digit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(digit + 80));
                    while (pos < 6) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48));
                    }
                    code.append('p');
                    while (pos < 11) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 64));
                    }
                    digit = Integer.parseInt(number.substring(11));
                    code.append((char)(digit + 96));
                    break;
                }
                case 3: {
                    if (length > 13) {
                        throw new BadElementException("An EAN-13 barcode can only encode a 13 digit number (your number was " + number + ").");
                    }
                    number = PdfBarcode.addZero(number, 13);
                    int firstdigit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(firstdigit + 33));
                    int digit = Integer.parseInt(number.substring(pos++, pos));
                    code.append((char)(digit + 96));
                    while (pos < 7) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48 + 16 * variableParity[firstdigit][pos - 2]));
                    }
                    code.append('|');
                    while (pos < 12) {
                        digit = Integer.parseInt(number.substring(pos++, pos));
                        code.append((char)(digit + 48 + 16 * variableParity[firstdigit][pos - 2]));
                    }
                    digit = Integer.parseInt(number.substring(12));
                    code.append((char)(digit + 112));
                    break;
                }
                case 4: {
                    int digit;
                    if (length % 2 == 1) {
                        number = PdfBarcode.addZero(number, length + 1);
                    }
                    code.append('(');
                    while (number.length() > 2) {
                        digit = Integer.parseInt(number.substring(0, 2));
                        code.append(PdfBarcode.convertInterleaved(digit));
                        pos += 2;
                        number = number.substring(2);
                    }
                    digit = Integer.parseInt(number);
                    code.append(PdfBarcode.convertInterleaved(digit));
                    code.append(')');
                    break;
                }
                default: {
                    throw new BadElementException("This type of barcode is not supported yet: " + type);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new BadElementException("NumberFormatException at position " + pos + " in " + number + ": " + nfe.getMessage());
        }
        return code.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static char convertInterleaved(int digits) throws NumberFormatException {
        void var1_1;
        int i;
        if (digits < 50) {
            i = 48;
        } else if (digits < 100) {
            i = 142;
        } else {
            throw new NumberFormatException(String.valueOf(digits));
        }
        return (char)(digits + var1_1);
    }

    private static String addZero(String number, int length) {
        StringBuffer buf = new StringBuffer();
        int zeros = length - number.length();
        int i = 0;
        while (i < zeros) {
            buf.append('0');
            ++i;
        }
        buf.append(number);
        return buf.toString();
    }
}

