/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.evolve.DeletedClassException;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistCatalog
implements Catalog {
    private static final byte[] DATA_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] BETA_MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    public static boolean expectNoClassChanges;
    public static boolean unevolvedFormatsEncountered;
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private volatile Map<String, Format> latestFormatMap;
    private Map<String, String> proxyClassMap;
    private boolean rawAccess;
    private EntityModel model;
    private Mutations mutations;
    private Database db;
    private int openCount;
    private Store store;
    private Evolver evolver;
    private Data catalogData;

    private static byte[] getIntBytes(int val) {
        DatabaseEntry entry = new DatabaseEntry();
        IntegerBinding.intToEntry(val, entry);
        assert (entry.getSize() == 4 && entry.getData().length == 4);
        return entry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistCatalog(Transaction txn, Environment env, String storePrefix, String dbName, DatabaseConfig dbConfig, EntityModel modelParam, Mutations mutationsParam, boolean rawAccess, Store store) throws DatabaseException {
        this.rawAccess = rawAccess;
        this.store = store;
        this.db = env.openDatabase(txn, dbName, dbConfig);
        this.openCount = 1;
        boolean success = false;
        try {
            boolean needWrite;
            boolean betaVersion;
            this.catalogData = this.readData(txn);
            this.mutations = this.catalogData.mutations;
            if (this.mutations == null) {
                this.mutations = new Mutations();
            }
            boolean forceWriteData = betaVersion = this.catalogData.version == -1;
            boolean disallowClassChanges = betaVersion;
            boolean forceEvolution = false;
            if (mutationsParam != null && !this.mutations.equals(mutationsParam)) {
                this.mutations = mutationsParam;
                forceWriteData = true;
                forceEvolution = true;
            }
            this.formatList = this.catalogData.formatList;
            if (this.formatList == null) {
                this.formatList = SimpleCatalog.copyFormatList();
                NonPersistentFormat format = new NonPersistentFormat(Object.class);
                format.setId(1);
                this.formatList.set(1, format);
                format = new NonPersistentFormat(Number.class);
                format.setId(22);
                this.formatList.set(22, format);
            } else if (SimpleCatalog.copyMissingFormats(this.formatList)) {
                forceWriteData = true;
            }
            if (betaVersion) {
                HashMap<String, Format> formatMap = new HashMap<String, Format>();
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    formatMap.put(format.getClassName(), format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.migrateFromBeta(formatMap);
                }
            }
            this.formatMap = new HashMap<String, Format>(this.formatList.size());
            this.latestFormatMap = new HashMap<String, Format>(this.formatList.size());
            if (rawAccess) {
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    String name = format.getClassName();
                    if (format.isCurrentVersion()) {
                        this.formatMap.put(name, format);
                    }
                    if (format != format.getLatestVersion()) continue;
                    this.latestFormatMap.put(name, format);
                }
                for (Format format : this.formatList) {
                    if (format == null) continue;
                    format.initializeIfNeeded(this);
                }
                this.model = new StoredModel(this);
                success = true;
                return;
            }
            this.model = modelParam != null ? modelParam : new AnnotationModel();
            for (int i = 0; i <= 30; ++i) {
                Format simpleFormat = this.formatList.get(i);
                if (simpleFormat == null) continue;
                this.formatMap.put(simpleFormat.getClassName(), simpleFormat);
            }
            ArrayList<String> knownClasses = new ArrayList<String>(this.model.getKnownClasses());
            this.addPredefinedProxies(knownClasses);
            this.proxyClassMap = new HashMap<String, String>();
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                String oldName = oldFormat.getClassName();
                Renamer renamer = this.mutations.getRenamer(oldName, oldFormat.getVersion(), null);
                String newName = renamer != null ? renamer.getNewName() : oldName;
                this.addProxiedClass(newName);
            }
            for (String className : knownClasses) {
                this.addProxiedClass(className);
            }
            HashMap<String, Format> newFormats = new HashMap<String, Format>();
            for (String className : knownClasses) {
                this.createFormat(className, newFormats);
            }
            this.evolver = new Evolver(this, storePrefix, this.mutations, newFormats, forceEvolution, disallowClassChanges);
            for (Format oldFormat : this.formatList) {
                if (oldFormat == null || Format.isPredefined(oldFormat)) continue;
                if (oldFormat.isEntity()) {
                    this.evolver.evolveFormat(oldFormat);
                    continue;
                }
                this.evolver.addNonEntityFormat(oldFormat);
            }
            this.evolver.finishEvolution();
            String errors = this.evolver.getErrors();
            if (errors != null) {
                throw new IncompatibleClassException(errors);
            }
            for (Format newFormat : newFormats.values()) {
                this.addFormat(newFormat);
            }
            for (Format format : this.formatList) {
                if (format == null) continue;
                format.initializeIfNeeded(this);
                if (format != format.getLatestVersion()) continue;
                this.latestFormatMap.put(format.getClassName(), format);
            }
            boolean bl = needWrite = newFormats.size() > 0 || this.evolver.areFormatsChanged();
            if (expectNoClassChanges && needWrite) {
                throw new IllegalStateException("Unexpected changes  newFormats.size=" + newFormats.size() + " areFormatsChanged=" + this.evolver.areFormatsChanged());
            }
            if ((needWrite || forceWriteData) && !this.db.getConfig().getReadOnly()) {
                this.evolver.renameAndRemoveDatabases(env, txn);
                this.catalogData.formatList = this.formatList;
                this.catalogData.mutations = this.mutations;
                this.writeData(txn, this.catalogData);
            } else if (forceWriteData) {
                throw new IllegalArgumentException("When an upgrade is required the store may not be opened read-only");
            }
            success = true;
        }
        finally {
            this.proxyClassMap = null;
            this.catalogData = null;
            this.evolver = null;
            if (!success) {
                this.close();
            }
        }
    }

    public void getEntityFormats(Collection<Format> entityFormats) {
        for (Format format : this.formatMap.values()) {
            if (!format.isEntity()) continue;
            entityFormats.add(format);
        }
    }

    private void addProxiedClass(String className) {
        String proxiedClassName;
        ClassMetadata metadata = this.model.getClassMetadata(className);
        if (metadata != null && (proxiedClassName = metadata.getProxiedClassName()) != null) {
            this.proxyClassMap.put(proxiedClassName, className);
        }
    }

    private void addPredefinedProxies(List<String> knownClasses) {
        knownClasses.add(CollectionProxy.ArrayListProxy.class.getName());
        knownClasses.add(CollectionProxy.LinkedListProxy.class.getName());
        knownClasses.add(CollectionProxy.HashSetProxy.class.getName());
        knownClasses.add(CollectionProxy.TreeSetProxy.class.getName());
        knownClasses.add(MapProxy.HashMapProxy.class.getName());
        knownClasses.add(MapProxy.TreeMapProxy.class.getName());
    }

    Map<Format, Set<Format>> getSubclassMap() {
        HashMap<Format, Set<Format>> subclassMap = new HashMap<Format, Set<Format>>();
        for (Format format : this.formatList) {
            Format superFormat;
            if (format == null || Format.isPredefined(format) || (superFormat = format.getSuperFormat()) == null) continue;
            HashSet<Format> subclass = (HashSet<Format>)subclassMap.get(superFormat);
            if (subclass == null) {
                subclass = new HashSet<Format>();
                subclassMap.put(superFormat, subclass);
            }
            subclass.add(format);
        }
        return subclassMap;
    }

    public EntityModel getResolvedModel() {
        return this.model;
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw new IllegalStateException("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            Database dbToClose = this.db;
            this.db = null;
            dbToClose.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        Class type;
        try {
            type = SimpleCatalog.classForName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class does not exist: " + clsName);
        }
        return this.createFormat(type, newFormats);
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        String className = type.getName();
        Format format = newFormats.get(className);
        if (format != null) {
            return format;
        }
        format = this.formatMap.get(className);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(type)) : className;
        String proxyClassName = null;
        if (this.proxyClassMap != null) {
            proxyClassName = this.proxyClassMap.get(className);
        }
        if (proxyClassName != null) {
            format = new ProxiedFormat(type, proxyClassName);
        } else if (type.isArray()) {
            format = type.getComponentType().isPrimitive() ? new PrimitiveArrayFormat(type) : new ObjectArrayFormat(type);
        } else if (type.isEnum()) {
            format = new EnumFormat(type);
        } else if (type == Object.class || type.isInterface()) {
            format = new NonPersistentFormat(type);
        } else {
            ClassMetadata metadata = this.model.getClassMetadata(className);
            if (metadata == null) {
                throw new IllegalArgumentException("Class could not be loaded or is not persistent: " + className);
            }
            if (metadata.getCompositeKeyFields() != null && (metadata.getPrimaryKey() != null || metadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + type.getName());
            }
            try {
                type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor: " + type.getName(), e);
            }
            if (metadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat(type, metadata, metadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(className);
                format = new ComplexFormat(type, metadata, entityMetadata);
            }
        }
        newFormats.put(className, format);
        format.collectRelatedFormats(this, newFormats);
        return format;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    void useExistingFormat(Format oldFormat) {
        assert (oldFormat.isCurrentVersion());
        this.formatMap.put(oldFormat.getClassName(), oldFormat);
    }

    Set<String> getModelClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            classes.add(format.getClassName());
        }
        return classes;
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        if (this.catalogData == null || this.catalogData.formatList == null || format.getId() >= this.catalogData.formatList.size()) {
            return 1;
        }
        assert (this.catalogData != null);
        if (forReader) {
            return this.evolver != null && this.evolver.isFormatChanged(format) ? 1 : this.catalogData.version;
        }
        return this.catalogData.version;
    }

    @Override
    public Format getFormat(int formatId) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw new DeletedClassException("Format does not exist: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw new DeletedClassException("Format does not exist: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            if (this.model != null) {
                Format entityFormat;
                format = this.addNewFormat(cls);
                if (this.store != null && (entityFormat = format.getEntityFormat()) != null && entityFormat != format) {
                    try {
                        this.store.openSecondaryIndexes(null, entityFormat.getEntityMetadata(), null);
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeExceptionWrapper(e);
                    }
                }
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    public Format getLatestVersion(String className) {
        return this.latestFormatMap.get(className);
    }

    private synchronized Format addNewFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format != null) {
            return format;
        }
        ArrayList<Format> newFormatList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> newFormatMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> newLatestFormatMap = new HashMap<String, Format>(this.latestFormatMap);
        HashMap<String, Format> newFormats = new HashMap<String, Format>();
        format = this.createFormat(cls, newFormats);
        for (Format newFormat : newFormats.values()) {
            this.addFormat(newFormat, newFormatList, newFormatMap);
        }
        ReadOnlyCatalog newFormatCatalog = new ReadOnlyCatalog(newFormatList, newFormatMap);
        for (Format newFormat : newFormats.values()) {
            newFormat.initializeIfNeeded(newFormatCatalog);
            newLatestFormatMap.put(newFormat.getClassName(), newFormat);
        }
        try {
            Data catalogData = new Data();
            catalogData.formatList = newFormatList;
            catalogData.mutations = this.mutations;
            this.writeData(null, catalogData);
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        this.formatList = newFormatList;
        this.formatMap = newFormatMap;
        this.latestFormatMap = newLatestFormatMap;
        return format;
    }

    public synchronized void flush() throws DatabaseException {
        Data catalogData = new Data();
        catalogData.formatList = this.formatList;
        catalogData.mutations = this.mutations;
        this.writeData(null, catalogData);
    }

    private Data readData(Transaction txn) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.db.get(txn, key, data, null);
        if (status == OperationStatus.SUCCESS) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize());
            try {
                Data catalogData;
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object object = ois.readObject();
                assert (ois.available() == 0);
                if (object instanceof Data) {
                    catalogData = (Data)object;
                } else {
                    if (!(object instanceof List)) {
                        throw new IllegalStateException(object.getClass().getName());
                    }
                    catalogData = new Data();
                    catalogData.formatList = (List)object;
                    catalogData.version = -1;
                }
                return catalogData;
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
        }
        Data catalogData = new Data();
        catalogData.version = 1;
        return catalogData;
    }

    private void writeData(Transaction txn, Data catalogData) throws DatabaseException {
        boolean wasBetaVersion = catalogData.version == -1;
        catalogData.version = 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(catalogData);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry(baos.toByteArray());
        this.db.put(txn, key, data);
        if (wasBetaVersion) {
            key.setData(BETA_MUTATIONS_KEY);
            this.db.delete(txn, key);
        }
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        String className;
        Format format = (Format)o.getType();
        if (this != format.getCatalog() && (format = this.getFormat(className = format.getClassName())) == null) {
            throw new IllegalArgumentException("External raw type not found: " + className);
        }
        Format proxiedFormat = format.getProxiedFormat();
        if (proxiedFormat != null) {
            format = proxiedFormat;
        }
        if (converted == null) {
            converted = new IdentityHashMap();
        }
        return format.convertRawObject(this, false, o, converted);
    }

    public void dump() {
        System.out.println("--- Begin formats ---");
        for (Format format : this.formatList) {
            if (format == null) continue;
            System.out.println("ID: " + format.getId() + " class: " + format.getClassName() + " version: " + format.getVersion() + " current: " + (format == this.formatMap.get(format.getClassName())));
        }
        System.out.println("--- End formats ---");
    }

    private static class Data
    implements Serializable {
        static final long serialVersionUID = 7515058069137413261L;
        List<Format> formatList;
        Mutations mutations;
        int version;

        private Data() {
        }
    }
}

