/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class MovieClip
extends Symbol
implements TimeLine {
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected int depth = 1;

    public int getFrameCount() {
        return this.frameCount;
    }

    public Frame getFrame(int n) {
        if (n < 1) {
            return null;
        }
        Integer n2 = new Integer(n);
        Frame frame = (Frame)this.frames.get(n2);
        if (frame == null) {
            frame = new Frame(n, this);
            this.frames.put(n2, frame);
            if (n > this.frameCount) {
                this.frameCount = n;
            }
        }
        return frame;
    }

    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public Frame appendFrame(Frame frame) {
        ++this.frameCount;
        frame.timeline = this;
        frame.frameNumber = this.frameCount;
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public int getAvailableDepth() {
        return this.depth;
    }

    public void setAvailableDepth(int n) {
        if (n < 1) {
            return;
        }
        this.depth = n;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        Object object;
        Iterator iterator = this.frames.values().iterator();
        while (iterator.hasNext()) {
            object = (Frame)iterator.next();
            ((Frame)object).flushDefinitions(movie, sWFTagTypes, sWFTagTypes2);
        }
        int n = this.getNextId(movie);
        object = sWFTagTypes2.tagDefineSprite(n);
        int n2 = 0;
        Iterator iterator2 = this.frames.values().iterator();
        while (iterator2.hasNext()) {
            Frame frame = (Frame)iterator2.next();
            int n3 = frame.getFrameNumber();
            while (n3 > n2 + 1) {
                object.tagShowFrame();
                ++n2;
            }
            frame.write(movie, sWFTagTypes2, (SWFTagTypes)object);
            n2 = n3;
        }
        object.tagEnd();
        return n;
    }
}

