/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ActionWriter
implements SWFActions,
SWFActionCodes {
    protected TagWriter tagWriter;
    protected OutStream out;
    protected ByteArrayOutputStream bout;
    protected int count;
    protected int flashVersion;
    protected String mStringEncoding;
    protected Vector pushValues;
    protected Hashtable labels;
    protected Vector jumps;
    protected Vector skips;
    protected Vector blocks;
    protected Stack blockStack;

    public ActionWriter(TagWriter tagWriter, int n) {
        this.flashVersion = n;
        this.tagWriter = tagWriter;
        this.mStringEncoding = n >= 6 ? "UTF-8" : "US-ASCII";
    }

    protected int writeCode(int n) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        this.out.writeUI8(n);
        ++this.count;
        return this.count;
    }

    public void start(int n) throws IOException {
        this.count = 0;
        this.bout = new ByteArrayOutputStream();
        this.out = new OutStream(this.bout);
        this.pushValues = new Vector();
        this.labels = null;
        this.jumps = null;
        this.skips = null;
        this.blocks = null;
        this.blockStack = null;
    }

    public void end() throws IOException {
        this.writeCode(0);
        this.out.flush();
        byte[] byArray = this.bout.toByteArray();
        if (this.labels != null) {
            if (this.jumps != null) {
                this.fixupJumps(byArray);
            }
            if (this.skips != null) {
                this.fixupSkips(byArray);
            }
        }
        if (this.blocks != null) {
            this.fixupBlocks(byArray);
        }
        this.writeBytes(byArray);
    }

    public void blob(byte[] byArray) throws IOException {
        this.writeBytes(byArray);
    }

    protected void writeBytes(byte[] byArray) throws IOException {
        this.tagWriter.getOutStream().write(byArray);
    }

    public void done() throws IOException {
        this.tagWriter.completeTag();
    }

    protected void fixupBlocks(byte[] byArray) {
        Enumeration enumeration = this.blocks.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            int n = nArray[1];
            int n2 = nArray[0];
            byte[] byArray2 = OutStream.sintTo2Bytes(n);
            byArray[n2] = byArray2[0];
            byArray[n2 + 1] = byArray2[1];
        }
    }

    protected void fixupJumps(byte[] byArray) {
        Enumeration enumeration = this.jumps.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            String string = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            int[] nArray = (int[])this.labels.get(string);
            if (nArray == null) {
                System.out.println("Missing label '" + string + "' in action code");
                continue;
            }
            int n2 = nArray[0];
            int n3 = n2 - (n + 2);
            byte[] byArray2 = OutStream.sintTo2Bytes(n3);
            byArray[n] = byArray2[0];
            byArray[n + 1] = byArray2[1];
        }
    }

    protected void fixupSkips(byte[] byArray) {
        Enumeration enumeration = this.skips.elements();
        while (enumeration.hasMoreElements()) {
            byte by;
            Object[] objectArray = (Object[])enumeration.nextElement();
            String string = (String)objectArray[0];
            int[] nArray = (int[])objectArray[1];
            int n = nArray[0];
            int n2 = nArray[1];
            int[] nArray2 = (int[])this.labels.get(string);
            if (nArray2 == null) {
                System.out.println("Missing label '" + string + "' in action code");
                continue;
            }
            int n3 = nArray2[1];
            int n4 = n3 - n - 1;
            byArray[n2] = by = OutStream.uintToByte(n4);
        }
    }

    public void comment(String string) throws IOException {
    }

    public void unknown(int n, byte[] byArray) throws IOException {
        int n2;
        this.writeCode(n);
        int n3 = n2 = byArray != null ? byArray.length : 0;
        if (n >= 128 || n2 > 0) {
            this.out.writeUI16(n2);
        }
        if (n2 > 0) {
            this.out.write(byArray);
        }
    }

    public void initArray() throws IOException {
        this.writeCode(66);
    }

    public void jumpLabel(String string) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        int n = this.out.getCount();
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        this.labels.put(string, new int[]{n, this.count + 1});
    }

    public void gotoFrame(int n) throws IOException {
        this.writeCode(129);
        this.out.writeUI16(2);
        this.out.writeUI16(n);
    }

    public void gotoFrame(String string) throws IOException {
        this.writeCode(140);
        this.out.writeUI16(OutStream.getStringLength(string));
        this.out.writeString(string, this.mStringEncoding);
    }

    public void getURL(String string, String string2) throws IOException {
        this.writeCode(131);
        this.out.writeUI16(OutStream.getStringLength(string) + OutStream.getStringLength(string2));
        this.out.writeString(string, this.mStringEncoding);
        this.out.writeString(string2, this.mStringEncoding);
    }

    public void nextFrame() throws IOException {
        this.writeCode(4);
    }

    public void prevFrame() throws IOException {
        this.writeCode(5);
    }

    public void play() throws IOException {
        this.writeCode(6);
    }

    public void stop() throws IOException {
        this.writeCode(7);
    }

    public void toggleQuality() throws IOException {
        this.writeCode(8);
    }

    public void stopSounds() throws IOException {
        this.writeCode(9);
    }

    public void setTarget(String string) throws IOException {
        this.writeCode(139);
        this.out.writeUI16(OutStream.getStringLength(string));
        this.out.writeString(string, this.mStringEncoding);
    }

    protected void writeJump(String string, int n) throws IOException {
        this.writeCode(n);
        this.out.writeUI16(2);
        int n2 = this.out.getCount();
        this.out.writeUI16(0);
        if (this.jumps == null) {
            this.jumps = new Vector();
        }
        this.jumps.addElement(new Object[]{string, new Integer(n2)});
    }

    public void jump(String string) throws IOException {
        this.writeJump(string, 153);
    }

    public void ifJump(String string) throws IOException {
        this.writeJump(string, 157);
    }

    public void waitForFrame(int n, String string) throws IOException {
        this.writeCode(138);
        this.out.writeUI16(3);
        this.out.writeUI16(n);
        int n2 = this.out.getCount();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.addElement(new Object[]{string, new int[]{this.count, n2}});
    }

    public void waitForFrame(String string) throws IOException {
        this.writeCode(141);
        this.out.writeUI16(1);
        int n = this.out.getCount();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.addElement(new Object[]{string, new int[]{this.count, n}});
    }

    public void pop() throws IOException {
        this.writeCode(23);
    }

    public void add() throws IOException {
        this.writeCode(10);
    }

    public void substract() throws IOException {
        this.writeCode(11);
    }

    public void multiply() throws IOException {
        this.writeCode(12);
    }

    public void divide() throws IOException {
        this.writeCode(13);
    }

    public void equals() throws IOException {
        this.writeCode(14);
    }

    public void lessThan() throws IOException {
        this.writeCode(15);
    }

    public void and() throws IOException {
        this.writeCode(16);
    }

    public void or() throws IOException {
        this.writeCode(17);
    }

    public void not() throws IOException {
        this.writeCode(18);
    }

    public void stringEquals() throws IOException {
        this.writeCode(19);
    }

    public void stringLength() throws IOException {
        this.writeCode(20);
    }

    public void concat() throws IOException {
        this.writeCode(33);
    }

    public void substring() throws IOException {
        this.writeCode(21);
    }

    public void stringLessThan() throws IOException {
        this.writeCode(41);
    }

    public void stringLengthMB() throws IOException {
        this.writeCode(49);
    }

    public void substringMB() throws IOException {
        this.writeCode(53);
    }

    public void toInteger() throws IOException {
        this.writeCode(24);
    }

    public void charToAscii() throws IOException {
        this.writeCode(50);
    }

    public void asciiToChar() throws IOException {
        this.writeCode(51);
    }

    public void charMBToAscii() throws IOException {
        this.writeCode(54);
    }

    public void asciiToCharMB() throws IOException {
        this.writeCode(55);
    }

    public void call() throws IOException {
        this.writeCode(158);
        this.out.writeUI16(0);
    }

    public void getVariable() throws IOException {
        this.writeCode(28);
    }

    public void setVariable() throws IOException {
        this.writeCode(29);
    }

    public void getURL(int n, int n2) throws IOException {
        this.writeCode(154);
        this.out.writeUI16(1);
        int n3 = 0;
        Object var4_4 = null;
        switch (n) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object var5_5 = null;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n3 |= 0x40;
                break;
            }
            case 3: {
                n3 |= 0x80;
                break;
            }
            case 4: {
                n3 |= 0xC0;
                break;
            }
        }
        this.out.writeUI8(n3);
    }

    public void gotoFrame(boolean bl) throws IOException {
        this.writeCode(159);
        this.out.writeUI16(1);
        this.out.writeUI8(bl ? 1 : 0);
    }

    public void setTarget() throws IOException {
        this.writeCode(32);
    }

    public void getProperty() throws IOException {
        this.writeCode(34);
    }

    public void setProperty() throws IOException {
        this.writeCode(35);
    }

    public void cloneSprite() throws IOException {
        this.writeCode(36);
    }

    public void removeSprite() throws IOException {
        this.writeCode(37);
    }

    public void startDrag() throws IOException {
        this.writeCode(39);
    }

    public void endDrag() throws IOException {
        this.writeCode(40);
    }

    public void trace() throws IOException {
        this.writeCode(38);
    }

    public void getTime() throws IOException {
        this.writeCode(52);
    }

    public void randomNumber() throws IOException {
        this.writeCode(48);
    }

    public void lookupTable(String[] stringArray) throws IOException {
        this.writeCode(136);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        outStream.writeUI16(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            outStream.writeString(stringArray[i], this.mStringEncoding);
        }
        outStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.out.writeUI16(byArray.length);
        this.out.write(byArray);
    }

    public void callFunction() throws IOException {
        this.writeCode(61);
    }

    public void callMethod() throws IOException {
        this.writeCode(82);
    }

    public void startFunction(String string, String[] stringArray) throws IOException {
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        this.writeCode(155);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        outStream.writeString(string, this.mStringEncoding);
        outStream.writeUI16(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            outStream.writeString(stringArray[i], this.mStringEncoding);
        }
        outStream.writeUI16(0);
        outStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.out.writeUI16(byArray.length);
        this.out.write(byArray);
        this.blockStack.push(new int[]{this.out.getCount(), 0});
    }

    public void endBlock() throws IOException {
        if (this.blockStack == null || this.blockStack.isEmpty()) {
            return;
        }
        int[] nArray = (int[])this.blockStack.pop();
        if (this.blocks == null) {
            this.blocks = new Vector();
        }
        int n = nArray[0];
        int n2 = this.out.getCount() - n;
        nArray[0] = n - 2;
        nArray[1] = n2;
        this.blocks.addElement(nArray);
    }

    public void defineLocalValue() throws IOException {
        this.writeCode(60);
    }

    public void defineLocal() throws IOException {
        this.writeCode(65);
    }

    public void deleteProperty() throws IOException {
        this.writeCode(58);
    }

    public void deleteThreadVars() throws IOException {
        this.writeCode(59);
    }

    public void enumerate() throws IOException {
        this.writeCode(70);
    }

    public void typedEquals() throws IOException {
        this.writeCode(73);
    }

    public void getMember() throws IOException {
        this.writeCode(78);
    }

    public void initObject() throws IOException {
        this.writeCode(67);
    }

    public void newMethod() throws IOException {
        this.writeCode(83);
    }

    public void newObject() throws IOException {
        this.writeCode(64);
    }

    public void setMember() throws IOException {
        this.writeCode(79);
    }

    public void getTargetPath() throws IOException {
        this.writeCode(69);
    }

    public void startWith() throws IOException {
        this.writeCode(148);
        this.out.writeUI16(2);
        this.out.writeUI16(0);
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        this.blockStack.push(new int[]{this.out.getCount(), 0});
    }

    public void duplicate() throws IOException {
        this.writeCode(76);
    }

    public void returnValue() throws IOException {
        this.writeCode(62);
    }

    public void swap() throws IOException {
        this.writeCode(77);
    }

    public void storeInRegister(int n) throws IOException {
        this.writeCode(135);
        this.out.writeUI16(1);
        this.out.writeUI8(n);
    }

    public void convertToNumber() throws IOException {
        this.writeCode(74);
    }

    public void convertToString() throws IOException {
        this.writeCode(75);
    }

    public void typeOf() throws IOException {
        this.writeCode(68);
    }

    public void typedAdd() throws IOException {
        this.writeCode(71);
    }

    public void typedLessThan() throws IOException {
        this.writeCode(72);
    }

    public void modulo() throws IOException {
        this.writeCode(63);
    }

    public void bitAnd() throws IOException {
        this.writeCode(96);
    }

    public void bitOr() throws IOException {
        this.writeCode(97);
    }

    public void bitXor() throws IOException {
        this.writeCode(98);
    }

    public void shiftLeft() throws IOException {
        this.writeCode(99);
    }

    public void shiftRight() throws IOException {
        this.writeCode(100);
    }

    public void shiftRightUnsigned() throws IOException {
        this.writeCode(101);
    }

    public void decrement() throws IOException {
        this.writeCode(81);
    }

    public void increment() throws IOException {
        this.writeCode(80);
    }

    protected void flushPushValues() throws IOException {
        this.out.writeUI8(150);
        ++this.count;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutStream outStream = new OutStream(byteArrayOutputStream);
        Object object = this.pushValues.elements();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (e instanceof String) {
                outStream.writeUI8(0);
                outStream.writeString(e.toString(), this.mStringEncoding);
                continue;
            }
            if (e instanceof Boolean) {
                outStream.writeUI8(5);
                outStream.writeUI8((Boolean)e != false ? 1 : 0);
                continue;
            }
            if (e instanceof Integer) {
                outStream.writeUI8(7);
                outStream.writeSI32((Integer)e);
                continue;
            }
            if (e instanceof Short) {
                outStream.writeUI8(8);
                outStream.writeUI8(((Short)e).intValue());
                continue;
            }
            if (e instanceof Byte) {
                outStream.writeUI8(4);
                outStream.writeUI8(((Byte)e).intValue());
                continue;
            }
            if (e instanceof Float) {
                outStream.writeUI8(1);
                outStream.writeFloat(((Float)e).floatValue());
                continue;
            }
            if (e instanceof Double) {
                outStream.writeUI8(6);
                outStream.writeDouble((Double)e);
                continue;
            }
            outStream.writeUI8(2);
        }
        this.pushValues.removeAllElements();
        outStream.flush();
        object = byteArrayOutputStream.toByteArray();
        this.out.writeUI16(((Object)object).length);
        this.out.write((byte[])object);
    }

    public void push(String string) throws IOException {
        this.pushValues.addElement(string);
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(float f) throws IOException {
        this.pushValues.addElement(new Float(f));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(double d) throws IOException {
        this.pushValues.addElement(new Double(d));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void pushNull() throws IOException {
        this.pushValues.addElement(new Object());
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void pushRegister(int n) throws IOException {
        this.pushValues.addElement(new Byte((byte)n));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(boolean bl) throws IOException {
        this.pushValues.addElement(new Boolean(bl));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(int n) throws IOException {
        this.pushValues.addElement(new Integer(n));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void lookup(int n) throws IOException {
        this.pushValues.addElement(new Short((short)n));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void enumerateObject() throws IOException {
        this.writeCode(85);
    }

    public void greaterThan() throws IOException {
        this.writeCode(103);
    }

    public void instanceOf() throws IOException {
        this.writeCode(84);
    }

    public void strictEquals() throws IOException {
        this.writeCode(102);
    }

    public void stringGreaterThan() throws IOException {
        this.writeCode(104);
    }
}

