/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import java.util.Vector;
import org.jets3t.service.multithread.CancelEventTrigger;

public class ThreadWatcher {
    private static final int MIN_TRANSFER_UPDATES_FOR_RATE = 20;
    private long completedThreads = 0L;
    private long threadCount = 0L;
    private CancelEventTrigger cancelEventListener = null;
    private long watcherStartTimeMS = -1L;
    private long bytesTransferred = -1L;
    private long bytesTotal = -1L;
    private long bytesPerSecond = -1L;
    private long timeRemainingSeconds = -1L;
    private int bytesUpdateCount = 0;
    private Vector historicBytesTransferredQueue = new Vector();
    private Vector historicTimeQueue = new Vector();

    protected ThreadWatcher() {
        this.watcherStartTimeMS = System.currentTimeMillis();
    }

    protected void setThreadsCompletedRatio(long completedThreads, long threadCount) {
        this.setThreadsCompletedRatio(completedThreads, threadCount, null);
    }

    protected void setThreadsCompletedRatio(long completedThreads, long threadCount, CancelEventTrigger cancelEventListener) {
        this.completedThreads = completedThreads;
        this.threadCount = threadCount;
        this.cancelEventListener = cancelEventListener;
    }

    protected void setBytesTransferredInfo(long bytesTransferred, long bytesTotal) {
        long now = System.currentTimeMillis();
        this.bytesTotal = bytesTotal;
        this.bytesTransferred = bytesTransferred;
        this.historicTimeQueue.add(new Long(now));
        this.historicBytesTransferredQueue.add(new Long(bytesTransferred));
        ++this.bytesUpdateCount;
        if (this.bytesUpdateCount > 20) {
            Long historicByteTransferCount = (Long)this.historicBytesTransferredQueue.firstElement();
            this.historicBytesTransferredQueue.remove(0);
            Long historicTime = (Long)this.historicTimeQueue.firstElement();
            this.historicTimeQueue.remove(0);
            long intervalsElapsedTimeMS = now - historicTime;
            long intervalsBytesTransferred = bytesTransferred - historicByteTransferCount;
            long bytesRemaining = bytesTotal - bytesTransferred;
            if (intervalsElapsedTimeMS > 0L) {
                this.bytesPerSecond = 1000L * intervalsBytesTransferred / intervalsElapsedTimeMS;
            }
            long overallElapsedTimeMS = System.currentTimeMillis() - this.watcherStartTimeMS;
            long overallBytesPerSecond = -1L;
            if (overallElapsedTimeMS > 0L) {
                overallBytesPerSecond = 1000L * bytesTransferred / overallElapsedTimeMS;
            }
            if (bytesRemaining > 0L && overallBytesPerSecond > 0L) {
                double remainingSecsDouble = (double)bytesRemaining / (double)overallBytesPerSecond;
                this.timeRemainingSeconds = Math.round(remainingSecsDouble);
            } else {
                this.timeRemainingSeconds = 0L;
            }
        }
    }

    public long getCompletedThreads() {
        return this.completedThreads;
    }

    public long getThreadCount() {
        return this.threadCount;
    }

    public boolean isBytesTransferredInfoAvailable() {
        return this.bytesTotal >= 0L && this.bytesTransferred >= 0L;
    }

    public long getBytesTotal() throws IllegalStateException {
        if (!this.isBytesTransferredInfoAvailable()) {
            throw new IllegalStateException("Bytes Transferred Info is not available in this object");
        }
        return this.bytesTotal;
    }

    public long getBytesTransferred() {
        if (!this.isBytesTransferredInfoAvailable()) {
            throw new IllegalStateException("Bytes Transferred Info is not available in this object");
        }
        return this.bytesTransferred;
    }

    public boolean isBytesPerSecondAvailable() {
        return this.bytesPerSecond >= 0L;
    }

    public long getBytesPerSecond() {
        if (!this.isBytesPerSecondAvailable()) {
            throw new IllegalStateException("Bytes per-second estimate is not available in this object");
        }
        return this.bytesPerSecond;
    }

    public boolean isTimeRemainingAvailable() {
        return this.timeRemainingSeconds >= 0L;
    }

    public long getTimeRemaining() {
        if (!this.isTimeRemainingAvailable()) {
            throw new IllegalStateException("Time remaining estimate is not available in this object");
        }
        return this.timeRemainingSeconds;
    }

    public boolean isCancelTaskSupported() {
        return this.cancelEventListener != null;
    }

    public void cancelTask() {
        if (this.isCancelTaskSupported()) {
            this.cancelEventListener.cancelTask(this);
        }
    }

    public CancelEventTrigger getCancelEventListener() {
        return this.cancelEventListener;
    }
}

