/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.MultipleInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CSVDocumentCollection
implements DocumentSequence,
Serializable {
    private final String fileName;
    private final String separator;
    private final String[] column;
    private final int titleColumn;
    private final DocumentFactory factory;
    private transient BufferedReader reader;
    private transient int readLines;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
        this.readLines = -1;
    }

    public DocumentIterator iterator() {
        return new AbstractDocumentIterator(){
            final Reference2ObjectOpenHashMap metadata;

            public final Document nextDocument() throws IOException {
                String line = CSVDocumentCollection.this.reader.readLine();
                if (line == null) {
                    return null;
                }
                CSVDocumentCollection cSVDocumentCollection = CSVDocumentCollection.this;
                cSVDocumentCollection.readLines = cSVDocumentCollection.readLines + 1;
                String[] field = line.split(CSVDocumentCollection.this.separator);
                if (field.length != CSVDocumentCollection.this.column.length) {
                    throw new IOException("Line " + CSVDocumentCollection.this.readLines + " has less (" + field.length + ") fields than the number of columns (" + CSVDocumentCollection.this.column.length + ").");
                }
                InputStream[] a = new InputStream[CSVDocumentCollection.this.column.length];
                int i = 0;
                while (i < CSVDocumentCollection.this.column.length) {
                    a[i] = new ByteArrayInputStream(field[i].getBytes());
                    ++i;
                }
                String title = CSVDocumentCollection.this.titleColumn >= 0 ? field[CSVDocumentCollection.this.titleColumn] : Integer.toString(CSVDocumentCollection.this.readLines);
                this.metadata.put((Object)"title", (Object)title);
                this.metadata.put((Object)"uri", (Object)Integer.toString(CSVDocumentCollection.this.readLines));
                return CSVDocumentCollection.this.factory.getDocument(MultipleInputStream.getStream(a), (Reference2ObjectMap)this.metadata);
            }

            public final void close() {
            }

            private final /* synthetic */ void this() {
                this.metadata = new Reference2ObjectOpenHashMap();
            }
            {
                this.this();
            }
        };
    }

    public DocumentFactory factory() {
        return this.factory;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public static void main(String[] arg) throws JSAPException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, FileNotFoundException, IOException, IllegalArgumentException, SecurityException, InstantiationException {
        Class clazz = class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$JdbcDocumentCollection = CSVDocumentCollection.class("[Lit.unimi.dsi.mg4j.document.JdbcDocumentCollection;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[7];
        parameterArray[0] = new FlaggedOption("separator", (StringParser)JSAP.STRING_PARSER, ",", false, 's', "separator", "The regexp used to split lines into fields.");
        Class clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory = CSVDocumentCollection.class("[Lit.unimi.dsi.mg4j.document.IdentityDocumentFactory;", false);
        }
        parameterArray[1] = new FlaggedOption("factory", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'f', "factory", "A document factory with a standard constructor.");
        parameterArray[2] = new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true);
        parameterArray[3] = new FlaggedOption("titleColumn", (StringParser)JSAP.INTEGER_PARSER, "-1", false, 't', "title-column", "The index of the column to be used as a title (starting from 0).");
        parameterArray[4] = new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection.");
        parameterArray[5] = new UnflaggedOption("fileName", (StringParser)JSAP.STRING_PARSER, true, "The filename of the source CSV file.");
        parameterArray[6] = new UnflaggedOption("column", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "Columns names that will be indexed.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Saves a serialised document collection based on a set of database rows.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int titleColumn = jsapResult.getInt("titleColumn");
        String collection = jsapResult.getString("collection");
        String fileName = jsapResult.getString("fileName");
        String separator = jsapResult.getString("separator").equals("\\t") ? "\t" : jsapResult.getString("separator");
        String[] column = jsapResult.getStringArray("column");
        DocumentFactory[] factory = new DocumentFactory[column.length];
        int i = 0;
        while (i < factory.length) {
            factory[i] = PropertyBasedDocumentFactory.getInstance(jsapResult.getClass("factory"), jsapResult.getStringArray("property"));
            ++i;
        }
        BinIO.storeObject((Object)new CSVDocumentCollection(fileName, separator, column, titleColumn, CompositeDocumentFactory.getFactory(factory, column)), (CharSequence)collection);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public CSVDocumentCollection(String fileName, String separator, String[] column, int titleColumn, DocumentFactory factory) throws FileNotFoundException {
        this.fileName = fileName;
        this.separator = separator;
        this.column = column;
        if (titleColumn >= column.length) {
            throw new IllegalArgumentException("The title column (" + titleColumn + ") is larger than or equal to the number of columns (" + column.length + ')');
        }
        this.titleColumn = titleColumn;
        this.factory = factory;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        this.readLines = -1;
    }
}

