/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.commons.configuration.ConfigurationException;

public class IdentityDocumentFactory
extends PropertyBasedDocumentFactory {
    public static final String FIELDNAME = "fieldname";
    private String fieldName;
    private WordReader wordReader;

    protected boolean parseProperty(String key, String[] values, Reference2ObjectMap metadata) throws ConfigurationException {
        if (key.equals("encoding")) {
            metadata.put((Object)"encoding", (Object)Charset.forName(IdentityDocumentFactory.ensureJustOne(key, values)).toString());
            return true;
        }
        if (key.equals(FIELDNAME)) {
            this.fieldName = IdentityDocumentFactory.ensureJustOne(key, values).toString();
            return true;
        }
        return super.parseProperty(key, values, metadata);
    }

    private final void init() {
        if (this.fieldName == null) {
            this.fieldName = "text";
        }
        this.wordReader = new FastBufferedReader();
    }

    public int numberOfFields() {
        return 1;
    }

    public String fieldName(int field) {
        this.ensureFieldIndex(field);
        return this.fieldName;
    }

    public int fieldIndex(String fieldName) {
        return fieldName.equals(this.fieldName) + -1;
    }

    public int fieldType(int field) {
        this.ensureFieldIndex(field);
        return 0;
    }

    public Document getDocument(final InputStream rawContent, final Reference2ObjectMap metadata) {
        return new Document(){

            public final CharSequence title() {
                return (CharSequence)IdentityDocumentFactory.this.resolve("title", metadata);
            }

            public final String toString() {
                return this.title().toString();
            }

            public final CharSequence uri() {
                return (CharSequence)IdentityDocumentFactory.this.resolve("uri", metadata);
            }

            public final Object content(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                try {
                    return new InputStreamReader(rawContent, (String)IdentityDocumentFactory.this.resolveNotNull("encoding", metadata));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            public final WordReader wordReader(int field) {
                IdentityDocumentFactory.this.ensureFieldIndex(field);
                return IdentityDocumentFactory.this.wordReader;
            }

            public final void close() throws IOException {
                rawContent.close();
            }
        };
    }

    public IdentityDocumentFactory() {
        this.wordReader = new FastBufferedReader();
    }

    public IdentityDocumentFactory(Reference2ObjectMap defaultMetadata) {
        super(defaultMetadata);
        this.init();
    }

    public IdentityDocumentFactory(Properties properties) throws ConfigurationException {
        super(properties);
        this.init();
    }

    public IdentityDocumentFactory(String[] property) throws ConfigurationException {
        super(property);
        this.init();
    }
}

