/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final Logger LOGGER;
    private static final boolean DEBUG = false;
    private final String zipFilename;
    private transient ZipFile zipFile;
    private final DocumentFactory underlyingFactory;
    private transient DocumentFactory factory;
    private final int numberOfDocuments;
    private final boolean exact;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$ZipDocumentCollection;

    private final Object readResolve() throws IOException {
        return new ZipDocumentCollection(this.zipFilename, this.underlyingFactory, this.numberOfDocuments, this.exact);
    }

    public DocumentFactory factory() {
        return this.factory;
    }

    public int size() {
        return this.numberOfDocuments;
    }

    private final ZipEntry getEntry(int index) {
        this.ensureDocumentIndex(index);
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        if (entry == null) {
            throw new NoSuchElementException("Failure retrieving entry " + index);
        }
        return entry;
    }

    public Document document(int index) throws IOException {
        ZipEntry entry = this.getEntry(index);
        Reference2ObjectMap metadata = this.metadata(index, entry);
        InputStream is = this.zipFile.getInputStream(entry);
        return this.factory.getDocument(is, metadata);
    }

    private final Reference2ObjectMap metadata(int index, ZipEntry entry) {
        if (entry == null) {
            entry = this.getEntry(index);
        }
        Reference2ObjectOpenHashMap metadata = new Reference2ObjectOpenHashMap();
        metadata.put((Object)"title", (Object)entry.getComment());
        return metadata;
    }

    public Reference2ObjectMap metadata(int index) {
        return this.metadata(index, null);
    }

    public InputStream stream(int index) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        entry.getComment();
        InputStream is = this.zipFile.getInputStream(entry);
        return is;
    }

    public DocumentIterator iterator() {
        try {
            return new DocumentIterator(){
                final Reference2ObjectOpenHashMap metadata;
                ZipInputStream zis;

                public final Document nextDocument() throws IOException {
                    ZipEntry entry;
                    String name;
                    do {
                        if ((entry = this.zis.getNextEntry()) != null) continue;
                        return null;
                    } while (!Character.isDigit((name = entry.getName()).charAt(0)));
                    if (entry == null) {
                        return null;
                    }
                    String title = entry.getComment();
                    LOGGER.debug((Object)("Reading sequentially document " + title + ", name: " + entry.getName()));
                    InputStream is = ZipDocumentCollection.this.zipFile.getInputStream(entry);
                    MutableString uri = new MutableString();
                    uri.readSelfDelimUTF8(is);
                    this.metadata.put((Object)"title", (Object)title);
                    this.metadata.put((Object)"uri", (Object)uri.compact());
                    return ZipDocumentCollection.this.factory.getDocument(is, (Reference2ObjectMap)this.metadata);
                }

                public final void close() {
                }

                private final /* synthetic */ void this() {
                    this.metadata = new Reference2ObjectOpenHashMap();
                    this.zis = new ZipInputStream(new FileInputStream(ZipDocumentCollection.this.zipFile.getName()));
                }
                {
                    this.this();
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    static /* synthetic */ boolean access$3() {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ZipDocumentCollection(String zipFilename, DocumentFactory underlyingFactory, int numberOfDocuments, boolean exact) throws IOException {
        this.zipFilename = zipFilename;
        this.underlyingFactory = underlyingFactory;
        this.numberOfDocuments = numberOfDocuments;
        this.exact = exact;
        this.zipFile = new ZipFile(new File(zipFilename));
        this.factory = new ZipFactory(exact, underlyingFactory);
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollection;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollection = ZipDocumentCollection.class("[Lit.unimi.dsi.mg4j.document.ZipDocumentCollection;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }

    protected static class ZipFactory
    extends AbstractDocumentFactory {
        private final boolean exact;
        private final DocumentFactory underlyingFactory;

        public int numberOfFields() {
            return this.underlyingFactory.numberOfFields();
        }

        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldName(field);
        }

        public int fieldIndex(String fieldName) {
            return this.underlyingFactory.fieldIndex(fieldName);
        }

        public int fieldType(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldType(field);
        }

        public Document getDocument(final InputStream rawContent, final Reference2ObjectMap metadata) throws IOException {
            return new Document(){
                int nextFieldToRead;
                final MutableString uri;

                public final CharSequence title() {
                    return (CharSequence)metadata.get((Object)"title");
                }

                public final String toString() {
                    return this.title().toString();
                }

                public final CharSequence uri() {
                    return this.uri;
                }

                private final void skipOneField() throws IOException, ClassNotFoundException {
                    if (ZipFactory.this.fieldType(this.nextFieldToRead) != 0) {
                        new ObjectInputStream(rawContent).readObject();
                    } else {
                        MutableString word = new MutableString();
                        MutableString nonWord = new MutableString();
                        do {
                            word.readSelfDelimUTF8(rawContent);
                            if (!ZipFactory.this.exact) continue;
                            nonWord.readSelfDelimUTF8(rawContent);
                        } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                    }
                    ++this.nextFieldToRead;
                }

                /*
                 * Unable to fully structure code
                 */
                private final void skipToField(int field) throws IOException, ClassNotFoundException {
                    if (this.nextFieldToRead <= field) ** GOTO lbl4
                    throw new IllegalStateException("Trying to skip to field " + field + " after " + this.nextFieldToRead);
lbl-1000:
                    // 1 sources

                    {
                        this.skipOneField();
lbl4:
                        // 2 sources

                        ** while (this.nextFieldToRead < field)
                    }
lbl5:
                    // 1 sources

                }

                public final Object content(final int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    Object result = null;
                    LOGGER.debug((Object)("Called content(" + field + "); nextField:" + this.nextFieldToRead));
                    try {
                        this.skipToField(field);
                        if (ZipFactory.this.fieldType(this.nextFieldToRead) != 0) {
                            result = new ObjectInputStream(rawContent).readObject();
                            ++this.nextFieldToRead;
                        } else {
                            result = new Reader(){
                                FastBufferedReader fbr;
                                int f;

                                public final void close() {
                                }

                                public final int read(char[] cbuf, int off, int len) throws IOException {
                                    if (this.fbr == null) {
                                        MutableString text = new MutableString();
                                        MutableString word = new MutableString();
                                        MutableString nonWord = new MutableString();
                                        do {
                                            text.append(word.readSelfDelimUTF8(rawContent));
                                            if (!ZipFactory.this.exact) continue;
                                            text.append(nonWord.readSelfDelimUTF8(rawContent));
                                        } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                                        this.fbr = new FastBufferedReader(text);
                                        ++nextFieldToRead;
                                    }
                                    return this.fbr.read(cbuf, off, len);
                                }

                                private final /* synthetic */ void this() {
                                    this.fbr = null;
                                    this.f = field;
                                }
                                {
                                    this.this();
                                }
                            };
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    return result;
                }

                public final WordReader wordReader(int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    LOGGER.debug((Object)("Called wordReader(" + field + ')'));
                    try {
                        this.skipToField(field);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (ZipFactory.this.fieldType(field) != 0) {
                        return null;
                    }
                    return new WordReader(){

                        public final boolean next(MutableString word, MutableString nonWord) throws IOException {
                            boolean goOn;
                            word.readSelfDelimUTF8(rawContent);
                            if (ZipFactory.this.exact) {
                                nonWord.readSelfDelimUTF8(rawContent);
                            } else {
                                nonWord.length(0);
                            }
                            boolean bl = false;
                            if (word.length() != 0 || ZipFactory.this.exact && nonWord.length() != 0) {
                                bl = true;
                            }
                            if (!(goOn = bl)) {
                                ++nextFieldToRead;
                            }
                            return goOn;
                        }

                        public final WordReader setReader(Reader reader) {
                            return this;
                        }

                        public final WordReader copy() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public final void close() {
                }

                private final /* synthetic */ void this() {
                    this.nextFieldToRead = 0;
                    this.uri = new MutableString();
                    this.uri.readSelfDelimUTF8(rawContent).compact();
                }
                {
                    this.this();
                }
            };
        }

        protected ZipFactory(boolean exact, DocumentFactory underlyingFactory) {
            this.exact = exact;
            this.underlyingFactory = underlyingFactory;
        }
    }
}

