/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.ZipDocumentCollection;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.tool.Index;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.ProgressLogger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipDocumentCollectionBuilder {
    private static final Logger LOGGER;
    private ZipOutputStream zipOut;
    private int numberOfDocuments;
    private boolean exact;
    private final ProgressLogger progressLogger;
    private final String zipFilename;
    private final DocumentFactory factory;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$ZipDocumentCollectionBuilder;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;

    public void startDocument(CharSequence title, CharSequence uri) throws IOException {
        ZipEntry currEntry = new ZipEntry(Integer.toString(this.numberOfDocuments));
        currEntry.setComment(title.toString());
        this.zipOut.putNextEntry(currEntry);
        new MutableString(uri).writeSelfDelimUTF8(this.zipOut);
    }

    public void endDocument() throws IOException {
        this.zipOut.closeEntry();
        ++this.numberOfDocuments;
    }

    public void startTextField() {
    }

    public void nonTextField(Object o) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(this.zipOut);
        oos.writeObject(o);
        oos.flush();
    }

    public void endTextField() throws IOException {
        this.zipOut.write(0);
        if (this.exact) {
            this.zipOut.write(0);
        }
    }

    public void add(MutableString word, MutableString nonWord) throws IOException {
        if (this.exact || word.length() > 0) {
            word.writeSelfDelimUTF8(this.zipOut);
        }
        if (this.exact) {
            nonWord.writeSelfDelimUTF8(this.zipOut);
        }
    }

    public ZipDocumentCollection close() throws IOException {
        this.zipOut.close();
        return new ZipDocumentCollection(this.zipFilename, this.factory, this.numberOfDocuments, this.exact);
    }

    public ZipDocumentCollection build(DocumentSequence inputSequence) throws IOException {
        this.progressLogger.start("Zipping collection...");
        this.numberOfDocuments = 0;
        DocumentIterator docIt = inputSequence.iterator();
        if (this.factory != inputSequence.factory()) {
            throw new IllegalStateException("The factory provided by the constructor does not correspond to the factory of the input sequence");
        }
        int numberOfFields = this.factory.numberOfFields();
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        while (true) {
            this.progressLogger.update();
            Document document = docIt.nextDocument();
            if (document == null) break;
            this.startDocument(document.title(), document.uri());
            int field = 0;
            while (field < numberOfFields) {
                Object content = document.content(field);
                if (this.factory.fieldType(field) == 0) {
                    this.startTextField();
                    WordReader wordReader = document.wordReader(field);
                    wordReader.setReader((Reader)content);
                    while (wordReader.next(word, nonWord)) {
                        this.add(word, nonWord);
                    }
                    this.endTextField();
                } else {
                    this.nonTextField(content);
                }
                ++field;
            }
            this.endDocument();
        }
        this.progressLogger.done();
        return this.close();
    }

    public static void main(String[] arg) throws JSAPException, IOException, ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IllegalArgumentException, SecurityException, InstantiationException {
        Class clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollectionBuilder;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollectionBuilder = ZipDocumentCollectionBuilder.class("[Lit.unimi.dsi.mg4j.document.ZipDocumentCollectionBuilder;", false);
        }
        String string = clazz.getName();
        Parameter[] parameterArray = new Parameter[8];
        parameterArray[0] = new FlaggedOption("sequence", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'S', "sequence", "A serialised document sequence that will be used instead of stdin.");
        Class clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory;
        if (clazz2 == null) {
            clazz2 = class$it$unimi$dsi$mg4j$document$IdentityDocumentFactory = ZipDocumentCollectionBuilder.class("[Lit.unimi.dsi.mg4j.document.IdentityDocumentFactory;", false);
        }
        parameterArray[1] = new FlaggedOption("factory", (StringParser)JSAP.CLASS_PARSER, clazz2.getName(), false, 'f', "factory", "A document factory with a standard constructor.");
        parameterArray[2] = new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true);
        parameterArray[3] = new FlaggedOption("delimiter", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(10), false, 'd', "delimiter", "The document delimiter.");
        parameterArray[4] = new Switch("approximated", 'a', "approximated", "If specified, non-words will not be copied.");
        parameterArray[5] = new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds.");
        parameterArray[6] = new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the output document collection.");
        parameterArray[7] = new UnflaggedOption("zipfile", (StringParser)JSAP.STRING_PARSER, true, "The filename for the output zip file.");
        SimpleJSAP jsap = new SimpleJSAP(string, "Produces a zip document collection from an existing document sequence.", parameterArray);
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentSequence documentSequence = Index.getSequence(jsapResult.getString("sequence"), jsapResult.getClass("factory"), jsapResult.getStringArray("property"), jsapResult.getInt("delimiter"));
        ProgressLogger progressLogger = new ProgressLogger(LOGGER, "documents");
        if (documentSequence instanceof DocumentCollection) {
            progressLogger.expectedUpdates = ((DocumentCollection)documentSequence).size();
        }
        ZipDocumentCollectionBuilder builder = new ZipDocumentCollectionBuilder(jsapResult.getString("zipfile"), documentSequence.factory(), jsapResult.getBoolean("approximated") ^ true, progressLogger);
        BinIO.storeObject((Object)builder.build(documentSequence), (CharSequence)jsapResult.getString("collection"));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public ZipDocumentCollectionBuilder(String zipFilename, DocumentFactory factory, boolean exact, ProgressLogger progressLogger) throws FileNotFoundException {
        this.zipFilename = zipFilename;
        this.factory = factory;
        this.zipOut = new ZipOutputStream(new FileOutputStream(zipFilename));
        this.exact = exact;
        this.progressLogger = progressLogger;
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollectionBuilder;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$document$ZipDocumentCollectionBuilder = ZipDocumentCollectionBuilder.class("[Lit.unimi.dsi.mg4j.document.ZipDocumentCollectionBuilder;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }
}

