/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.Iterators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.NullTermProcessor;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Index
implements CompressionFlags,
Serializable {
    private static final Logger LOGGER;
    public final String field;
    public final Properties properties;
    public final int numberOfDocuments;
    public final int numberOfTerms;
    public final int maxCount;
    public final boolean hasCounts;
    public final boolean hasPositions;
    public final TermProcessor termProcessor;
    public final Set singletonSet;
    public final TermMap termMap;
    public final PrefixMap prefixMap;
    public IntList sizes;
    public final EmptyDocumentIterator emptyDocumentIterator;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$Index;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$TermMap;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$PrefixMap;

    protected static long string2Flags(String flagString) {
        long flags = 0L;
        if (flagString.length() != 0) {
            String[] f = flagString.split("\\|");
            int i = 0;
            while (i < f.length) {
                try {
                    Class clazz = class$it$unimi$dsi$mg4j$index$Index;
                    if (clazz == null) {
                        clazz = Index.class("[Lit.unimi.dsi.mg4j.index.Index;", false);
                    }
                    Field field = clazz.getField(f[i].trim());
                    Class clazz2 = class$it$unimi$dsi$mg4j$index$Index;
                    if (clazz2 == null) {
                        clazz2 = Index.class("[Lit.unimi.dsi.mg4j.index.Index;", false);
                    }
                    flags |= field.getLong(clazz2);
                }
                catch (Exception notFound) {
                    throw new IllegalArgumentException("Compression flag " + f[i] + " unknown.");
                }
                ++i;
            }
        }
        return flags;
    }

    protected static boolean hasCounts(Properties properties) {
        long flags = Index.string2Flags(properties.getString("compressionflags"));
        boolean bl = false;
        if ((int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL) != 255) {
            bl = true;
        }
        return bl;
    }

    protected static boolean hasPositions(Properties properties) {
        long flags = Index.string2Flags(properties.getString("compressionflags"));
        boolean bl = false;
        if ((int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL) != 255) {
            bl = true;
        }
        return bl;
    }

    protected static TermProcessor getTermProcessor(Properties properties) {
        try {
            if (properties.getProperty("termprocessor") != null) {
                Class<?> termProcessorClass = Class.forName(properties.getString("termprocessor"));
                return (TermProcessor)termProcessorClass.getMethod("getInstance", null).invoke(termProcessorClass, null);
            }
            return NullTermProcessor.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LongList readOffsets(InputBitStream in, int T) throws IOException {
        long[] offset = new long[T + 1];
        LOGGER.debug((Object)"Loading offsets...");
        offset[0] = in.readLongGamma();
        int i = 0;
        while (i < T) {
            offset[i + 1] = in.readLongGamma() + offset[i];
            ++i;
        }
        LOGGER.debug((Object)"Completed.");
        return LongArrayList.wrap((long[])offset);
    }

    public static IntList readSizes(InputBitStream in, int N) throws IOException {
        int[] size = new int[N];
        LOGGER.debug((Object)"Loading sizes...");
        int i = 0;
        while (i < N) {
            size[i] = in.readGamma();
            ++i;
        }
        LOGGER.debug((Object)"Completed.");
        return IntArrayList.wrap((int[])size);
    }

    public static TermMap loadTermMap(String filename) throws IOException {
        try {
            return (TermMap)BinIO.loadObject((CharSequence)filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrefixMap loadPrefixMap(String filename) throws IOException {
        try {
            return (PrefixMap)BinIO.loadObject((CharSequence)filename);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Index getInstance(CharSequence basename, TermMap termMap, PrefixMap prefixMap, boolean randomAccess, boolean documentSizes) {
        Properties properties;
        try {
            LOGGER.debug((Object)("Searching for an index with basename " + basename + "..."));
            properties = new Properties(basename + ".properties");
            LOGGER.debug((Object)("Properties: " + properties));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            Class clazz;
            Class clazz2;
            Class<?> clazz3 = Class.forName(properties.getString("indexclass", "(missing index class)"));
            Class[] classArray = new Class[5];
            Class clazz4 = class$java$lang$CharSequence;
            if (clazz4 == null) {
                clazz4 = classArray[0] = (class$java$lang$CharSequence = Index.class("[Ljava.lang.CharSequence;", false));
            }
            if ((clazz2 = class$it$unimi$dsi$mg4j$index$TermMap) == null) {
                clazz2 = classArray[1] = (class$it$unimi$dsi$mg4j$index$TermMap = Index.class("[Lit.unimi.dsi.mg4j.index.TermMap;", false));
            }
            if ((clazz = class$it$unimi$dsi$mg4j$index$PrefixMap) == null) {
                clazz = class$it$unimi$dsi$mg4j$index$PrefixMap = Index.class("[Lit.unimi.dsi.mg4j.index.PrefixMap;", false);
            }
            classArray[2] = clazz;
            classArray[3] = Boolean.TYPE;
            classArray[4] = Boolean.TYPE;
            Constructor<?> constructor = clazz3.getDeclaredConstructor(classArray);
            return (Index)constructor.newInstance(basename, termMap, prefixMap, randomAccess, documentSizes);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            LOGGER.error((Object)("The Index factory was not able to locate a suitable constructor for the index class " + properties.getString("indexclass", "(missing index class)")));
            throw new RuntimeException(e);
        }
    }

    public static Index getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes) throws IOException {
        TermMap termMap = Index.loadTermMap(basename + ".termmap");
        if (termMap != null && termMap instanceof PrefixMap) {
            return Index.getInstance(basename, termMap, (PrefixMap)((Object)termMap), randomAccess, documentSizes);
        }
        PrefixMap prefixMap = Index.loadPrefixMap(basename + ".prefixmap");
        if (termMap != null) {
            return Index.getInstance(basename, termMap, prefixMap, randomAccess, documentSizes);
        }
        if (prefixMap != null && prefixMap instanceof TermMap) {
            return Index.getInstance(basename, (TermMap)((Object)prefixMap), prefixMap, randomAccess, documentSizes);
        }
        return Index.getInstance(basename, null, prefixMap, randomAccess, documentSizes);
    }

    public static Index getInstance(CharSequence basename, boolean randomAccess) throws IOException {
        return Index.getInstance(basename, randomAccess, false);
    }

    public static Index getInstance(CharSequence basename) throws IOException {
        if (basename.subSequence(0, 4).equals("mg4j")) {
            Index remoteIndex = null;
            try {
                Class<?> clazz = Class.forName("index.RemoteIndex");
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$lang$CharSequence;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$CharSequence = Index.class("[Ljava.lang.CharSequence;", false);
                }
                classArray[0] = clazz2;
                remoteIndex = (Index)clazz.getMethod("getInstance", classArray).invoke(null, basename);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return remoteIndex;
        }
        return Index.getInstance(basename, true);
    }

    public abstract IndexReader getReader() throws IOException;

    public abstract IndexReader getReader(int var1) throws IOException;

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.emptyDocumentIterator = new EmptyDocumentIterator();
    }

    protected Index(int numberOfDocuments, int numberOfTerms, int maxCount, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, Properties properties, TermMap termMap, PrefixMap prefixMap) {
        this.this();
        this.field = field;
        this.properties = properties;
        this.numberOfDocuments = numberOfDocuments;
        this.numberOfTerms = numberOfTerms;
        this.maxCount = maxCount;
        this.hasCounts = hasCounts;
        this.hasPositions = hasPositions;
        this.termProcessor = termProcessor;
        this.termMap = termMap;
        this.prefixMap = prefixMap;
        this.singletonSet = ObjectSets.singleton((Object)this);
    }

    protected Index(Properties properties, TermMap termMap, PrefixMap prefixMap) {
        this(properties.getInt("documents"), properties.getInt("terms"), properties.getInt("maxcount"), Index.hasCounts(properties), Index.hasPositions(properties), Index.getTermProcessor(properties), properties.getString("field"), properties, termMap, prefixMap);
    }

    static {
        Class clazz = class$it$unimi$dsi$mg4j$index$Index;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$Index = Index.class("[Lit.unimi.dsi.mg4j.index.Index;", false);
        }
        LOGGER = Fast.getLogger(clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EmptyDocumentIterator
    extends Iterators.EmptyIterator
    implements IndexIterator,
    Serializable {
        public int document() {
            return -1;
        }

        public Set indices() {
            return Index.this.singletonSet;
        }

        public IntervalIterator intervalIterator() {
            throw new IllegalStateException();
        }

        public Map intervalIterators() {
            throw new IllegalStateException();
        }

        public IntervalIterator intervalIterator(Index index) {
            throw new IllegalStateException();
        }

        public int nextDocument() {
            throw new NoSuchElementException();
        }

        public int skipTo(int n) {
            return -1;
        }

        public int frequency() {
            throw new IllegalStateException();
        }

        public int count() {
            throw new IllegalStateException();
        }

        public IntIterator positions() {
            throw new IllegalStateException();
        }

        public int positions(int[] positions) {
            throw new IllegalStateException();
        }

        public int[] positionArray() {
            throw new IllegalStateException();
        }

        public void dispose() {
        }

        protected EmptyDocumentIterator() {
        }
    }
}

