/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.io.ArithmeticCoder;
import it.unimi.dsi.mg4j.io.InterpolativeCoding;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.Properties;
import jal.ints.Sorting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IndexWriter
implements CompressionFlags {
    private static final boolean ASSERTS = true;
    protected static final int BEFORE_INVERTED_LIST = 0;
    protected static final int BEFORE_FREQUENCY = 1;
    protected static final int BEFORE_DOCUMENT_RECORD = 2;
    protected static final int BEFORE_POINTER = 3;
    protected static final int BEFORE_COUNT = 4;
    protected static final int BEFORE_POSITIONS = 5;
    protected static final int FIRST_UNUSED_STATE = 6;
    protected OutputBitStream obs;
    private OutputBitStream offset;
    protected int state;
    protected int numberOfDocuments;
    protected int frequency;
    protected double relativeFrequency;
    protected int writtenDocuments;
    protected int currentDocument;
    protected int currentTerm;
    protected int lastDocument;
    private long lastInvertedListPos;
    protected int b;
    protected int log2b;
    protected int maxCount;
    public long bitsForFrequencies;
    public long bitsForPointers;
    public long bitsForCounts;
    public long bitsForPositions;
    public long flags;
    private int frequencyCoding;
    protected int pointerCoding;
    private int countCoding;
    private int positionCoding;
    public final boolean hasCounts;
    public final boolean hasPositions;
    private int[] sortedDeltas;
    private CharSequence basename;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$FileIndex;
    static /* synthetic */ Class class$it$unimi$dsi$mg4j$index$CompressionFlags;
    private static final /* synthetic */ boolean assert;

    public long newInvertedList() throws IOException, IllegalStateException {
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ')');
        }
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException("Trying to start new inverted list in state " + this.state);
        }
        long pos = this.obs.writtenBits();
        this.writtenDocuments = 0;
        ++this.currentTerm;
        this.currentDocument = -1;
        if (this.offset != null) {
            this.offset.writeLongGamma(pos - this.lastInvertedListPos);
        }
        this.lastInvertedListPos = pos;
        this.state = 1;
        return pos;
    }

    public int writeFrequency(int frequency) throws IOException {
        int bitCount;
        if (this.state != 1) {
            throw new IllegalStateException("Trying to write frequency in state " + this.state);
        }
        switch (this.frequencyCoding) {
            case 2: {
                bitCount = this.obs.writeGamma(frequency - 1);
                break;
            }
            case 1: {
                bitCount = this.obs.writeDelta(frequency - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required frequency coding (" + this.frequencyCoding + ") is not supported.");
            }
        }
        this.frequency = frequency;
        this.relativeFrequency = (double)frequency / (double)this.numberOfDocuments;
        if (this.pointerCoding == 3) {
            this.b = Fast.golombModulus(this.relativeFrequency);
            this.log2b = Fast.mostSignificantBit(this.b);
        }
        this.state = 2;
        this.bitsForFrequencies += (long)bitCount;
        return bitCount;
    }

    public OutputBitStream newDocumentRecord() throws IOException, IllegalStateException {
        if (this.frequency == this.writtenDocuments) {
            throw new IllegalStateException("Document record overflow (written " + this.frequency + " already)");
        }
        if (this.state != 2) {
            throw new IllegalStateException("Trying to start new document record in state " + this.state);
        }
        ++this.writtenDocuments;
        this.lastDocument = this.currentDocument;
        this.state = 3;
        return this.obs;
    }

    public int writeDocumentPointer(OutputBitStream out, int pointer) throws IOException, IllegalStateException {
        if (this.state != 3) {
            throw new IllegalStateException("Trying to write pointer in state " + this.state);
        }
        this.currentDocument = pointer;
        int bitCount = 0;
        if (this.frequency != this.numberOfDocuments) {
            switch (this.pointerCoding) {
                case 2: {
                    bitCount = out.writeGamma(pointer - this.lastDocument - 1);
                    break;
                }
                case 1: {
                    bitCount = out.writeDelta(pointer - this.lastDocument - 1);
                    break;
                }
                case 3: {
                    bitCount = out.writeGolomb(pointer - this.lastDocument - 1, this.b, this.log2b);
                    break;
                }
                default: {
                    throw new IllegalStateException("The required pointer coding (" + this.pointerCoding + ") is not supported.");
                }
            }
        }
        this.state = this.hasCounts ? 4 : 2;
        this.bitsForPointers += (long)bitCount;
        return bitCount;
    }

    public void close() throws IOException, IllegalStateException, ConfigurationException {
        if (this.state != 2 && this.state != 0) {
            throw new IllegalStateException("Trying to close index in state " + this.state);
        }
        if (this.frequency >= 0 && this.frequency != this.writtenDocuments) {
            throw new IllegalStateException("The number of document records (" + this.writtenDocuments + ") does not match the frequency (" + this.frequency + ')');
        }
        if (this.writtenBits() != this.obs.writtenBits()) {
            throw new IllegalStateException("Written bits count mismatch: we say " + this.writtenBits() + ", the stream says " + this.obs.writtenBits());
        }
        if (this.offset != null) {
            this.offset.writeLongGamma(this.obs.writtenBits() - this.lastInvertedListPos);
            this.offset.close();
        }
        this.obs.close();
        if (this.basename != null) {
            File propertyFile = new File(this.basename + ".properties");
            if (!propertyFile.exists()) {
                propertyFile.createNewFile();
            }
            Properties properties = new Properties(propertyFile);
            properties.addAll((Configuration)this.properties());
            properties.save();
        }
    }

    public int writePositionCount(OutputBitStream out, int count) throws IOException, IllegalStateException {
        int bitCount;
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write count without calling newInvertedList");
        }
        if (this.state != 4) {
            throw new IllegalStateException("Trying to write count in state " + this.state);
        }
        switch (this.countCoding) {
            case 2: {
                bitCount = out.writeGamma(count - 1);
                break;
            }
            case 1: {
                bitCount = out.writeDelta(count - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required count coding (" + this.countCoding + ") is not supported.");
            }
        }
        this.state = this.hasPositions ? 5 : 2;
        this.bitsForCounts += (long)bitCount;
        return bitCount;
    }

    public int writeDocumentPositions(OutputBitStream out, int[] occ, int offset, int len, int docSize) throws IOException, IllegalStateException {
        int i;
        if (this.frequency < 0) {
            throw new IllegalStateException("Trying to write occurrences without calling newInvertedList");
        }
        if (this.state != 5) {
            throw new IllegalStateException("Trying to write positions in state " + this.state);
        }
        if (docSize > 0) {
            i = 0;
            while (i < len) {
                if (!assert && occ[offset + i] >= docSize) {
                    throw new AssertionError((Object)("Position " + occ[offset + i] + " for document " + this.currentDocument + " is too large; size is " + docSize));
                }
                ++i;
            }
        }
        int prev = -1;
        int bitCount = 0;
        int end = offset + len;
        switch (this.positionCoding) {
            case 2: {
                i = offset;
                while (i < end) {
                    bitCount += out.writeGamma(occ[i] - prev - 1);
                    prev = occ[i];
                    ++i;
                }
                break;
            }
            case 1: {
                i = offset;
                while (i < end) {
                    bitCount += out.writeDelta(occ[i] - prev - 1);
                    prev = occ[i];
                    ++i;
                }
                break;
            }
            case 3: {
                if (len < 3) {
                    i = 0;
                    while (i < len) {
                        bitCount += out.writeMinimalBinary(occ[i], docSize);
                        ++i;
                    }
                } else {
                    int positionB = Fast.golombModulus((double)len / (double)docSize);
                    int positionLog2b = Fast.mostSignificantBit(positionB);
                    i = offset;
                    while (i < end) {
                        bitCount += out.writeGolomb(occ[i] - prev - 1, positionB, positionLog2b);
                        prev = occ[i];
                        ++i;
                    }
                }
                break;
            }
            case 4: {
                if (len < 3) {
                    i = 0;
                    while (i < len) {
                        bitCount += out.writeMinimalBinary(occ[i], docSize);
                        ++i;
                    }
                } else {
                    if (this.sortedDeltas.length < len) {
                        this.sortedDeltas = new int[len];
                    }
                    System.arraycopy(occ, offset, this.sortedDeltas, 0, len);
                    i = len - 1;
                    while (i-- != 0) {
                        int n = i + 1;
                        this.sortedDeltas[n] = this.sortedDeltas[n] - (this.sortedDeltas[i] + 1);
                    }
                    Sorting.nth_element((int[])this.sortedDeltas, (int)0, (int)(len / 2), (int)len);
                    int sb = this.sortedDeltas[len / 2] + 1;
                    bitCount = out.writeMinimalBinary(sb - 1, docSize);
                    i = offset;
                    while (i < end) {
                        bitCount += out.writeSkewedGolomb(occ[i] - prev - 1, sb);
                        prev = occ[i];
                        ++i;
                    }
                }
                break;
            }
            case 5: {
                bitCount = out.writeMinimalBinary(occ[0], docSize);
                if (len <= 1) break;
                prev = 0;
                i = offset + 1;
                while (i < end) {
                    if (occ[i] - occ[i - 1] > prev) {
                        prev = occ[i] - occ[i - 1];
                    }
                    ++i;
                }
                bitCount += out.writeMinimalBinary(prev, docSize);
                ArithmeticCoder coder = new ArithmeticCoder(prev);
                i = offset + 1;
                while (i < end) {
                    bitCount += coder.encode(occ[i] - occ[i - 1] - 1, out);
                    ++i;
                }
                bitCount += coder.flush(out);
                break;
            }
            case 6: {
                bitCount = InterpolativeCoding.write(out, occ, 0, len, 0, docSize - 1);
                break;
            }
            default: {
                throw new IllegalStateException("The required position coding (" + this.positionCoding + ") is not supported.");
            }
        }
        this.state = 2;
        this.bitsForPositions += (long)bitCount;
        if (len > this.maxCount) {
            this.maxCount = len;
        }
        return bitCount;
    }

    public long writtenBits() {
        return this.bitsForFrequencies + this.bitsForPointers + this.bitsForCounts + this.bitsForPositions;
    }

    public Properties properties() {
        Properties result = new Properties();
        result.setProperty("documents", this.numberOfDocuments);
        result.setProperty("terms", this.currentTerm + 1);
        result.setProperty("maxcount", this.maxCount);
        Class clazz = class$it$unimi$dsi$mg4j$index$FileIndex;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$FileIndex = IndexWriter.class("[Lit.unimi.dsi.mg4j.index.FileIndex;", false);
        }
        result.setProperty("indexclass", clazz.getName());
        result.setProperty("compressionflags", IndexWriter.flags2String(this.flags));
        return result;
    }

    public static String flags2String(long flags) {
        Class clazz = class$it$unimi$dsi$mg4j$index$CompressionFlags;
        if (clazz == null) {
            clazz = class$it$unimi$dsi$mg4j$index$CompressionFlags = IndexWriter.class("[Lit.unimi.dsi.mg4j.index.CompressionFlags;", false);
        }
        Field[] fields = clazz.getFields();
        MutableString result = new MutableString();
        try {
            int i = 0;
            while (i < fields.length) {
                String fieldName = fields[i].getName();
                if (fieldName.endsWith("_SHIFT")) {
                    Field field = fields[i];
                    Class clazz2 = class$it$unimi$dsi$mg4j$index$CompressionFlags;
                    if (clazz2 == null) {
                        clazz2 = IndexWriter.class("[Lit.unimi.dsi.mg4j.index.CompressionFlags;", false);
                    }
                    int shift = field.getInt(clazz2);
                    String type = fieldName.substring(0, fieldName.length() - "_SHIFT".length());
                    long fieldPart = (int)(flags >>> shift & 0xFFL) << shift;
                    if (fieldPart != 0L) {
                        int j = 0;
                        while (j < fields.length) {
                            String subfieldName = fields[j].getName();
                            if (i != j && subfieldName.indexOf(type) >= 0 && subfieldName.indexOf("DEFAULT") < 0) {
                                Field field2 = fields[j];
                                Class clazz3 = class$it$unimi$dsi$mg4j$index$CompressionFlags;
                                if (clazz3 == null) {
                                    clazz3 = IndexWriter.class("[Lit.unimi.dsi.mg4j.index.CompressionFlags;", false);
                                }
                                if (fieldPart == field2.getLong(clazz3)) {
                                    if (result.length() > 0) {
                                        result.append(" | ");
                                    }
                                    result.append(subfieldName);
                                    break;
                                }
                            }
                            ++j;
                        }
                        if (j == fields.length) {
                            throw new RuntimeException("Could not unpack the " + fieldName + " compression flag");
                        }
                    }
                }
                ++i;
            }
            return result.toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.sortedDeltas = IntArrays.EMPTY_ARRAY;
        this.basename = null;
    }

    public IndexWriter(CharSequence basename, int numberOfDocuments, boolean writeOffsets, long flags) throws IOException {
        this(new OutputBitStream(new FileOutputStream(basename + ".index")), writeOffsets ? new OutputBitStream(new FileOutputStream(basename + ".offsets")) : null, numberOfDocuments, flags);
        this.basename = basename;
    }

    public IndexWriter(OutputBitStream obs, OutputBitStream offset, int numberOfDocuments, long flags) {
        this.this();
        this.obs = obs;
        this.offset = offset;
        this.numberOfDocuments = numberOfDocuments;
        this.frequency = -1;
        this.currentTerm = -1;
        this.maxCount = 0;
        this.flags = flags;
        this.frequencyCoding = (int)(((flags & 0xFFL) != 0L ? flags : (long)2) & 0xFFL);
        this.pointerCoding = (int)(((flags >>> 8 & 0xFFL) != 0L ? flags : 768L) >>> 8 & 0xFFL);
        this.countCoding = (int)(((flags >>> 16 & 0xFFL) != 0L ? flags : 131072L) >>> 16 & 0xFFL);
        boolean bl = false;
        if (this.countCoding != 255) {
            bl = this.hasCounts = true;
        }
        if (!this.hasCounts) {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0xFF000000L) >>> 24 & 0xFFL);
            if (this.positionCoding != 255) {
                throw new IllegalArgumentException("Index has positions but no counts (this can't happen)");
            }
        } else {
            this.positionCoding = (int)(((flags >>> 24 & 0xFFL) != 0L ? flags : 0x3000000L) >>> 24 & 0xFFL);
        }
        boolean bl2 = false;
        if (this.positionCoding != 255) {
            bl2 = this.hasPositions = true;
        }
        if (!this.hasCounts && this.hasPositions) {
            throw new IllegalArgumentException("Index has positions but no counts (this can't happen)");
        }
    }

    public IndexWriter(OutputBitStream obs, int numberOfDocuments, int flags) {
        this(obs, null, numberOfDocuments, (long)flags);
    }

    static {
        assert = Class.forName("[Lit.unimi.dsi.mg4j.index.IndexWriter;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

